/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureBuilder;
import de.pirckheimer_gymnasium.engine_pi.util.ColorUtil;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class Image
extends Actor {
    private BufferedImage image;
    private double width;
    private double height;
    private boolean flipVertical = false;
    private boolean flipHorizontal = false;

    @API
    public Image(String filepath, double width, double height) {
        super(() -> FixtureBuilder.rectangle(width, height));
        this.assertViableSizes(width, height);
        this.image = (BufferedImage)Resources.IMAGES.get(filepath);
        this.color = ColorUtil.calculateAverage(this.image);
        this.width = width;
        this.height = height;
    }

    @API
    public Image(String filepath, double pixelPerMeter) {
        super(() -> FixtureBuilder.rectangle((double)((BufferedImage)Resources.IMAGES.get(filepath)).getWidth() / pixelPerMeter, (double)((BufferedImage)Resources.IMAGES.get(filepath)).getHeight() / pixelPerMeter));
        this.assertViablePPM(pixelPerMeter);
        this.image = (BufferedImage)Resources.IMAGES.get(filepath);
        this.color = ColorUtil.calculateAverage(this.image);
        this.width = (double)this.image.getWidth() / pixelPerMeter;
        this.height = (double)this.image.getHeight() / pixelPerMeter;
    }

    @API
    public Image(BufferedImage image, double pixelPerMeter) {
        super(() -> FixtureBuilder.rectangle((double)image.getWidth() / pixelPerMeter, (double)image.getHeight() / pixelPerMeter));
        this.assertViablePPM(pixelPerMeter);
        this.image = image;
        this.color = ColorUtil.calculateAverage(this.image);
        this.width = (double)image.getWidth() / pixelPerMeter;
        this.height = (double)image.getHeight() / pixelPerMeter;
    }

    @Internal
    public Dimension getImageSizeInPx() {
        return new Dimension(this.image.getWidth(), this.image.getHeight());
    }

    @API
    public BufferedImage getImage() {
        return this.image;
    }

    public void resetImageSize(double width, double height) {
        this.assertViableSizes(width, height);
        this.width = width;
        this.height = height;
        this.setFixture(() -> FixtureBuilder.rectangle(width, height));
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public void resetPixelPerMeter(double pixelPerMeter) {
        this.assertViablePPM(pixelPerMeter);
        this.resetImageSize((double)this.image.getWidth() / pixelPerMeter, (double)this.image.getHeight() / pixelPerMeter);
    }

    private void assertViableSizes(double width, double height) {
        if (width <= 0.0 || height <= 0.0) {
            throw new IllegalArgumentException("Bildh\u00f6he und Breite m\u00fcssen gr\u00f6\u00dfer als 0 sein.");
        }
    }

    private void assertViablePPM(double pixelPerMeter) {
        if (pixelPerMeter <= 0.0) {
            throw new IllegalArgumentException("Die Umrechnungszahl f\u00fcr Pixel pro Meter darf nicht negativ sein. War " + pixelPerMeter);
        }
    }

    @API
    public void setFlipHorizontal(boolean flipHorizontal) {
        this.flipHorizontal = flipHorizontal;
    }

    @API
    public void setFlipVertical(boolean flipVertical) {
        this.flipVertical = flipVertical;
    }

    @API
    public boolean isFlipHorizontal() {
        return this.flipHorizontal;
    }

    @API
    public boolean isFlipVertical() {
        return this.flipVertical;
    }

    @Override
    public void render(Graphics2D g, double pixelPerMeter) {
        AffineTransform pre = g.getTransform();
        int imageH = this.image.getHeight();
        int imageW = this.image.getWidth();
        g.scale(this.width * pixelPerMeter / (double)imageW, this.height * pixelPerMeter / (double)imageH);
        g.drawImage(this.image, this.flipHorizontal ? imageW : 0, -imageH + (this.flipVertical ? imageH : 0), (this.flipHorizontal ? -1 : 1) * imageW, (this.flipVertical ? -1 : 1) * imageH, null);
        g.setTransform(pre);
    }

    public static void main(String[] args) {
        Game.start(new Scene(){
            {
                Image i1 = this.addImage("logo/logo.png", 40.0);
                i1.setCenter(0.0, 0.0);
            }
        });
    }
}

