/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.animation;

import de.pirckheimer_gymnasium.engine_pi.animation.AnimationMode;
import de.pirckheimer_gymnasium.engine_pi.animation.Interpolator;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.event.EventListeners;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListenerRegistration;
import java.util.function.Consumer;

public class ValueAnimator<Value>
implements FrameUpdateListener {
    private final Consumer<Value> consumer;
    private final Interpolator<Value> interpolator;
    private final AnimationMode mode;
    private double currentTime = 0.0;
    private final double duration;
    private boolean complete = false;
    private boolean paused = false;
    private boolean goingBackwards = false;
    private EventListeners<Consumer<Value>> completionListeners = new EventListeners();

    public ValueAnimator(double duration, Consumer<Value> consumer, Interpolator<Value> interpolator, AnimationMode mode, FrameUpdateListenerRegistration parent) {
        this.duration = duration;
        this.consumer = consumer;
        this.interpolator = interpolator;
        this.mode = mode;
        if (mode == AnimationMode.SINGLE) {
            this.addCompletionListener(v -> parent.removeFrameUpdateListener(this));
        }
    }

    @API
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @API
    public boolean isPaused() {
        return this.paused;
    }

    public ValueAnimator(double duration, Consumer<Value> consumer, Interpolator<Value> interpolator, FrameUpdateListenerRegistration parent) {
        this(duration, consumer, interpolator, AnimationMode.SINGLE, parent);
    }

    @API
    public void setProgress(double progress) {
        if (progress < 0.0 || progress > 1.0) {
            throw new IllegalArgumentException("Der eingegebene Progess muss zwischen 0 und 1 liegen. War " + progress);
        }
        this.goingBackwards = false;
        this.currentTime = this.duration * progress;
        this.interpolator.interpolate(progress);
    }

    @Override
    public void onFrameUpdate(double pastTime) {
        double progress;
        if (this.paused) {
            return;
        }
        if (!this.goingBackwards) {
            this.currentTime += pastTime;
            if (this.currentTime > this.duration) {
                switch (this.mode) {
                    case REPEATED: {
                        this.currentTime %= this.duration;
                        progress = this.currentTime / this.duration;
                        break;
                    }
                    case SINGLE: {
                        this.currentTime = this.duration;
                        progress = 1.0;
                        this.complete = true;
                        Object finalValue = this.interpolator.interpolate(1.0);
                        this.completionListeners.invoke(listener -> listener.accept(finalValue));
                        break;
                    }
                    case PINGPONG: {
                        this.goingBackwards = true;
                        progress = 1.0;
                        break;
                    }
                    default: {
                        progress = -1.0;
                        break;
                    }
                }
            } else {
                progress = this.currentTime / this.duration;
            }
        } else {
            this.currentTime -= pastTime;
            if (this.currentTime < 0.0) {
                this.goingBackwards = false;
                progress = 0.0;
            } else {
                progress = this.currentTime / this.duration;
            }
        }
        this.consumer.accept(this.interpolator.interpolate(progress));
    }

    public ValueAnimator<Value> addCompletionListener(Consumer<Value> listener) {
        if (this.complete) {
            listener.accept(this.interpolator.interpolate(1.0));
        } else {
            this.completionListeners.add(listener);
        }
        return this;
    }
}

