/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.event;

import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.event.MouseClickListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseClickListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.event.MouseScrollListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseScrollListenerRegistration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class EventListeners<T> {
    private final Collection<T> listeners = new LinkedHashSet<T>();
    private final Collection<T> listenerIterationCopy = new LinkedHashSet<T>();
    private final Collection<Runnable> pendingCopyModifications = new ArrayList<Runnable>();
    private final Supplier<EventListeners<T>> parentSupplier;
    private boolean iterating = false;

    public EventListeners() {
        this(() -> null);
    }

    public EventListeners(Supplier<EventListeners<T>> parentSupplier) {
        this.parentSupplier = parentSupplier;
    }

    @API
    public synchronized void add(T listener) {
        this.listeners.add(listener);
        if (this.iterating) {
            this.pendingCopyModifications.add(() -> this.listenerIterationCopy.add(listener));
        } else {
            this.listenerIterationCopy.add(listener);
        }
        EventListeners<T> parent = this.parentSupplier.get();
        if (parent != null) {
            parent.add(listener);
        }
    }

    @API
    public synchronized void remove(T listener) {
        this.listeners.remove(listener);
        if (this.iterating) {
            this.pendingCopyModifications.add(() -> this.listenerIterationCopy.remove(listener));
        } else {
            this.listenerIterationCopy.remove(listener);
        }
        EventListeners<T> parent = this.parentSupplier.get();
        if (parent != null) {
            parent.remove(listener);
        }
    }

    @API
    public synchronized boolean contains(T listener) {
        return this.listeners.contains(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @API
    public synchronized void invoke(Consumer<T> invoker) {
        if (this.iterating) {
            throw new IllegalStateException("Recursive invocation of event listeners is unsupported");
        }
        try {
            this.iterating = true;
            for (T listener : this.listenerIterationCopy) {
                invoker.accept(listener);
            }
            this.iterating = false;
        }
        catch (Throwable throwable) {
            this.iterating = false;
            for (Runnable pendingModification : this.pendingCopyModifications) {
                pendingModification.run();
            }
            this.pendingCopyModifications.clear();
            throw throwable;
        }
        for (Runnable pendingModification : this.pendingCopyModifications) {
            pendingModification.run();
        }
        this.pendingCopyModifications.clear();
    }

    @API
    public synchronized boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    @API
    public synchronized void clear() {
        this.listeners.clear();
    }

    public static void registerListeners(Object target) {
        if (target instanceof KeyStrokeListener) {
            ((KeyStrokeListenerRegistration)target).addKeyStrokeListener((KeyStrokeListener)target);
        }
        if (target instanceof MouseClickListener) {
            ((MouseClickListenerRegistration)target).addMouseClickListener((MouseClickListener)target);
        }
        if (target instanceof MouseScrollListener) {
            ((MouseScrollListenerRegistration)target).addMouseScrollListener((MouseScrollListener)target);
        }
        if (target instanceof FrameUpdateListener) {
            ((FrameUpdateListenerRegistration)target).addFrameUpdateListener((FrameUpdateListener)target);
        }
    }
}

