/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.graphics;

import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.graphics.RenderSource;
import de.pirckheimer_gymnasium.engine_pi.graphics.RenderTarget;
import java.awt.Canvas;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferStrategy;

public final class RenderPanel
extends Canvas
implements RenderTarget {
    public RenderPanel(int width, int height) {
        this.setSize(width, height);
        this.setPreferredSize(this.getSize());
        this.setBackground(Resources.getColor("black"));
    }

    public void allocateBuffers() {
        this.createBufferStrategy(2);
    }

    @Override
    public void render(RenderSource source) {
        BufferStrategy bufferStrategy = this.getBufferStrategy();
        while (true) {
            source.render((Graphics2D)bufferStrategy.getDrawGraphics(), this.getWidth(), this.getHeight());
            if (bufferStrategy.contentsRestored() && !Thread.currentThread().isInterrupted()) continue;
            if (!bufferStrategy.contentsLost()) {
                bufferStrategy.show();
                Toolkit.getDefaultToolkit().sync();
            }
            if (!bufferStrategy.contentsLost() || Thread.currentThread().isInterrupted()) break;
        }
    }
}

