/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.resources;

import de.pirckheimer_gymnasium.engine_pi.util.FileUtil;
import java.util.ArrayList;

final class DataFormat {
    private DataFormat() {
    }

    protected static <T extends Enum<T>> T get(String format, T[] values, T defaultValue) {
        if (format == null || format.isEmpty()) {
            return defaultValue;
        }
        String stripedImageFormat = format;
        if (stripedImageFormat.startsWith(".")) {
            stripedImageFormat = format.substring(1);
        }
        for (T val : values) {
            if (!stripedImageFormat.equalsIgnoreCase(((Enum)val).toString())) continue;
            return val;
        }
        return defaultValue;
    }

    protected static <T extends Enum<T>> boolean isSupported(String fileName, T[] values, T defaultValue) {
        String extension = FileUtil.getExtension(fileName);
        if (extension == null || extension.isEmpty()) {
            return false;
        }
        for (String supported : DataFormat.getAllExtensions(values, defaultValue)) {
            if (!extension.equalsIgnoreCase(supported)) continue;
            return true;
        }
        return false;
    }

    protected static <T extends Enum<T>> String[] getAllExtensions(T[] values, T defaultValue) {
        ArrayList<String> arrList = new ArrayList<String>();
        for (T format : values) {
            if (format == defaultValue) continue;
            arrList.add(((Enum)format).toString());
        }
        return arrList.toArray(new String[arrList.size()]);
    }
}

