/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.resources;

import de.pirckheimer_gymnasium.engine_pi.resources.ResourcesContainer;
import de.pirckheimer_gymnasium.engine_pi.util.ImageUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public final class ImageContainer
extends ResourcesContainer<BufferedImage> {
    @Override
    protected BufferedImage load(URL name) throws IOException {
        BufferedImage img = ImageIO.read(name);
        if (img == null) {
            return null;
        }
        return ImageUtil.toCompatibleImage(img);
    }

    public BufferedImage get(String name, int pixelMultiplication, String[] fromColors, String[] toColors) {
        BufferedImage image = (BufferedImage)this.get(name);
        if (pixelMultiplication > 1) {
            image = ImageUtil.scale(image, pixelMultiplication);
        }
        if (fromColors != null && toColors != null) {
            image = ImageUtil.replaceColors(image, fromColors, toColors);
        }
        return image;
    }

    public BufferedImage get(String name, int pixelMultiplication) {
        return this.get(name, pixelMultiplication, null, null);
    }

    public BufferedImage get(String name, String[] fromColors, String[] toColors) {
        return this.get(name, 1, fromColors, toColors);
    }
}

