/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.resources;

import de.pirckheimer_gymnasium.engine_pi.resources.Codec;
import de.pirckheimer_gymnasium.engine_pi.resources.NamedResource;
import de.pirckheimer_gymnasium.engine_pi.resources.SoundFormat;
import de.pirckheimer_gymnasium.engine_pi.sound.Sound;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundResource
extends NamedResource {
    private String data;
    private SoundFormat format = SoundFormat.UNSUPPORTED;

    public SoundResource() {
    }

    public SoundResource(Sound sound, SoundFormat format) {
        this.setName(sound.getName());
        this.data = Codec.encode(sound.getRawData());
        this.format = format;
    }

    public SoundResource(InputStream data, String name, SoundFormat format) throws IOException, UnsupportedAudioFileException {
        this(new Sound(data, name), format);
    }

    public String getData() {
        return this.data;
    }

    public SoundFormat getFormat() {
        return this.format;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setFormat(SoundFormat format) {
        this.format = format;
    }
}

