/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi;

import de.pirckheimer_gymnasium.engine_pi.Bounds;
import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import java.awt.Point;

public final class Camera {
    public static final double DEFAULT_METER = 30.0;
    private Vector position;
    private Bounds bounds;
    private Actor focus = null;
    private Vector offset = Vector.NULL;
    private double meter = 30.0;
    private double rotation = 0.0;

    @Internal
    public Camera() {
        this.position = new Vector(0.0, 0.0);
    }

    @API
    public void setFocus(Actor focus) {
        this.focus = focus;
    }

    @API
    public boolean hasFocus() {
        return this.focus != null;
    }

    @API
    public void setOffset(Vector offset) {
        this.offset = offset;
    }

    @API
    public Vector getOffset() {
        return this.offset;
    }

    @API
    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    @API
    public boolean hasBounds() {
        return this.bounds != null;
    }

    @API
    public void setMeter(double pixelCount) {
        if (pixelCount <= 0.0) {
            throw new IllegalArgumentException("Der Kamerazoom kann nicht kleiner oder gleich 0 sein.");
        }
        this.meter = pixelCount;
    }

    @API
    public double getMeter() {
        if (Game.isPixelMultiplication()) {
            return this.meter * (double)Game.getPixelMultiplication();
        }
        return this.meter;
    }

    @API
    public void moveBy(double x, double y) {
        this.moveBy(new Vector(x, y));
    }

    @API
    public void moveBy(Vector vector) {
        this.position = this.position.add(vector);
    }

    @API
    public void moveTo(int x, int y) {
        this.moveTo(new Vector(x, y));
    }

    @API
    public void moveTo(Vector vector) {
        this.position = vector;
    }

    @API
    public void rotateBy(double degree) {
        this.rotation += degree;
    }

    @API
    public void rotateTo(double degree) {
        this.rotation = degree;
    }

    @API
    public void setPosition(Vector position) {
        this.position = position;
    }

    @API
    public void setPostion(double x, double y) {
        this.setPosition(new Vector(x, y));
    }

    @API
    public Vector getPosition() {
        return this.moveIntoBounds(this.position.add(this.offset));
    }

    @Internal
    public Point toScreenPixelLocation(Vector locationInWorld, double pixelPerMeter) {
        Vector cameraRelativeLocInPx = this.position.multiply(pixelPerMeter);
        Vector frameSize = Game.getWindowSize();
        return new Point((int)(frameSize.getX() / 2.0 + cameraRelativeLocInPx.getX()), (int)(frameSize.getY() / 2.0 + cameraRelativeLocInPx.getY()));
    }

    public void onFrameUpdate() {
        if (this.hasFocus()) {
            this.position = this.focus.getCenter();
        }
        this.position = this.moveIntoBounds(this.position);
    }

    public double getRotation() {
        return this.rotation;
    }

    private Vector moveIntoBounds(Vector position) {
        if (!this.hasBounds()) {
            return position;
        }
        double x = Math.max(this.bounds.x(), Math.min(position.getX(), this.bounds.x() + this.bounds.width()));
        double y = Math.max(this.bounds.y(), Math.min(position.getY(), this.bounds.y() + this.bounds.height()));
        return new Vector(x, y);
    }
}

