/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi;

import de.pirckheimer_gymnasium.engine_pi.Direction;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import org.jbox2d.common.Vec2;

@API
public final class Vector
implements Cloneable {
    @API
    public static final Vector NULL = new Vector(0.0, 0.0);
    @API
    public static final Vector RIGHT = new Vector(1.0, 0.0);
    @API
    public static final Vector LEFT = new Vector(-1.0, 0.0);
    @API
    public static final Vector UP = new Vector(0.0, 1.0);
    @API
    public static final Vector DOWN = new Vector(0.0, -1.0);
    private final double x;
    private final double y;

    @Internal
    public static Vector of(Vec2 vector) {
        return new Vector(vector.x, vector.y);
    }

    @API
    public Vector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @API
    public Vector(Vector start, Vector end) {
        this.x = end.getX() - start.getX();
        this.y = end.getY() - start.getY();
    }

    public static Vector ofAngle(double angle) {
        double rad = Math.toRadians(angle);
        return new Vector(Math.cos(rad), Math.sin(rad));
    }

    @API
    public double getX() {
        return this.x;
    }

    @API
    public double getY() {
        return this.y;
    }

    @API
    public Vector normalize() {
        return this.divide(this.getLength());
    }

    @API
    public Vector divide(double divisor) {
        if (divisor == 0.0) {
            throw new ArithmeticException("Der Divisor f\u00fcr das Teilen war 0");
        }
        return new Vector(this.x / divisor, this.y / divisor);
    }

    @API
    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @API
    public Vector negate() {
        return new Vector(-this.x, -this.y);
    }

    @API
    public Vector negateX() {
        return new Vector(-this.x, this.y);
    }

    @API
    public Vector negateY() {
        return new Vector(this.x, -this.y);
    }

    @API
    public Vector add(double x, double y) {
        return new Vector(this.x + x, this.y + y);
    }

    @API
    public Vector add(Vector vector) {
        return new Vector(this.x + vector.x, this.y + vector.y);
    }

    @API
    public Vector subtract(double x, double y) {
        return new Vector(this.x - x, this.y - y);
    }

    @API
    public Vector subtract(Vector vector) {
        return new Vector(this.x - vector.x, this.y - vector.y);
    }

    @API
    public Vector rotate(double angle) {
        double rad = Math.toRadians(angle);
        return new Vector(Math.cos(rad) * this.x + Math.sin(rad) * this.y, -Math.sin(rad) * this.x + Math.cos(rad) * this.y);
    }

    @API
    public Vector getDistance(Vector vector) {
        return vector.subtract(this);
    }

    @API
    public Vector multiply(double factor) {
        return new Vector(this.x * factor, this.y * factor);
    }

    @API
    public Vector multiplyX(double factor) {
        return new Vector(this.x * factor, this.y);
    }

    @API
    public Vector multiplyY(double factor) {
        return new Vector(this.x, this.y * factor);
    }

    @API
    public double getScalarProduct(Vector vector) {
        return this.x * vector.x + this.y * vector.y;
    }

    @API
    public boolean isNull() {
        return this.x == 0.0 && this.y == 0.0;
    }

    @API
    public boolean isIntegral() {
        return this.x == (double)((int)this.x) && this.y == (double)((int)this.y);
    }

    @API
    public Direction getDirection() {
        if (this.x == 0.0 && this.y == 0.0) {
            return Direction.NONE;
        }
        if (this.x == 0.0) {
            return this.y > 0.0 ? Direction.DOWN : Direction.UP;
        }
        if (this.y == 0.0) {
            return this.x > 0.0 ? Direction.RIGHT : Direction.LEFT;
        }
        if (this.y < 0.0) {
            return this.x < 0.0 ? Direction.UP_LEFT : Direction.UP_RIGHT;
        }
        return this.x > 0.0 ? Direction.DOWN_LEFT : Direction.DOWN_RIGHT;
    }

    @API
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Vector) {
            Vector v = (Vector)object;
            return this.x == v.x && this.y == v.y;
        }
        return false;
    }

    public Vector clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public String toString() {
        return "Vector [ x = " + this.x + "; y = " + this.y + " ]";
    }

    @API
    public double getManhattanLength() {
        double length = this.x + this.y;
        return length < 0.0 ? -length : length;
    }

    @API
    public double getAngle(Vector other) {
        if (this.y < other.y) {
            return Math.toDegrees(Math.acos(this.getScalarProduct(other) / (this.getLength() * other.getLength())));
        }
        return 360.0 - Math.toDegrees(Math.acos(this.getScalarProduct(other) / (this.getLength() * other.getLength())));
    }

    @Internal
    public Vec2 toVec2() {
        return new Vec2((float)this.x, (float)this.y);
    }

    @API
    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y);
    }

    public static Vector vector(double x, double y) {
        return new Vector(x, y);
    }

    public static Vector v(double x, double y) {
        return new Vector(x, y);
    }
}

