/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.debug.ToStringFormatter;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureBuilder;
import de.pirckheimer_gymnasium.engine_pi.util.ColorUtil;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class Image
extends Actor {
    private BufferedImage image;
    private double width;
    private double height;
    private double pixelPerMeter;
    private boolean flippedVertically = false;
    private boolean flippedHorizontally = false;

    @API
    public Image(String filepath, double width, double height) {
        super(null);
        this.setImage(filepath, width, height);
    }

    @API
    public Image(String filepath, double pixelPerMeter) {
        super(null);
        this.setImage(filepath, pixelPerMeter);
    }

    @API
    public Image(BufferedImage image, double pixelPerMeter) {
        super(null);
        this.setImage(image, pixelPerMeter);
    }

    @Internal
    public Dimension getImageSizeInPx() {
        return new Dimension(this.image.getWidth(), this.image.getHeight());
    }

    @API
    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image, double width, double height) {
        this.assertViableSizes(width, height);
        this.image = image;
        this.width = width;
        this.height = height;
        this.color = ColorUtil.calculateAverage(image);
        this.setFixture(() -> FixtureBuilder.rectangle(width, height));
    }

    public void setImage(String filepath, double width, double height) {
        this.setImage(Resources.IMAGES.get(filepath), width, height);
    }

    public void setImage(BufferedImage image) {
        if (this.pixelPerMeter > 0.0) {
            this.setImage(image, this.pixelPerMeter);
        } else {
            this.image = image;
        }
    }

    public void setImage(BufferedImage image, double pixelPerMeter) {
        this.assertViablePPM(pixelPerMeter);
        this.pixelPerMeter = pixelPerMeter;
        this.setImage(image, (double)image.getWidth() / pixelPerMeter, (double)image.getHeight() / pixelPerMeter);
    }

    public void setImage(String filepath, double pixelPerMeter) {
        this.setImage(Resources.IMAGES.get(filepath), pixelPerMeter);
    }

    public void setImageSize(double width, double height) {
        this.assertViableSizes(width, height);
        this.width = width;
        this.height = height;
        this.setFixture(() -> FixtureBuilder.rectangle(width, height));
    }

    public void setImageSize(double pixelPerMeter) {
        this.assertViablePPM(pixelPerMeter);
        this.setImageSize((double)this.image.getWidth() / pixelPerMeter, (double)this.image.getHeight() / pixelPerMeter);
    }

    private void assertViableSizes(double width, double height) {
        if (width <= 0.0 || height <= 0.0) {
            throw new IllegalArgumentException("Bildh\u00f6he und Breite m\u00fcssen gr\u00f6\u00dfer als 0 sein.");
        }
    }

    private void assertViablePPM(double pixelPerMeter) {
        if (pixelPerMeter <= 0.0) {
            throw new IllegalArgumentException("Die Umrechnungszahl f\u00fcr Pixel pro Meter darf nicht negativ sein. War " + pixelPerMeter);
        }
    }

    @API
    public boolean isFlippedVertically() {
        return this.flippedVertically;
    }

    public boolean flipVertically() {
        this.setFlippedVertically(!this.isFlippedVertically());
        return this.isFlippedVertically();
    }

    @API
    public void setFlippedVertically(boolean flippedVertically) {
        this.flippedVertically = flippedVertically;
    }

    @API
    public boolean isFlippedHorizontally() {
        return this.flippedHorizontally;
    }

    public boolean flipHorizontally() {
        this.setFlippedHorizontally(!this.isFlippedHorizontally());
        return this.isFlippedHorizontally();
    }

    @API
    public void setFlippedHorizontally(boolean flippedHorizontally) {
        this.flippedHorizontally = flippedHorizontally;
    }

    @Override
    public void render(Graphics2D g, double pixelPerMeter) {
        AffineTransform pre = g.getTransform();
        int imageH = this.image.getHeight();
        int imageW = this.image.getWidth();
        g.scale(this.width * pixelPerMeter / (double)imageW, this.height * pixelPerMeter / (double)imageH);
        g.drawImage(this.image, this.flippedHorizontally ? imageW : 0, -imageH + (this.flippedVertically ? imageH : 0), (this.flippedHorizontally ? -1 : 1) * imageW, (this.flippedVertically ? -1 : 1) * imageH, null);
        g.setTransform(pre);
    }

    public String toString() {
        ToStringFormatter formatter = new ToStringFormatter("Image");
        formatter.add("width", this.width, "m");
        formatter.add("height", this.height, "m");
        formatter.add("imageWidth", this.image.getWidth(), "px");
        formatter.add("imageHeight", this.image.getHeight(), "px");
        if (this.pixelPerMeter > 0.0) {
            formatter.add("pixelPerMeter", this.pixelPerMeter);
        }
        if (this.isFlippedHorizontally()) {
            formatter.add("flippedHorizontally");
        }
        if (this.isFlippedVertically()) {
            formatter.add("flippedVertically");
        }
        return formatter.format();
    }

    public static void main(String[] args) {
        Game.start(new Scene(){
            {
                Image image = this.addImage("logo/logo.png", 40.0);
                image.setCenter(0.0, 0.0);
                this.addKeyStrokeListener(event -> {
                    switch (event.getKeyCode()) {
                        case 86: {
                            System.out.println(image.flipVertically());
                            break;
                        }
                        case 72: {
                            System.out.println(image.flipHorizontally());
                        }
                    }
                    System.out.println(image);
                });
            }
        });
    }
}

