/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.actor.Image;
import de.pirckheimer_gymnasium.engine_pi.actor.ImageFont;
import de.pirckheimer_gymnasium.engine_pi.util.TextAlignment;
import java.awt.Color;

public class ImageFontText
extends Image {
    private final ImageFont imageFont;
    private String content;
    private int lineWidth;
    private TextAlignment alignment;
    private Color color;
    private int pixelMultiplication;

    public ImageFontText(ImageFont imageFont, String content, int lineWidth, TextAlignment alignment, Color color, int pixelMultiplication, int pixelPerMeter) {
        super(imageFont.render(content, lineWidth, alignment, color, pixelMultiplication), (double)pixelPerMeter);
        this.imageFont = imageFont;
        this.content = content;
        this.lineWidth = lineWidth;
        this.alignment = alignment;
        this.color = color;
        this.pixelMultiplication = pixelMultiplication;
    }

    public ImageFontText(ImageFont imageFont, String content, int lineWidth, TextAlignment alignment, Color color, int pixelMultiplication) {
        this(imageFont, content, lineWidth, alignment, color, pixelMultiplication, imageFont.getGlyphWidth());
    }

    public ImageFontText(ImageFont imageFont, String content, int lineWidth, TextAlignment alignment) {
        this(imageFont, content, lineWidth, alignment, imageFont.getColor(), imageFont.getPixelMultiplication());
    }

    public ImageFontText(ImageFont imageFont, String content) {
        this(imageFont, content, imageFont.getLineWidth(), imageFont.getAlignment());
    }

    public void setContent(String content, int lineWidth, TextAlignment alignment, Color color, int pixelMultiplication) {
        this.setImage(this.imageFont.render(content, lineWidth, alignment, color, pixelMultiplication));
        this.content = content;
        this.lineWidth = lineWidth;
        this.alignment = alignment;
        this.color = color;
        this.pixelMultiplication = pixelMultiplication;
    }

    public void setContent(String content) {
        this.setContent(content, this.lineWidth, this.alignment, this.color, this.getPixelMultiplication());
    }

    public String getContent() {
        return this.content;
    }

    public int getPixelMultiplication() {
        return Math.max(this.pixelMultiplication, 1);
    }

    @Override
    public String toString() {
        return String.format("ImageFontText[\n  %s,\n  %s\n]", this.imageFont, super.toString());
    }
}

