/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.animation;

import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

@Internal
public final class AnimationFrame {
    private final BufferedImage image;
    private double duration;

    @Internal
    public AnimationFrame(BufferedImage image, double duration) {
        this.image = image;
        this.duration = duration;
    }

    @Internal
    public void setDuration(double duration) {
        this.duration = duration;
    }

    @Internal
    public BufferedImage getImage() {
        return this.image;
    }

    @Internal
    public double getDuration() {
        return this.duration;
    }

    @Internal
    public void render(Graphics2D g, double width, double height, boolean flipHorizontal, boolean flipVertical) {
        AffineTransform pre = g.getTransform();
        g.scale(width / (double)this.image.getWidth(), height / (double)this.image.getHeight());
        g.drawImage(this.image, flipHorizontal ? this.image.getWidth() : 0, -this.image.getHeight() + (flipVertical ? this.image.getHeight() : 0), (flipHorizontal ? -1 : 1) * this.image.getWidth(), (flipVertical ? -1 : 1) * this.image.getHeight(), null);
        g.setTransform(pre);
    }
}

