/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.event;

import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListenerRegistration;

@Internal
public final class SingleTask
implements FrameUpdateListener {
    private final double delay;
    private double countdown;
    private final Runnable runnable;
    private boolean done;
    private final FrameUpdateListenerRegistration parent;

    public SingleTask(double delayInSeconds, Runnable runnable, FrameUpdateListenerRegistration parent) {
        this.delay = delayInSeconds;
        this.countdown = delayInSeconds;
        this.runnable = runnable;
        this.parent = parent;
    }

    @API
    public double getDelay() {
        return this.delay;
    }

    @API
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void onFrameUpdate(double pastTime) {
        this.countdown -= pastTime;
        if (!this.done && this.countdown < 0.0) {
            this.runnable.run();
            this.parent.removeFrameUpdateListener(this);
            this.done = true;
        }
    }
}

