/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.resources;

import de.pirckheimer_gymnasium.engine_pi.resources.ColorScheme;
import de.pirckheimer_gymnasium.engine_pi.resources.Container;
import de.pirckheimer_gymnasium.engine_pi.util.ColorUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ColorContainer
implements Container<Color> {
    private final Map<String, Color> resources = new LinkedHashMap<String, Color>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    private String normalizeName(String name) {
        return name.toLowerCase().replaceAll("\\s", "").replaceAll("-", "").replaceAll("_", "").replaceAll("\u00e4", "ae").replaceAll("\u00f6", "oe").replaceAll("\u00fc", "ue").replaceAll("\u00df", "ss");
    }

    @Override
    public Color add(String name, Color color) {
        this.resources.put(this.normalizeName(name), color);
        return color;
    }

    @Override
    public Color add(String name, String color) {
        return this.add(this.normalizeName(name), ColorUtil.decode(color));
    }

    public Color add(String name, Color color, String ... alias) {
        for (String a : alias) {
            this.aliases.put(this.normalizeName(a), name);
        }
        return this.add(name, color);
    }

    public Color add(String name, String color, String ... alias) {
        return this.add(this.normalizeName(name), ColorUtil.decode(color), alias);
    }

    public void addScheme(ColorScheme schema) {
        this.clear();
        this.add("yellow", schema.getYellow(), "Gelb");
        this.add("yellow orange", schema.getYellowOrange(), "orange yellow", "gold", "Gelb-Orange", "Orange-Gelb", "Golden", "Dunkelgelb");
        this.add("orange", schema.getOrange());
        this.add("red orange", schema.getRedOrange(), "orange red", "brick red", "brick", "Rot-Orange", "Orange-Rot", "Ziegelrot", "Hellrot");
        this.add("red", schema.getRed(), "Rot");
        this.add("red purple", schema.getRedPurple(), "purple red", "pink", "Rot-Violett", "Violett-Rot", "Rosa");
        this.add("purple", schema.getPurple(), "Violet", "Violett", "Lila");
        this.add("blue purple", schema.getBluePurple(), "purple blue", "indigo", "Violett Blau", "Blau Violett");
        this.add("blue", schema.getBlue(), "Blau");
        this.add("blue green", schema.getBlueGreen(), "green blue", "cyan", "Blau-Gr\u00fcn", "Gr\u00fcn-Blau", "T\u00fcrkis");
        this.add("green", schema.getGreen(), "Gr\u00fcn");
        this.add("yellow green", schema.getYellowGreen(), "green yellow", "lime", "lime green", "Gelb-Gr\u00fcn", "Gr\u00fcn-Gelb", "Limetten Gr\u00fcn", "Limette", "Hellgr\u00fcn");
        this.add("brown", schema.getBrown(), "Braun");
        this.add("white", schema.getWhite(), "Wei\u00df");
        this.add("gray", schema.getGray(), "grey", "Grau");
        this.add("black", schema.getBlack(), "Schwarz");
    }

    public Map<String, Color> getAll() {
        return this.resources;
    }

    @Override
    public void clear() {
        this.resources.clear();
        this.aliases.clear();
    }

    @Override
    public Color get(String name) {
        String alias;
        Color color = this.resources.get(name = this.normalizeName(name));
        if (color == null && (alias = this.aliases.get(name)) != null) {
            return this.resources.get(alias);
        }
        if (color == null && ColorUtil.isHexColorString(name)) {
            return ColorUtil.decode(name);
        }
        if (color == null) {
            throw new RuntimeException("Unbekannte Farbe: " + name);
        }
        return color;
    }

    public Color get(String name, int alpha) {
        return ColorUtil.changeAlpha(this.get(name), alpha);
    }
}

