/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.actor.ImageFontCaseSensitivity;
import de.pirckheimer_gymnasium.engine_pi.debug.ToStringFormatter;
import de.pirckheimer_gymnasium.engine_pi.util.ImageUtil;
import de.pirckheimer_gymnasium.engine_pi.util.TextAlignment;
import de.pirckheimer_gymnasium.engine_pi.util.TextUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class ImageFont {
    private String basePath;
    private int glyphWidth;
    private int glyphHeight;
    private String extension;
    private int pixelMultiplication = 1;
    private Color color;
    private ImageFontCaseSensitivity caseSensitivity;
    private int lineWidth = -1;
    private TextAlignment alignment;
    private final Map<Character, String> map = new HashMap<Character, String>();
    private boolean throwException = true;

    public ImageFont(String basePath, int glyphWidth, int glyphHeight, String extension, ImageFontCaseSensitivity caseSensitivity, TextAlignment alignment) {
        this.basePath = basePath;
        this.glyphWidth = glyphWidth;
        this.glyphHeight = glyphHeight;
        this.extension = extension;
        this.caseSensitivity = caseSensitivity;
        this.alignment = alignment;
        this.addMapping('.', "dot");
        this.addMapping(',', "comma");
        this.addMapping('\"', "quotes");
        this.addMapping('\u00a9', "copyright");
    }

    public ImageFont(String basePath, ImageFontCaseSensitivity caseSensitivity) {
        this(basePath, 8, 8, "png", caseSensitivity, TextAlignment.LEFT);
    }

    public ImageFont(String basePath) {
        this(basePath, null);
    }

    public ImageFont setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public ImageFont setGlyphWidth(int glyphWidth) {
        this.glyphWidth = glyphWidth;
        return this;
    }

    public int getGlyphWidth() {
        return this.glyphWidth;
    }

    public ImageFont setGlyphHeight(int glyphHeight) {
        this.glyphHeight = glyphHeight;
        return this;
    }

    public ImageFont setColor(Color color) {
        this.color = color;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public ImageFont setExtension(String extension) {
        this.extension = extension;
        return this;
    }

    public ImageFont setPixelMultiplication(int pixelMultiplication) {
        this.pixelMultiplication = pixelMultiplication;
        return this;
    }

    public int getPixelMultiplication() {
        return this.pixelMultiplication;
    }

    public ImageFont setCaseSensitivity(ImageFontCaseSensitivity caseSensitivity) {
        this.caseSensitivity = caseSensitivity;
        return this;
    }

    public ImageFont setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public int getLineWidth(String content) {
        if (this.lineWidth == -1) {
            return TextUtil.getLineWidth(content) + 1;
        }
        return this.lineWidth;
    }

    public int getLineWidth(String content, int lineWidth) {
        if (lineWidth == -1) {
            return TextUtil.getLineWidth(content) + 1;
        }
        return lineWidth;
    }

    public ImageFont setAlignment(TextAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public TextAlignment getAlignment() {
        return this.alignment;
    }

    public ImageFont setThrowException(boolean throwException) {
        this.throwException = throwException;
        return this;
    }

    private String convertGlyphToImageName(char glyph) {
        String filename = this.map.get(Character.valueOf(glyph));
        if (filename != null) {
            return filename;
        }
        return String.valueOf(glyph);
    }

    public ImageFont addMapping(char letter, String filename) {
        this.map.put(Character.valueOf(letter), filename);
        return this;
    }

    private String getImagePath(char glyph) {
        return this.basePath + "/" + this.convertGlyphToImageName(glyph) + "." + this.extension;
    }

    private BufferedImage loadBufferedImage(char glyph, String content) {
        if (glyph == ' ') {
            return null;
        }
        try {
            BufferedImage image = (BufferedImage)Resources.IMAGES.get(this.getImagePath(glyph));
            if (image != null) {
                image = ImageUtil.addAlphaChannel(image);
            }
            return image;
        }
        catch (Exception e) {
            if (this.throwException) {
                throw new RuntimeException("Unbekannter Buchstabe \u201e" + glyph + "\u201c im Text \u201e" + content + "\u201c.");
            }
            return null;
        }
    }

    private String processContent(String content, int lineWidth, TextAlignment alignment) {
        if (this.caseSensitivity == ImageFontCaseSensitivity.TO_UPPER) {
            content = content.toUpperCase();
        } else if (this.caseSensitivity == ImageFontCaseSensitivity.TO_LOWER) {
            content = content.toLowerCase();
        }
        return TextUtil.wrap(content, lineWidth, alignment);
    }

    public BufferedImage render(String content, int lineWidth, TextAlignment alignment, Color color, int pixelMultiplication) {
        lineWidth = this.getLineWidth(content, lineWidth);
        content = this.processContent(content, lineWidth, alignment);
        int lineCount = TextUtil.getLineCount(content);
        int imageHeight = this.glyphHeight * lineCount;
        int imageWidth = this.glyphWidth * lineWidth;
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics g = image.getGraphics();
        String[] lines = TextUtil.splitLines(content);
        for (int i = 0; i < lines.length; ++i) {
            int y = i * this.glyphHeight;
            String line = lines[i];
            for (int j = 0; j < line.length(); ++j) {
                int x = j * this.glyphWidth;
                BufferedImage glyph = this.loadBufferedImage(line.charAt(j), content);
                if (glyph == null) continue;
                g.drawImage(glyph, x, y, null);
            }
        }
        if (color != null) {
            image = ImageUtil.replaceColor(image, Color.BLACK, color);
        }
        if (pixelMultiplication > 1) {
            image = ImageUtil.multiplyPixel(image, pixelMultiplication);
        }
        return image;
    }

    public BufferedImage render(String content) {
        return this.render(content, this.getLineWidth(content), this.alignment, this.color, this.pixelMultiplication);
    }

    public String toString() {
        ToStringFormatter formatter = new ToStringFormatter("ImageFont");
        formatter.add("basePath", this.basePath);
        if (this.glyphWidth != 8 || this.glyphHeight != 8) {
            formatter.add("glyphDimension", String.format("%sx%s", this.glyphWidth, this.glyphHeight));
        }
        if (!this.extension.equals("png")) {
            formatter.add("extension", this.extension);
        }
        if (this.pixelMultiplication > 1) {
            formatter.add("pixelMultiplication", this.pixelMultiplication);
        }
        if (this.color != null) {
            formatter.add("color", this.color);
        }
        if (this.caseSensitivity != null) {
            formatter.add("caseSensitivity", (Object)this.caseSensitivity);
        }
        if (this.lineWidth > 0) {
            formatter.add("lineWidth", this.lineWidth);
        }
        formatter.add("alignment", (Object)this.alignment);
        return formatter.format();
    }
}

