/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.event.EventListeners;
import de.pirckheimer_gymnasium.engine_pi.physics.WorldHandler;

@API
public abstract class Joint<JointType extends org.jbox2d.dynamics.joints.Joint> {
    private JointRegistration<JointType> joint;
    private final EventListeners<Runnable> releaseListeners = new EventListeners();

    @Internal
    public final void setJoint(JointType joint, WorldHandler worldHandler) {
        this.joint = new JointRegistration<JointType>(joint, worldHandler);
        this.updateCustomProperties(joint);
    }

    protected abstract void updateCustomProperties(JointType var1);

    @Internal
    protected final JointType getJoint() {
        JointRegistration<JointType> joint = this.joint;
        if (joint == null) {
            return null;
        }
        return (JointType)((org.jbox2d.dynamics.joints.Joint)joint.joint());
    }

    @API
    public void release() {
        if (this.joint != null) {
            this.joint.worldHandler().getWorld().destroyJoint((org.jbox2d.dynamics.joints.Joint)this.joint.joint());
            this.joint = null;
        }
        this.releaseListeners.invoke(Runnable::run);
        this.releaseListeners.clear();
    }

    @API
    public void addReleaseListener(Runnable runnable) {
        this.releaseListeners.add(runnable);
    }

    public record JointRegistration<T>(T joint, WorldHandler worldHandler) {
    }
}

