/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.actor.Tile;
import de.pirckheimer_gymnasium.engine_pi.actor.TileMap;
import de.pirckheimer_gymnasium.engine_pi.actor.TileRegistration;
import java.util.HashMap;
import java.util.HashSet;

abstract class LetterTileMap {
    HashMap<Character, Tile> tiles;
    public TileRegistration container;
    int x;
    int y;
    public int width;
    public int height;
    protected char[][] letterMap;
    protected HashSet<Character> letters;
    protected HashMap<Character, String> names;
    protected HashMap<String, Character> namesToLetter;
    protected HashSet<Character> obstacles;
    protected String pathPrefix;
    protected String extension;

    public LetterTileMap(int width, int height) {
        this(width, height, "", null);
    }

    public LetterTileMap(int width, int height, String pathPrefix) {
        this(width, height, pathPrefix, null);
    }

    public LetterTileMap(int width, int height, String pathPrefix, String extension) {
        this.width = width;
        this.height = height;
        this.letters = new HashSet();
        this.names = new HashMap();
        this.namesToLetter = new HashMap();
        this.letterMap = new char[width][height];
        this.pathPrefix = pathPrefix;
        this.extension = extension;
    }

    protected String assembleFilePath(String filePath) {
        char last;
        Object extension = this.extension != null ? "." + this.extension : "";
        if (this.pathPrefix.length() > 0 && (last = this.pathPrefix.charAt(this.pathPrefix.length() - 1)) != '/') {
            this.pathPrefix = this.pathPrefix + "/";
        }
        return this.pathPrefix + filePath + (String)extension;
    }

    protected void createTile(char letter, String filePath) {
        this.tiles.put(Character.valueOf(letter), TileMap.createFromImage(this.assembleFilePath(filePath)));
    }

    protected Tile getTileFromCache(int x, int y) {
        return this.tiles.get(Character.valueOf(this.getLetter(x, y)));
    }

    protected final void setName(char letter, String name) {
        if (this.namesToLetter.get(name) != null) {
            throw new IllegalArgumentException(String.format("Eine Kachel mit dem Namen \u201e%s\u201c existiert bereits!", name));
        }
        this.namesToLetter.put(name, Character.valueOf(letter));
        this.names.put(Character.valueOf(letter), name);
    }

    protected final void checkLetterUnset(char letter) {
        if (this.letters.contains(Character.valueOf(letter))) {
            throw new IllegalArgumentException(String.format("Eine Kachel mit dem Buchstaben \u201e%s\u201c existiert bereits!", Character.valueOf(letter)));
        }
    }

    public final void registerImage(char letter, String filePath, String name) {
        if (name == null) {
            name = filePath;
        }
        this.setName(letter, name);
        this.checkLetterUnset(letter);
        this.letters.add(Character.valueOf(letter));
        this.createTile(letter, filePath);
    }

    public final void registerImage(char letter, String filePath) {
        this.registerImage(letter, filePath, null);
    }

    public final char getLetter(int x, int y) {
        return this.letterMap[x][y];
    }

    protected final boolean existsTile(char tile) {
        if (tile == ' ') {
            return true;
        }
        return this.names.get(Character.valueOf(tile)) != null;
    }

    protected final void checkWidth(String row) {
        if (row.length() > this.width) {
            throw new IllegalArgumentException(String.format("Anzahl der Zeichen in einer Reihe (%s) muss kleiner gleich numX (%s) sein!", row, this.width));
        }
    }

    protected final void checkHeight(String[] rows) {
        if (rows.length > this.height) {
            throw new IllegalArgumentException(String.format("Anzahl der Reihen (%s) muss kleiner gleich numY (%s) sein!", rows.length, this.height));
        }
    }

    protected final void checkLetter(char letter) {
        if (!this.existsTile(letter)) {
            throw new IllegalArgumentException(String.format("Unbekannte Kachel mit dem Buchstaben \u201c%s\u201d!", Character.valueOf(letter)));
        }
    }

    public final void parseMap(String[] rows) {
        this.checkHeight(rows);
        int currentRow = 0;
        for (String row : rows) {
            this.setRow(currentRow, row);
            ++currentRow;
        }
    }

    public final void fill(char tile) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.setTile(x, y, tile);
            }
        }
    }

    public void setTile(int x, int y, char tile) {
        this.checkLetter(tile);
        this.letterMap[x][y] = tile;
        this.container.setTile(x, y, this.getTileFromCache(x, y));
    }

    public final void setRow(int y, String row) {
        this.checkWidth(row);
        for (int x = 0; x < row.length(); ++x) {
            this.setTile(x, y, row.charAt(x));
        }
    }

    public final void setColumn(int x, String column) {
        for (int y = 0; y < column.length(); ++y) {
            this.setTile(x, y, column.charAt(y));
        }
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }
}

