/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.debug;

import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.resources.ColorContainer;
import de.pirckheimer_gymnasium.engine_pi.resources.NamedColor;
import java.awt.Color;
import java.util.Map;

public class ColorContainerVisualizer {
    private static final Color WHITE = new Color(255, 255, 255);

    public ColorContainerVisualizer(ColorContainer container, Scene scene) {
        double y = 8.0;
        for (Map.Entry<String, Color> entry : container.getAll().entrySet()) {
            NamedColor color = container.getNamedColor(entry.getKey());
            scene.addRectangle(1, 1).setPosition(-12.0, y).setColor(color.getColor());
            scene.addText(color.getColorDecFormatted()).setHeight(0.5).setFont("Monospaced").setPosition(-10.0, y + 0.25).setColor(color.getColor());
            scene.addText(color.getColorHexFormatted()).setHeight(0.5).setFont("Monospaced").setPosition(-6.0, y + 0.25).setColor(color.getColor());
            scene.addText(color.getName()).setHeight(0.5).setPosition(-3.0, y + 0.25).setColor(WHITE);
            scene.addText(color.getAliasesFormatted()).setHeight(0.3).setColor(WHITE).setPosition(1.0, y + 0.3);
            y -= 1.0;
        }
    }

    public ColorContainerVisualizer(Scene scene) {
        this(Resources.COLORS, scene);
    }
}

