/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.physics;

import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.BodyType;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureData;
import de.pirckheimer_gymnasium.engine_pi.physics.WorldHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureDef;

@Internal
public class PhysicsData {
    static final double DEFAULT_DENSITY = 10.0;
    static final double DEFAULT_FRICTION = 0.0;
    static final double DEFAULT_RESTITUTION = 0.5;
    static final BodyType DEFAULT_BODY_TYPE = BodyType.SENSOR;
    private boolean rotationLocked = false;
    private double x = 0.0;
    private double y = 0.0;
    private double rotation = 0.0;
    private double globalDensity = 10.0;
    private double globalFriction = 0.0;
    private double globalRestitution = 0.5;
    private double torque = 0.0;
    private double angularVelocity = 0.0;
    private double gravityScale = 1.0;
    private double linearDamping = 0.0;
    private double angularDamping = 0.0;
    private Double mass;
    private Vector velocity = Vector.NULL;
    private BodyType type = DEFAULT_BODY_TYPE;
    private Supplier<List<FixtureData>> fixtures;

    public static PhysicsData fromBody(Body body, BodyType type) {
        PhysicsData data = new PhysicsData(PhysicsData.extractFixturesFromBody(body));
        data.setGlobalDensity(body.m_fixtureList.m_density);
        data.setGlobalFriction(body.m_fixtureList.m_friction);
        data.setGlobalRestitution(body.m_fixtureList.m_restitution);
        data.setRotationLocked(body.isFixedRotation());
        data.setGravityScale(body.m_gravityScale);
        data.setX(body.getPosition().x);
        data.setY(body.getPosition().y);
        data.setRotation(Math.toDegrees(body.getAngle()));
        data.setTorque(body.m_torque);
        data.setVelocity(Vector.of(body.m_linearVelocity));
        data.setAngularVelocity(Math.toDegrees(body.m_angularVelocity) / 360.0);
        data.setType(type);
        data.setAngularDamping(body.getAngularDamping());
        data.setLinearDamping(body.getLinearDamping());
        return data;
    }

    public static Supplier<List<FixtureData>> extractFixturesFromBody(Body body) {
        ArrayList<FixtureData> fixtureData = new ArrayList<FixtureData>();
        Fixture fixture = body.m_fixtureList;
        while (fixture != null) {
            fixtureData.add(FixtureData.fromFixture(fixture));
            fixture = fixture.m_next;
        }
        return () -> fixtureData;
    }

    public PhysicsData(Supplier<List<FixtureData>> fixtures) {
        this.setFixtures(fixtures);
    }

    public FixtureDef[] createFixtureDefs() {
        ArrayList<FixtureDef> fixtureDefs = new ArrayList<FixtureDef>();
        List<FixtureData> fixtureList = this.getFixtures().get();
        for (FixtureData fixtureData : fixtureList) {
            fixtureDefs.add(fixtureData.createFixtureDef(this));
        }
        return fixtureDefs.toArray(new FixtureDef[0]);
    }

    public BodyDef createBodyDef() {
        BodyDef bodyDef = new BodyDef();
        bodyDef.angle = (float)Math.toRadians(this.getRotation());
        bodyDef.position.set(new Vec2((float)this.getX(), (float)this.getY()));
        bodyDef.fixedRotation = this.isRotationLocked();
        bodyDef.linearVelocity = this.getVelocity().toVec2();
        bodyDef.angularVelocity = (float)Math.toRadians(this.getAngularVelocity() * 360.0);
        bodyDef.type = this.getType().toBox2D();
        bodyDef.active = true;
        bodyDef.gravityScale = (float)this.gravityScale;
        bodyDef.angularDamping = (float)this.angularDamping;
        bodyDef.linearDamping = (float)this.linearDamping;
        return bodyDef;
    }

    Body createBody(WorldHandler world, Actor actor) {
        Body body = world.createBody(this.createBodyDef(), actor);
        for (FixtureDef fixtureDef : this.createFixtureDefs()) {
            body.createFixture(fixtureDef);
        }
        return body;
    }

    @Internal
    public FixtureData[] generateFixtureData() {
        List<FixtureData> data = this.fixtures.get();
        return data.toArray(new FixtureData[data.size()]);
    }

    public void setMass(Double mass) {
        this.mass = mass;
    }

    public Double getMass() {
        return this.mass;
    }

    public boolean isRotationLocked() {
        return this.rotationLocked;
    }

    public void setRotationLocked(boolean rotationLocked) {
        this.rotationLocked = rotationLocked;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public double getLinearDamping() {
        return this.linearDamping;
    }

    public void setLinearDamping(double linearDamping) {
        this.linearDamping = linearDamping;
    }

    public double getAngularDamping() {
        return this.angularDamping;
    }

    public void setAngularDamping(double angularDamping) {
        this.angularDamping = angularDamping;
    }

    public double getGlobalDensity() {
        return this.globalDensity;
    }

    public void setGlobalDensity(double globalDensity) {
        this.globalDensity = globalDensity;
    }

    public double getGravityScale() {
        return this.gravityScale;
    }

    public void setGravityScale(double factor) {
        this.gravityScale = factor;
    }

    public double getGlobalFriction() {
        return this.globalFriction;
    }

    public void setGlobalFriction(double globalFriction) {
        this.globalFriction = globalFriction;
    }

    public double getGlobalRestitution() {
        return this.globalRestitution;
    }

    public void setGlobalRestitution(double globalRestitution) {
        this.globalRestitution = globalRestitution;
    }

    public double getTorque() {
        return this.torque;
    }

    public void setTorque(double torque) {
        this.torque = torque;
    }

    public Vector getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector velocity) {
        this.velocity = velocity;
    }

    public BodyType getType() {
        return this.type;
    }

    public void setType(BodyType type) {
        this.type = type;
    }

    public Supplier<List<FixtureData>> getFixtures() {
        return this.fixtures;
    }

    public void setFixtures(Supplier<List<FixtureData>> fixtures) {
        this.fixtures = fixtures;
    }

    public double getAngularVelocity() {
        return this.angularVelocity;
    }

    public void setAngularVelocity(double angularVelocity) {
        this.angularVelocity = angularVelocity;
    }
}

