/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.resources;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.util.ColorUtil;
import java.awt.Color;
import java.util.Map;

public class ColorScheme {
    private Color yellow;
    private Color yellowOrange;
    private Color orange;
    private Color redOrange;
    private Color red;
    private Color redPurple;
    private Color purple;
    private Color bluePurple;
    private Color blue;
    private Color blueGreen;
    private Color green;
    private Color yellowGreen;
    private Color brown;
    Color white = Color.WHITE;
    Color gray = Color.GRAY;
    Color black = Color.BLACK;

    public ColorScheme() {
        this.yellow = new Color(255, 255, 0);
        this.red = new Color(255, 0, 0);
        this.blue = new Color(0, 0, 255);
    }

    public ColorScheme(Color yellow, Color red, Color blue) {
        this.yellow = yellow;
        this.red = red;
        this.blue = blue;
    }

    public ColorScheme(Color yellow, Color orange, Color red, Color purple, Color blue, Color green) {
        this(yellow, red, blue);
        this.orange = orange;
        this.purple = purple;
        this.green = green;
    }

    public ColorScheme(Color yellow, Color orange, Color red, Color purple, Color blue, Color green, Color brown) {
        this(yellow, orange, red, purple, blue, green);
        this.brown = brown;
    }

    private Color mix(Color color1, Color color2, double factor) {
        return ColorUtil.interpolate(color1, color2, factor);
    }

    private Color mix(Color color1, Color color2) {
        return this.mix(color1, color2, 0.5);
    }

    private Color decode(String color) {
        return ColorUtil.decode(color);
    }

    public Color getYellow() {
        return this.yellow;
    }

    public ColorScheme setYellow(Color yellow) {
        this.yellow = yellow;
        return this;
    }

    public ColorScheme setYellow(int r, int g, int b) {
        this.yellow = new Color(r, g, b);
        return this;
    }

    public ColorScheme setYellow(String yellow) {
        this.yellow = this.decode(yellow);
        return this;
    }

    public Color getYellowOrange() {
        if (this.yellowOrange == null) {
            this.yellowOrange = this.mix(this.getYellow(), this.getOrange());
        }
        return this.yellowOrange;
    }

    public ColorScheme setYellowOrange(Color yellowOrange) {
        this.yellowOrange = yellowOrange;
        return this;
    }

    public ColorScheme setYellowOrange(int r, int g, int b) {
        this.yellowOrange = new Color(r, g, b);
        return this;
    }

    public ColorScheme setYellowOrange(String yellowOrange) {
        this.yellowOrange = this.decode(yellowOrange);
        return this;
    }

    public Color getOrange() {
        if (this.orange == null) {
            this.orange = this.mix(this.getYellow(), this.getRed());
        }
        return this.orange;
    }

    public ColorScheme setOrange(Color orange) {
        this.orange = orange;
        return this;
    }

    public ColorScheme setOrange(int r, int g, int b) {
        this.orange = new Color(r, g, b);
        return this;
    }

    public ColorScheme setOrange(String orange) {
        this.orange = this.decode(orange);
        return this;
    }

    public Color getRedOrange() {
        if (this.redOrange == null) {
            this.redOrange = this.mix(this.getOrange(), this.getRed());
        }
        return this.redOrange;
    }

    public ColorScheme setRedOrange(Color redOrange) {
        this.redOrange = redOrange;
        return this;
    }

    public ColorScheme setRedOrange(int r, int g, int b) {
        this.redOrange = new Color(r, g, b);
        return this;
    }

    public ColorScheme setRedOrange(String redOrange) {
        this.redOrange = this.decode(redOrange);
        return this;
    }

    public Color getRed() {
        return this.red;
    }

    public ColorScheme setRed(Color red) {
        this.red = red;
        return this;
    }

    public ColorScheme setRed(int r, int g, int b) {
        this.red = new Color(r, g, b);
        return this;
    }

    public ColorScheme setRed(String red) {
        this.red = this.decode(red);
        return this;
    }

    public Color getRedPurple() {
        if (this.redPurple == null) {
            this.redPurple = this.mix(this.getRed(), this.getPurple());
        }
        return this.redPurple;
    }

    public ColorScheme setRedPurple(Color redPurple) {
        this.redPurple = redPurple;
        return this;
    }

    public ColorScheme setRedPurple(int r, int g, int b) {
        this.redPurple = new Color(r, g, b);
        return this;
    }

    public ColorScheme setRedPurple(String redPurple) {
        this.redPurple = this.decode(redPurple);
        return this;
    }

    public Color getPurple() {
        if (this.purple == null) {
            this.purple = this.mix(this.getRed(), this.getBlue());
            return this.purple;
        }
        return this.purple;
    }

    public ColorScheme setPurple(Color purple) {
        this.purple = purple;
        return this;
    }

    public ColorScheme setPurple(int r, int g, int b) {
        this.purple = new Color(r, g, b);
        return this;
    }

    public ColorScheme setPurple(String purple) {
        this.purple = this.decode(purple);
        return this;
    }

    public Color getBluePurple() {
        if (this.bluePurple == null) {
            this.bluePurple = this.mix(this.getPurple(), this.getBlue());
        }
        return this.bluePurple;
    }

    public ColorScheme setBluePurple(Color bluePurple) {
        this.bluePurple = bluePurple;
        return this;
    }

    public ColorScheme setBluePurple(int r, int g, int b) {
        this.bluePurple = new Color(r, g, b);
        return this;
    }

    public ColorScheme setBluePurple(String bluePurple) {
        this.bluePurple = this.decode(bluePurple);
        return this;
    }

    public Color getBlue() {
        return this.blue;
    }

    public ColorScheme setBlue(Color blue) {
        this.blue = blue;
        return this;
    }

    public ColorScheme setBlue(int r, int g, int b) {
        this.blue = new Color(r, g, b);
        return this;
    }

    public ColorScheme setBlue(String blue) {
        this.blue = this.decode(blue);
        return this;
    }

    public Color getBlueGreen() {
        if (this.blueGreen == null) {
            this.blueGreen = this.mix(this.getBlue(), this.getGreen());
        }
        return this.blueGreen;
    }

    public ColorScheme setBlueGreen(Color blueGreen) {
        this.blueGreen = blueGreen;
        return this;
    }

    public ColorScheme setBlueGreen(int r, int g, int b) {
        this.blueGreen = new Color(r, g, b);
        return this;
    }

    public ColorScheme setBlueGreen(String blueGreen) {
        this.blueGreen = this.decode(blueGreen);
        return this;
    }

    public Color getGreen() {
        if (this.green == null) {
            this.green = this.mix(this.getYellow(), this.getBlue());
        }
        return this.green;
    }

    public ColorScheme setGreen(Color green) {
        this.green = green;
        return this;
    }

    public ColorScheme setGreen(int r, int g, int b) {
        this.green = new Color(r, g, b);
        return this;
    }

    public ColorScheme setGreen(String green) {
        this.green = this.decode(green);
        return this;
    }

    public Color getYellowGreen() {
        if (this.yellowGreen == null) {
            this.yellowGreen = this.mix(this.getYellow(), this.getGreen());
        }
        return this.yellowGreen;
    }

    public ColorScheme setYellowGreen(Color yellowGreen) {
        this.yellowGreen = yellowGreen;
        return this;
    }

    public ColorScheme setYellowGreen(int r, int g, int b) {
        this.yellowGreen = new Color(r, g, b);
        return this;
    }

    public ColorScheme setYellowGreen(String yellowGreen) {
        this.yellowGreen = this.decode(yellowGreen);
        return this;
    }

    public Color getBrown() {
        if (this.brown == null) {
            this.brown = this.mix(this.getRed(), this.getGreen(), 0.35);
        }
        return this.brown;
    }

    public ColorScheme setBrown(Color brown) {
        this.brown = brown;
        return this;
    }

    public ColorScheme setBrown(int r, int g, int b) {
        this.brown = new Color(r, g, b);
        return this;
    }

    public ColorScheme setBrown(String brown) {
        this.brown = this.decode(brown);
        return this;
    }

    public Color getWhite() {
        return this.white;
    }

    public ColorScheme setWhite(Color white) {
        this.white = white;
        return this;
    }

    public ColorScheme setWhite(int r, int g, int b) {
        this.white = new Color(r, g, b);
        return this;
    }

    public ColorScheme setWhite(String white) {
        this.white = this.decode(white);
        return this;
    }

    public Color getGray() {
        return this.gray;
    }

    public ColorScheme setGray(Color gray) {
        this.gray = gray;
        return this;
    }

    public ColorScheme setGray(int r, int g, int b) {
        this.gray = new Color(r, g, b);
        return this;
    }

    public ColorScheme setGray(String gray) {
        this.gray = this.decode(gray);
        return this;
    }

    public Color getBlack() {
        return this.black;
    }

    public ColorScheme setBlack(Color black) {
        this.black = black;
        return this;
    }

    public ColorScheme setBlack(int r, int g, int b) {
        this.black = new Color(r, g, b);
        return this;
    }

    public ColorScheme setBlack(String black) {
        this.black = this.decode(black);
        return this;
    }

    public Color[] getWheelColors() {
        return new Color[]{this.getYellow(), this.getYellowOrange(), this.getOrange(), this.getRedOrange(), this.getRed(), this.getRedPurple(), this.getPurple(), this.getBluePurple(), this.getBlue(), this.getBlueGreen(), this.getGreen(), this.getYellowGreen()};
    }

    public Color[] getPrimaryColors() {
        return new Color[]{this.getYellow(), this.getRed(), this.getBlue()};
    }

    public Color[] getSecondaryColors() {
        return new Color[]{this.getOrange(), this.getPurple(), this.getGreen()};
    }

    public Color[] getExtraColors() {
        return new Color[]{this.getBrown(), this.getWhite(), this.getGray(), this.getBlack()};
    }

    public static void main(String[] args) {
        Game.start(new Scene(){
            {
                this.setBackgroundColor(Resources.COLORS.get("#444444"));
                int x = -16;
                int labelY = -2;
                for (Map.Entry<String, Color> entry : Resources.COLORS.getAll().entrySet()) {
                    this.addCircle((double)x, 0.0, entry.getValue());
                    this.addText(entry.getKey(), 0.5, x, labelY).setColor("white");
                    x += 2;
                    if ((labelY -= 2) >= -4) continue;
                    labelY = -2;
                }
            }
        }, 1200, 400);
    }
}

