/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.util;

import de.pirckheimer_gymnasium.engine_pi.util.HexColorString;
import de.pirckheimer_gymnasium.engine_pi.util.MathUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ColorUtil {
    private static final Logger log = Logger.getLogger(ColorUtil.class.getName());
    private static final int HEX_STRING_LENGTH = 7;
    private static final int HEX_STRING_LENGTH_ALPHA = 9;
    private static final int MAX_RGB_VALUE = 255;

    private ColorUtil() {
        throw new UnsupportedOperationException();
    }

    public static String encode(Color color) {
        if (color == null) {
            return null;
        }
        String colorString = "#" + String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        if (color.getAlpha() < 255) {
            colorString = colorString + String.format("%02x", color.getAlpha());
        }
        return colorString;
    }

    public static Color decode(String hex) {
        return ColorUtil.decode(hex, false);
    }

    public static Color decode(String hex, boolean solid) {
        if (hex == null || ((String)hex).isEmpty()) {
            return null;
        }
        if (!((String)hex).startsWith("#")) {
            if (((String)hex).length() == 6 || ((String)hex).length() == 8) {
                hex = "#" + (String)hex;
            } else {
                log.log(Level.SEVERE, "Could not parse color string \"{0}\". A color string needs to start with a \"#\" character.", hex);
                return null;
            }
        }
        switch (((String)hex).length()) {
            case 7: {
                return ColorUtil.decodeWellformedHexString((String)hex);
            }
            case 9: {
                return ColorUtil.decodeHexStringWithAlpha((String)hex, solid);
            }
        }
        log.log(Level.SEVERE, "Could not parse color string \"{0}\". Invalid string length \"{1}\"!\nAccepted lengths:\n\t{2} for Colors without Alpha (#ff0000)\n\t{3} for Colors with Alpha (#ff0000c8)", new Object[]{hex, ((String)hex).length(), 7, 9});
        return null;
    }

    public static Color[] decode(String[] hex) {
        return (Color[])Arrays.stream(hex).map(ColorUtil::decode).toArray(Color[]::new);
    }

    public static boolean isHexColorString(String color) {
        return HexColorString.isValid(color);
    }

    public static int ensureColorValueRange(float value) {
        return ColorUtil.ensureColorValueRange(Math.round(value));
    }

    public static int ensureColorValueRange(int value) {
        return MathUtil.clamp(value, 0, 255);
    }

    public static Color premultiply(Color color) {
        if (color.getAlpha() == 255) {
            return color;
        }
        return new Color(ColorUtil.premultiply(color.getRed(), color.getAlpha()), ColorUtil.premultiply(color.getGreen(), color.getAlpha()), ColorUtil.premultiply(color.getBlue(), color.getAlpha()));
    }

    public static Color interpolate(Color color1, Color color2, double factor) {
        factor = MathUtil.clamp(factor, 0.0, 1.0);
        double reverse = 1.0 - factor;
        int r = (int)((double)color1.getRed() * reverse + (double)color2.getRed() * factor);
        int g = (int)((double)color1.getGreen() * reverse + (double)color2.getGreen() * factor);
        int b = (int)((double)color1.getBlue() * reverse + (double)color2.getBlue() * factor);
        int a = (int)((double)color1.getAlpha() * reverse + (double)color2.getAlpha() * factor);
        return new Color(r, g, b, a);
    }

    public static Color getTransparentVariant(Color color, int newAlpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), ColorUtil.ensureColorValueRange(newAlpha));
    }

    private static Color decodeWellformedHexString(String hex) {
        try {
            return Color.decode(hex);
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private static int premultiply(int value, int alpha) {
        return (int)Math.round((double)value * Math.pow((double)alpha / 255.0, 0.45454545454545453));
    }

    private static Color decodeHexStringWithAlpha(String hex, boolean solid) {
        int alphaValue;
        String alpha = hex.substring(7, 9);
        try {
            alphaValue = ColorUtil.ensureColorValueRange(Integer.parseInt(alpha, 16));
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        StringBuilder sb = new StringBuilder(hex);
        sb.replace(7, 9, "");
        String baseColorString = sb.toString();
        Color baseColor = ColorUtil.decodeWellformedHexString(baseColorString);
        if (baseColor == null) {
            return null;
        }
        baseColor = new Color(baseColor.getRGB() & 0xFFFFFF | alphaValue << 24, true);
        if (solid) {
            return ColorUtil.premultiply(baseColor);
        }
        return baseColor;
    }

    public static Color changeAlpha(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static Color getComplementary(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public static Color calculateAverage(BufferedImage image) {
        int STEP = 2;
        int sampled = 0;
        long sumR = 0L;
        long sumG = 0L;
        long sumB = 0L;
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                if (x % STEP != 0 || y % STEP != 0) continue;
                Color pixel = new Color(image.getRGB(x, y));
                sumR += (long)pixel.getRed();
                sumG += (long)pixel.getGreen();
                sumB += (long)pixel.getBlue();
                ++sampled;
            }
        }
        return new Color(Math.round(sumR / (long)sampled), Math.round(sumG / (long)sampled), Math.round(sumB / (long)sampled));
    }
}

