/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.util;

import de.pirckheimer_gymnasium.engine_pi.resources.ResourceLoader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileUtil {
    private static final Logger log = Logger.getLogger(FileUtil.class.getName());
    private static final String[] DIR_BLACKLIST = new String[]{"\\bin", "\\screenshots"};
    private static final String FILE_SEPARATOR_WIN = "\\";
    private static final String FILE_SEPARATOR = "/";

    private FileUtil() {
        throw new UnsupportedOperationException();
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        try {
            Files.delete(dir.toPath().toAbsolutePath());
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
        return true;
    }

    public static List<String> findFilesByExtension(List<String> fileNames, Path dir, String extension) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                if (path.toFile().isDirectory()) {
                    if (FileUtil.isBlackListedDirectory(path)) continue;
                    FileUtil.findFilesByExtension(fileNames, path, extension);
                    continue;
                }
                if (!path.toAbsolutePath().toString().endsWith(extension)) continue;
                fileNames.add(path.toAbsolutePath().toString());
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return fileNames;
    }

    public static List<String> findFiles(List<String> fileNames, Path dir, String ... files) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                if (path.toFile().isDirectory()) {
                    if (FileUtil.isBlackListedDirectory(path)) continue;
                    FileUtil.findFiles(fileNames, path, files);
                    continue;
                }
                for (String file : files) {
                    if (!path.toAbsolutePath().toString().endsWith(file)) continue;
                    fileNames.add(path.toAbsolutePath().toString());
                }
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return fileNames;
    }

    public static String getExtension(File file) {
        return FileUtil.getExtension(file.getAbsolutePath());
    }

    public static String getExtension(String path) {
        String fileName = FileUtil.getFileName(path, true);
        if (!fileName.contains(".")) {
            return "";
        }
        try {
            return fileName.substring(fileName.lastIndexOf(46) + 1);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getFileName(URL path) {
        return FileUtil.getFileName(path.getPath());
    }

    public static String getFileName(String path) {
        return FileUtil.getFileName(path, false);
    }

    public static String getFileName(String path, boolean extension) {
        int lastBackslash;
        int pos;
        if (path == null || path.isEmpty() || path.endsWith(FILE_SEPARATOR_WIN) || path.endsWith(FILE_SEPARATOR)) {
            return "";
        }
        String name = path;
        if (!extension && (pos = name.lastIndexOf(46)) > 0) {
            name = name.substring(0, pos);
        }
        if ((lastBackslash = name.lastIndexOf(FILE_SEPARATOR)) != -1) {
            name = name.substring(lastBackslash + 1);
        } else {
            int lastForwardSlash = name.lastIndexOf(FILE_SEPARATOR_WIN);
            if (lastForwardSlash != -1) {
                name = name.substring(lastForwardSlash + 1);
            }
        }
        return name;
    }

    public static String getParentDirPath(String uri) {
        if (uri == null || uri.isEmpty()) {
            return uri;
        }
        try {
            return FileUtil.getParentDirPath(new URI(uri));
        }
        catch (URISyntaxException e) {
            Object parent = new File(uri).getParent();
            parent = (String)parent + File.separator;
            return parent;
        }
    }

    public static String getParentDirPath(URI uri) {
        URI parent = uri.getPath().endsWith(FILE_SEPARATOR) ? uri.resolve("..") : uri.resolve(".");
        return parent.toString();
    }

    public static String combine(String basePath, String ... paths) {
        basePath = basePath.replace(FILE_SEPARATOR_WIN, FILE_SEPARATOR);
        try {
            URI uri = new URI(basePath.replace(" ", "%20"));
            for (String path : paths) {
                if (path == null) continue;
                path = path.replace(FILE_SEPARATOR_WIN, FILE_SEPARATOR);
                uri = uri.resolve(path.replace(" ", "%20"));
            }
            return uri.toString().replace("%20", " ");
        }
        catch (URISyntaxException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return basePath;
        }
    }

    private static boolean isBlackListedDirectory(Path path) {
        for (String black : DIR_BLACKLIST) {
            if (!path.toAbsolutePath().toString().contains(black)) continue;
            return true;
        }
        return false;
    }

    public static String humanReadableByteCount(long bytes) {
        return FileUtil.humanReadableByteCount(bytes, false);
    }

    public static String humanReadableByteCount(long bytes, boolean decimal) {
        int unit;
        int n = unit = decimal ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " bytes";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        Object pre = (new String[]{"K", "M", "G", "T", "P", "E"})[exp - 1];
        pre = decimal ? pre : (String)pre + "i";
        return String.format(Locale.ROOT, "%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String normalizePath(String path) {
        return path.replace(FILE_SEPARATOR_WIN, File.separator).replace(FILE_SEPARATOR, File.separator);
    }

    public static boolean exists(String filePath) {
        try {
            return Files.exists(Paths.get(ResourceLoader.getLocation(filePath).toURI()), new LinkOption[0]);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static String getHome() {
        return System.getProperty("user.home");
    }

    public static void createDir(String dirpath) {
        Path path = Paths.get(dirpath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

