/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.util;

import de.pirckheimer_gymnasium.engine_pi.util.ColorUtil;
import de.pirckheimer_gymnasium.engine_pi.util.FileUtil;
import de.pirckheimer_gymnasium.engine_pi.util.Logger;
import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;

public class ImageUtil {
    private static GraphicsConfiguration graphicsConfig;

    private ImageUtil() {
        throw new UnsupportedOperationException();
    }

    public static BufferedImage copy(BufferedImage image) {
        ColorModel cm = image.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = image.copyData(image.getRaster().createCompatibleWritableRaster());
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    public static BufferedImage replaceColors(BufferedImage bufferedImage, Color[] from, Color[] to) {
        BufferedImage recoloredImage = ImageUtil.copy(bufferedImage);
        if (from.length != to.length) {
            throw new RuntimeException("Die beiden Felder aus Farben m\u00fcssen die gleiche L\u00e4nge haben");
        }
        for (int i = 0; i < from.length; ++i) {
            for (int y = 0; y < recoloredImage.getHeight(); ++y) {
                for (int x = 0; x < recoloredImage.getWidth(); ++x) {
                    if (recoloredImage.getRGB(x, y) != from[i].getRGB()) continue;
                    recoloredImage.setRGB(x, y, to[i].getRGB());
                }
            }
        }
        return recoloredImage;
    }

    public static BufferedImage replaceColors(BufferedImage bufferedImage, String[] from, String[] to) {
        return ImageUtil.replaceColors(bufferedImage, ColorUtil.decode(from), ColorUtil.decode(to));
    }

    public static BufferedImage replaceColors(BufferedImage bufferedImage, Map<Color, Color> colorMappings) {
        int colors = colorMappings.size();
        Color[] from = new Color[colors];
        Color[] to = new Color[colors];
        int index = 0;
        for (Map.Entry<Color, Color> c : colorMappings.entrySet()) {
            from[index] = c.getKey();
            to[index] = c.getValue();
            ++index;
        }
        return ImageUtil.replaceColors(bufferedImage, from, to);
    }

    public static BufferedImage replaceColor(BufferedImage bufferedImage, String from, String to) {
        return ImageUtil.replaceColors(bufferedImage, new String[]{from}, new String[]{to});
    }

    public static BufferedImage replaceColor(BufferedImage bufferedImage, Color from, Color to) {
        return ImageUtil.replaceColors(bufferedImage, new Color[]{from}, new Color[]{to});
    }

    public static BufferedImage multiplyPixel(BufferedImage image, int factor) {
        BufferedImage after = new BufferedImage(image.getWidth() * factor, image.getHeight() * factor, 2);
        AffineTransform at = new AffineTransform();
        at.scale(factor, factor);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 1);
        return scaleOp.filter(image, after);
    }

    public static void write(BufferedImage image, String filePath) {
        String formatName;
        String extension;
        switch (extension = FileUtil.getExtension(filePath)) {
            case "png": {
                formatName = "png";
                break;
            }
            case "gif": {
                formatName = "gif";
                break;
            }
            case "jpg": {
                formatName = "jpg";
                break;
            }
            default: {
                Logger.error("IO", "Nicht unterst\u00fctztes Format. Nur png, jpg, gif ist unterst\u00fctzt");
                return;
            }
        }
        try {
            ImageIO.write((RenderedImage)image, formatName, new File(FileUtil.normalizePath(filePath)));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Fehler beim Schreiben des Bildes");
        }
    }

    public static BufferedImage getCompatibleImage(int width, int height) {
        if (width == 0 || height == 0) {
            return null;
        }
        if (graphicsConfig == null) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice device = env.getDefaultScreenDevice();
            graphicsConfig = device.getDefaultConfiguration();
        }
        return graphicsConfig.createCompatibleImage(width, height, 3);
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        if (image == null || image.getWidth() == 0 || image.getHeight() == 0) {
            return image;
        }
        BufferedImage compatibleImg = ImageUtil.getCompatibleImage(image.getWidth(), image.getHeight());
        if (compatibleImg == null) {
            return null;
        }
        compatibleImg.createGraphics().drawImage((Image)image, 0, 0, null);
        return compatibleImg;
    }

    public static BufferedImage convertColorspace(BufferedImage image, int newType) {
        BufferedImage raw = image;
        image = new BufferedImage(raw.getWidth(), raw.getHeight(), newType);
        ColorConvertOp op = new ColorConvertOp(null);
        op.filter(raw, image);
        return image;
    }

    public static BufferedImage addAlphaChannel(BufferedImage image) {
        return ImageUtil.convertColorspace(image, 2);
    }
}

