/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi;

import de.pirckheimer_gymnasium.engine_pi.Bounds;
import de.pirckheimer_gymnasium.engine_pi.Camera;
import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.ActorAdder;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.event.EventListeners;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.event.MouseClickListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseClickListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.event.MouseScrollListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseScrollListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.physics.BodyHandler;
import de.pirckheimer_gymnasium.engine_pi.physics.NullHandler;
import de.pirckheimer_gymnasium.engine_pi.physics.PhysicsData;
import de.pirckheimer_gymnasium.engine_pi.physics.PhysicsHandler;
import de.pirckheimer_gymnasium.engine_pi.physics.WorldHandler;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.World;

public class Layer
implements KeyStrokeListenerRegistration,
MouseClickListenerRegistration,
MouseScrollListenerRegistration,
FrameUpdateListenerRegistration,
ActorAdder {
    private static final Comparator<? super Actor> ACTOR_COMPARATOR = Comparator.comparingInt(Actor::getLayerPosition);
    private final List<Actor> actors;
    private double parallaxX = 1.0;
    private double parallaxY = 1.0;
    private double parallaxRotation = 1.0;
    private double parallaxZoom = 1.0;
    private double timeDistort = 1.0;
    private int layerPosition = -2;
    private boolean visible = true;
    private Scene parent;
    private final WorldHandler worldHandler;
    private final EventListeners<KeyStrokeListener> keyStrokeListeners = new EventListeners(this.createParentSupplier(Scene::getKeyStrokeListeners));
    private final EventListeners<MouseClickListener> mouseClickListeners = new EventListeners(this.createParentSupplier(Scene::getMouseClickListeners));
    private final EventListeners<MouseScrollListener> mouseScrollListeners = new EventListeners(this.createParentSupplier(Scene::getMouseScrollListeners));
    private final EventListeners<FrameUpdateListener> frameUpdateListeners = new EventListeners();

    private <T> Supplier<T> createParentSupplier(Function<Scene, T> supplier) {
        return () -> {
            Scene scene = this.getParent();
            if (scene == null) {
                return null;
            }
            return supplier.apply(scene);
        };
    }

    @API
    public Layer() {
        this.worldHandler = new WorldHandler(this);
        this.actors = new ArrayList<Actor>();
        EventListeners.registerListeners(this);
    }

    public Scene getParent() {
        return this.parent;
    }

    @Override
    public Scene getScene() {
        return this.parent;
    }

    @Internal
    void setParent(Scene parent) {
        if (parent != null && this.parent != null) {
            throw new IllegalStateException("Das Layer wurde bereits an einer Scene angemeldet.");
        }
        if (parent != null) {
            this.keyStrokeListeners.invoke(parent::addKeyStrokeListener);
            this.mouseClickListeners.invoke(parent::addMouseClickListener);
            this.mouseScrollListeners.invoke(parent::addMouseScrollListener);
            this.frameUpdateListeners.invoke(parent::addFrameUpdateListener);
        } else {
            this.keyStrokeListeners.invoke(this.parent::removeKeyStrokeListener);
            this.mouseClickListeners.invoke(this.parent::removeMouseClickListener);
            this.mouseScrollListeners.invoke(this.parent::removeMouseScrollListener);
            this.frameUpdateListeners.invoke(this.parent::removeFrameUpdateListener);
        }
        this.parent = parent;
    }

    @API
    public void setLayerPosition(int position) {
        this.layerPosition = position;
        if (this.parent != null) {
            this.parent.sortLayers();
        }
    }

    @API
    public int getLayerPosition() {
        return this.layerPosition;
    }

    @API
    public void setParallaxPosition(double parallaxX, double parallaxY) {
        this.parallaxX = parallaxX;
        this.parallaxY = parallaxY;
    }

    @API
    public void setParallaxZoom(double parallaxZoom) {
        this.parallaxZoom = parallaxZoom;
    }

    @API
    public void setParallaxRotation(double parallaxRotation) {
        this.parallaxRotation = parallaxRotation;
    }

    @API
    public void setTimeDistort(double timeDistort) {
        if (timeDistort < 0.0) {
            throw new IllegalArgumentException("Zeitverzerrungsfaktor muss gr\u00f6\u00dfer oder gleich 0 sein, war " + timeDistort);
        }
        this.timeDistort = timeDistort;
    }

    @API
    public void setGravity(Vector gravity) {
        this.getWorld().setGravity(gravity.toVec2());
    }

    @API
    public void setGravity(double gravityX, double gravityY) {
        this.setGravity(new Vector(gravityX, gravityY));
    }

    @API
    public void setGravityOfEarth() {
        this.setGravity(0.0, -9.81);
    }

    public Vector getGravity() {
        return Vector.of(this.getWorld().getGravity());
    }

    @API
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @API
    public boolean isVisible() {
        return this.visible;
    }

    @API
    public void add(Actor ... actors) {
        this.defer(() -> {
            for (Actor actor : actors) {
                if (actor.isMounted()) {
                    if (actor.getLayer() != this) {
                        throw new IllegalArgumentException("Ein Actor kann nur an einem Layer gleichzeitig angemeldet sein");
                    }
                    return;
                }
                PhysicsHandler oldHandler = actor.getPhysicsHandler();
                BodyHandler newHandler = new BodyHandler(actor, oldHandler.getPhysicsData(), this.worldHandler);
                actor.setPhysicsHandler(newHandler);
                oldHandler.applyMountCallbacks(newHandler);
                this.actors.add(actor);
            }
            this.actors.sort(ACTOR_COMPARATOR);
        });
    }

    @API
    public final void remove(Actor ... actors) {
        this.defer(() -> {
            for (Actor actor : actors) {
                this.actors.remove(actor);
                PhysicsData physicsData = actor.getPhysicsHandler().getPhysicsData();
                PhysicsHandler physicsHandler = actor.getPhysicsHandler();
                if (physicsHandler.getWorldHandler() == null) {
                    return;
                }
                Body body = physicsHandler.getBody();
                this.worldHandler.removeAllInternalReferences(body);
                this.worldHandler.getWorld().destroyBody(body);
                actor.setPhysicsHandler(new NullHandler(physicsData));
            }
        });
    }

    @Internal
    public Vector translateWorldPointToFramePxCoordinates(Vector worldPoint) {
        double pixelPerMeter = this.calculatePixelPerMeter();
        Vector frameSize = Game.getWindowSize();
        Vector cameraPositionInPx = new Vector(frameSize.getX() / 2.0, frameSize.getY() / 2.0);
        Vector fromCamToPointInWorld = this.parent.getCamera().getCenter().multiplyX(this.parallaxX).multiplyY(this.parallaxY).getDistance(worldPoint);
        return cameraPositionInPx.add(fromCamToPointInWorld.multiplyY(-1.0).multiply(pixelPerMeter * this.parallaxZoom));
    }

    @API
    public Bounds getVisibleArea(Vector gameSizeInPixels) {
        Vector center = this.parent.getCamera().getCenter();
        double pixelPerMeter = this.calculatePixelPerMeter();
        return new Bounds(0.0, 0.0, gameSizeInPixels.getX() / pixelPerMeter, gameSizeInPixels.getY() / pixelPerMeter).withCenterPoint(center);
    }

    @API
    public void setVisibleWidth(double width, Vector gameSizeInPixels) {
        double desiredPixelPerMeter = gameSizeInPixels.getX() / width;
        double desiredZoom = 1.0 + (desiredPixelPerMeter - 1.0) / this.parallaxZoom;
        this.parent.getCamera().setMeter(desiredZoom);
    }

    @API
    public void setVisibleHeight(double height, Vector gameSizeInPixels) {
        double desiredPixelPerMeter = gameSizeInPixels.getY() / height;
        double desiredZoom = 1.0 + (desiredPixelPerMeter - 1.0) / this.parallaxZoom;
        this.parent.getCamera().setMeter(desiredZoom);
    }

    @API
    public double calculatePixelPerMeter() {
        return 1.0 + (this.parent.getCamera().getMeter() - 1.0) * this.parallaxZoom;
    }

    @Internal
    public void render(Graphics2D g, Camera camera, int width, int height) {
        if (!this.visible) {
            return;
        }
        Vector position = camera.getCenter();
        double rotation = -camera.getRotation();
        g.setClip(0, 0, width, height);
        g.translate(width / 2, height / 2);
        double pixelPerMeter = this.calculatePixelPerMeter();
        g.rotate(Math.toRadians(rotation) * this.parallaxRotation, 0.0, 0.0);
        g.translate(-position.getX() * this.parallaxX * pixelPerMeter, position.getY() * this.parallaxY * pixelPerMeter);
        int size = Math.max(width, height);
        boolean needsSort = false;
        int previousPosition = Integer.MIN_VALUE;
        for (Actor actor : this.actors) {
            actor.renderBasic(g, new Bounds(position.getX() - (double)size, position.getY() - (double)size, size * 2, size * 2), pixelPerMeter);
            if (needsSort) continue;
            int actorPosition = actor.getLayerPosition();
            if (actorPosition < previousPosition) {
                needsSort = true;
            }
            previousPosition = actorPosition;
        }
        if (needsSort) {
            this.actors.sort(ACTOR_COMPARATOR);
        }
    }

    @Internal
    public WorldHandler getWorldHandler() {
        return this.worldHandler;
    }

    private World getWorld() {
        return this.worldHandler.getWorld();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void step(double pastTime) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            this.worldHandler.step(pastTime * this.timeDistort);
        }
    }

    @Override
    @API
    public EventListeners<FrameUpdateListener> getFrameUpdateListeners() {
        return this.frameUpdateListeners;
    }

    @Override
    @API
    public EventListeners<KeyStrokeListener> getKeyStrokeListeners() {
        return this.keyStrokeListeners;
    }

    @Override
    @API
    public EventListeners<MouseClickListener> getMouseClickListeners() {
        return this.mouseClickListeners;
    }

    @Override
    @API
    public EventListeners<MouseScrollListener> getMouseScrollListeners() {
        return this.mouseScrollListeners;
    }

    @Internal
    void invokeFrameUpdateListeners(double pastTime) {
        double scaledSeconds = pastTime * this.timeDistort;
        this.frameUpdateListeners.invoke(frameUpdateListener -> frameUpdateListener.onFrameUpdate(scaledSeconds));
    }
}

