/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.actor.ImageFontCaseSensitivity;
import de.pirckheimer_gymnasium.engine_pi.actor.ImageFontGlyph;
import de.pirckheimer_gymnasium.engine_pi.debug.ToStringFormatter;
import de.pirckheimer_gymnasium.engine_pi.resources.ResourceLoader;
import de.pirckheimer_gymnasium.engine_pi.util.ImageUtil;
import de.pirckheimer_gymnasium.engine_pi.util.TextAlignment;
import de.pirckheimer_gymnasium.engine_pi.util.TextUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ImageFont {
    private String basePath;
    private int glyphWidth;
    private int glyphHeight;
    private String extension;
    private int pixelMultiplication = 1;
    private Color color;
    private ImageFontCaseSensitivity caseSensitivity;
    private int lineWidth = -1;
    private TextAlignment alignment;
    private final Map<Character, ImageFontGlyph> glyphs = new LinkedHashMap<Character, ImageFontGlyph>();
    private final Map<String, ImageFontGlyph> glyphsByFilename = new LinkedHashMap<String, ImageFontGlyph>();
    private boolean throwException = true;

    public ImageFont(String basePath, String extension, ImageFontCaseSensitivity caseSensitivity, TextAlignment alignment) {
        this.basePath = basePath;
        this.extension = extension;
        this.caseSensitivity = caseSensitivity;
        this.alignment = alignment;
        this.glyphWidth = 0;
        this.glyphHeight = 0;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(Objects.requireNonNull(ResourceLoader.getLocation(basePath)).toURI()));){
            for (Path path : stream) {
                if (Files.isDirectory(path, new LinkOption[0]) || !path.toString().toLowerCase().endsWith("." + this.extension.toLowerCase())) continue;
                ImageFontGlyph glyph = new ImageFontGlyph(path);
                if (this.glyphWidth > 0 && this.glyphWidth != glyph.getWidth() || this.glyphHeight > 0 && this.glyphHeight != glyph.getHeight()) {
                    throw new Exception("Alle Bilder einer Bilderschriftart m\u00fcssen die gleichen Abmessungen haben!");
                }
                this.glyphWidth = glyph.getWidth();
                this.glyphHeight = glyph.getHeight();
                this.glyphsByFilename.put(glyph.getFilename(), glyph);
                if (glyph.getGlyph() == '\u0000') continue;
                this.glyphs.put(Character.valueOf(glyph.getGlyph()), glyph);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.addDefaultMapping();
    }

    public ImageFont(String basePath, ImageFontCaseSensitivity caseSensitivity) {
        this(basePath, "png", caseSensitivity, TextAlignment.LEFT);
    }

    public ImageFont(String basePath) {
        this(basePath, null);
    }

    public ImageFont setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public int getGlyphWidth() {
        return this.glyphWidth;
    }

    public ImageFont setColor(Color color) {
        this.color = color;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public ImageFont setExtension(String extension) {
        this.extension = extension;
        return this;
    }

    public ImageFont setPixelMultiplication(int pixelMultiplication) {
        this.pixelMultiplication = pixelMultiplication;
        return this;
    }

    public int getPixelMultiplication() {
        return this.pixelMultiplication;
    }

    public ImageFont setCaseSensitivity(ImageFontCaseSensitivity caseSensitivity) {
        this.caseSensitivity = caseSensitivity;
        return this;
    }

    public ImageFont setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public int getLineWidth(String content) {
        if (this.lineWidth == -1) {
            return TextUtil.getLineWidth(content) + 1;
        }
        return this.lineWidth;
    }

    public int getLineWidth(String content, int lineWidth) {
        if (lineWidth == -1) {
            return TextUtil.getLineWidth(content) + 1;
        }
        return lineWidth;
    }

    public ImageFont setAlignment(TextAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public TextAlignment getAlignment() {
        return this.alignment;
    }

    public ImageFont setThrowException(boolean throwException) {
        this.throwException = throwException;
        return this;
    }

    private void addDefaultMapping() {
        this.addMapping(' ', "0020_space").addMapping('!', "0021_exclamation-mark").addMapping('\"', "0022_quotation-mark").addMapping('#', "0023_number-sign").addMapping('$', "0024_dollar-sign").addMapping('%', "0025_percent-sign").addMapping('&', "0026_ampersand").addMapping('\'', "0027_apostrophe").addMapping('(', "0028_left-parenthesis").addMapping(')', "0029_right-parenthesis").addMapping('*', "002a_asterisk").addMapping('+', "002b_plus-sign").addMapping(',', "002c_comma").addMapping('-', "002d_hyphen-minus").addMapping('.', "002e_full-stop").addMapping('/', "002f_solidus").addMapping('0', "0030_digit-zero").addMapping('1', "0031_digit-one").addMapping('2', "0032_digit-two").addMapping('3', "0033_digit-three").addMapping('4', "0034_digit-four").addMapping('5', "0035_digit-five").addMapping('6', "0036_digit-six").addMapping('7', "0037_digit-seven").addMapping('8', "0038_digit-eight").addMapping('9', "0039_digit-nine").addMapping(':', "003a_colon").addMapping(';', "003b_semicolon").addMapping('<', "003c_less-than-sign").addMapping('=', "003d_equals-sign").addMapping('>', "003e_greater-than-sign").addMapping('?', "003f_question-mark").addMapping('@', "0040_commercial-at").addMapping('A', "0041_latin-capital-letter-a").addMapping('B', "0042_latin-capital-letter-b").addMapping('C', "0043_latin-capital-letter-c").addMapping('D', "0044_latin-capital-letter-d").addMapping('E', "0045_latin-capital-letter-e").addMapping('F', "0046_latin-capital-letter-f").addMapping('G', "0047_latin-capital-letter-g").addMapping('H', "0048_latin-capital-letter-h").addMapping('I', "0049_latin-capital-letter-i").addMapping('J', "004a_latin-capital-letter-j").addMapping('K', "004b_latin-capital-letter-k").addMapping('L', "004c_latin-capital-letter-l").addMapping('M', "004d_latin-capital-letter-m").addMapping('N', "004e_latin-capital-letter-n").addMapping('O', "004f_latin-capital-letter-o").addMapping('P', "0050_latin-capital-letter-p").addMapping('Q', "0051_latin-capital-letter-q").addMapping('R', "0052_latin-capital-letter-r").addMapping('S', "0053_latin-capital-letter-s").addMapping('T', "0054_latin-capital-letter-t").addMapping('U', "0055_latin-capital-letter-u").addMapping('V', "0056_latin-capital-letter-v").addMapping('W', "0057_latin-capital-letter-w").addMapping('X', "0058_latin-capital-letter-x").addMapping('Y', "0059_latin-capital-letter-y").addMapping('Z', "005a_latin-capital-letter-z").addMapping('[', "005b_left-square-bracket").addMapping('\\', "005c_reverse-solidus").addMapping(']', "005d_right-square-bracket").addMapping('^', "005e_circumflex-accent").addMapping('_', "005f_low-line").addMapping('`', "0060_grave-accent").addMapping('a', "0061_latin-small-letter-a").addMapping('b', "0062_latin-small-letter-b").addMapping('c', "0063_latin-small-letter-c").addMapping('d', "0064_latin-small-letter-d").addMapping('e', "0065_latin-small-letter-e").addMapping('f', "0066_latin-small-letter-f").addMapping('g', "0067_latin-small-letter-g").addMapping('h', "0068_latin-small-letter-h").addMapping('i', "0069_latin-small-letter-i").addMapping('j', "006a_latin-small-letter-j").addMapping('k', "006b_latin-small-letter-k").addMapping('l', "006c_latin-small-letter-l").addMapping('m', "006d_latin-small-letter-m").addMapping('n', "006e_latin-small-letter-n").addMapping('o', "006f_latin-small-letter-o").addMapping('p', "0070_latin-small-letter-p").addMapping('q', "0071_latin-small-letter-q").addMapping('r', "0072_latin-small-letter-r").addMapping('s', "0073_latin-small-letter-s").addMapping('t', "0074_latin-small-letter-t").addMapping('u', "0075_latin-small-letter-u").addMapping('v', "0076_latin-small-letter-v").addMapping('w', "0077_latin-small-letter-w").addMapping('x', "0078_latin-small-letter-x").addMapping('y', "0079_latin-small-letter-y").addMapping('z', "007a_latin-small-letter-z").addMapping('{', "007b_left-curly-bracket").addMapping('|', "007c_vertical-line").addMapping('}', "007d_right-curly-bracket").addMapping('~', "007e_tilde").addMapping('\u00a9', "00a9_copyright-sign").addMapping('\u201c', "201c_left-double-quotation-mark").addMapping('\u201d', "201d_right-double-quotation-mark");
    }

    public ImageFontGlyph[] getGlyphs() {
        return this.glyphs.values().toArray(new ImageFontGlyph[0]);
    }

    public ImageFont addMapping(char glyph, String filename) {
        ImageFontGlyph imageGlyph = this.glyphsByFilename.get(filename);
        if (imageGlyph != null) {
            imageGlyph.setGlyph(glyph);
            this.glyphs.put(Character.valueOf(glyph), imageGlyph);
        }
        return this;
    }

    private ImageFontGlyph getGlyph(char glyph, String content) {
        if (glyph == ' ') {
            return null;
        }
        ImageFontGlyph image = this.glyphs.get(Character.valueOf(glyph));
        if (image == null && this.throwException) {
            throw new RuntimeException("Unbekannter Buchstabe \u201e" + glyph + "\u201c im Text \u201e" + content + "\u201c.");
        }
        return image;
    }

    private String processContent(String content, int lineWidth, TextAlignment alignment) {
        if (this.caseSensitivity == ImageFontCaseSensitivity.TO_UPPER) {
            content = content.toUpperCase();
        } else if (this.caseSensitivity == ImageFontCaseSensitivity.TO_LOWER) {
            content = content.toLowerCase();
        }
        return TextUtil.wrap(content, lineWidth, alignment);
    }

    public BufferedImage render(String content, int lineWidth, TextAlignment alignment, Color color, int pixelMultiplication) {
        lineWidth = this.getLineWidth(content, lineWidth);
        content = this.processContent(content, lineWidth, alignment);
        int lineCount = TextUtil.getLineCount(content);
        int imageHeight = this.glyphHeight * lineCount;
        int imageWidth = this.glyphWidth * lineWidth;
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics g = image.getGraphics();
        String[] lines = TextUtil.splitLines(content);
        for (int i = 0; i < lines.length; ++i) {
            int y = i * this.glyphHeight;
            String line = lines[i];
            for (int j = 0; j < line.length(); ++j) {
                int x = j * this.glyphWidth;
                ImageFontGlyph glyph = this.getGlyph(line.charAt(j), content);
                if (glyph == null) continue;
                g.drawImage(glyph.getImage(), x, y, null);
            }
        }
        if (color != null) {
            image = ImageUtil.replaceColor(image, Color.BLACK, color);
        }
        if (pixelMultiplication > 1) {
            image = ImageUtil.multiplyPixel(image, pixelMultiplication);
        }
        return image;
    }

    public BufferedImage render(String content) {
        return this.render(content, this.getLineWidth(content), this.alignment, this.color, this.pixelMultiplication);
    }

    public String toString() {
        ToStringFormatter formatter = new ToStringFormatter("ImageFont");
        formatter.add("basePath", this.basePath);
        if (this.glyphWidth != 8 || this.glyphHeight != 8) {
            formatter.add("glyphDimension", String.format("%sx%s", this.glyphWidth, this.glyphHeight));
        }
        if (!this.extension.equals("png")) {
            formatter.add("extension", this.extension);
        }
        if (this.pixelMultiplication > 1) {
            formatter.add("pixelMultiplication", this.pixelMultiplication);
        }
        if (this.color != null) {
            formatter.add("color", this.color);
        }
        if (this.caseSensitivity != null) {
            formatter.add("caseSensitivity", (Object)this.caseSensitivity);
        }
        if (this.lineWidth > 0) {
            formatter.add("lineWidth", this.lineWidth);
        }
        formatter.add("alignment", (Object)this.alignment);
        return formatter.format();
    }
}

