/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.event;

import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.debug.ToStringFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jbox2d.collision.WorldManifold;
import org.jbox2d.dynamics.contacts.Contact;

public class CollisionEvent<E extends Actor> {
    private static final ThreadLocal<WorldManifold> worldManifold = ThreadLocal.withInitial(WorldManifold::new);
    private final Contact contact;
    private final E colliding;

    @Internal
    public CollisionEvent(Contact contact, E colliding) {
        this.contact = contact;
        this.colliding = colliding;
    }

    @API
    public E getColliding() {
        return this.colliding;
    }

    @API
    public void ignoreCollision() {
        this.contact.setEnabled(false);
        ((Actor)this.colliding).getPhysicsHandler().getWorldHandler().addContactToBlacklist(this.contact);
    }

    @API
    public Vector getTangentNormal() {
        WorldManifold worldManifold = CollisionEvent.worldManifold.get();
        this.contact.getWorldManifold(worldManifold);
        Vector normal = Vector.of(worldManifold.normal);
        if (this.contact.m_fixtureA.getBody().getUserData() == this.colliding) {
            normal = normal.negate();
        }
        return normal;
    }

    @API
    public List<Vector> getPoints() {
        WorldManifold worldManifold = CollisionEvent.worldManifold.get();
        this.contact.getWorldManifold(worldManifold);
        int pointCount = this.contact.getManifold().pointCount;
        if (pointCount == 0) {
            return Collections.emptyList();
        }
        if (pointCount == 1) {
            return Collections.singletonList(Vector.of(worldManifold.points[0]));
        }
        if (pointCount == 2) {
            return Arrays.asList(Vector.of(worldManifold.points[0]), Vector.of(worldManifold.points[1]));
        }
        throw new IllegalStateException("Invalid contact point count: " + pointCount);
    }

    public boolean isIgnored() {
        return !this.contact.isEnabled();
    }

    public String toString() {
        ToStringFormatter formatter = new ToStringFormatter("CollisionEvent");
        formatter.add("colliding", this.colliding.toString());
        List<Vector> points = this.getPoints();
        formatter.add("points", points.toString());
        if (this.isIgnored()) {
            formatter.add("isIgnored");
        }
        return formatter.format();
    }
}

