/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Polygon;

public class RegularPolygon
extends Polygon {
    public RegularPolygon(int numSides, double radius) {
        super(RegularPolygon.getVectors(numSides, radius));
    }

    public RegularPolygon(int numSides) {
        this(numSides, 1.0);
    }

    public static Vector[] getVectors(int numSides, double radius) {
        Vector[] vectors = new Vector[numSides];
        double angleStep = 360 / numSides;
        for (int i = 0; i < numSides; ++i) {
            vectors[i] = Vector.ofAngle((double)i * angleStep - (180.0 - angleStep) / 2.0).multiply(radius).add(radius, radius);
        }
        return vectors;
    }

    public static void main(String[] args) {
        Game.debug();
        Game.start(new Scene(){
            {
                int x = -10;
                for (int i = 3; i < 8; ++i) {
                    this.addRegularPolygon(i, 2.0, x, 0.0);
                    this.addText("" + i).setPosition((double)x - 0.25, -4.0).setColor("white");
                    x += 5;
                }
            }
        });
    }
}

