/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.tweening;

import de.pirckheimer_gymnasium.engine_pi.tweening.TweenEquation;

public enum TweenFunction {
    LINEAR(time -> time),
    QUAD_IN(time -> (float)Math.pow(time, 2.0)),
    QUAD_OUT(time -> (float)(1.0 - Math.pow(time - 1.0f, 2.0))),
    QUAD_INOUT(time -> (float)(time * 2.0f < 1.0f ? Math.pow(time, 2.0) * 2.0 : 1.0 - Math.pow(time - 1.0f, 2.0) * 2.0)),
    CIRCLE_IN(time -> (float)(1.0 - Math.sqrt(1.0 - Math.pow(time, 2.0)))),
    CIRCLE_OUT(time -> (float)Math.sqrt(1.0 - Math.pow(time - 1.0f, 2.0))),
    CIRCLE_INOUT(time -> (float)(time * 2.0f < 1.0f ? (1.0 - Math.sqrt(1.0 - Math.pow(time * 2.0f, 2.0))) * 0.5 : (Math.sqrt(1.0 - 4.0 * Math.pow(time - 1.0f, 2.0)) + 1.0) * 0.5)),
    SINE_IN(time -> (float)(1.0 - Math.cos((double)time * Math.PI / 2.0))),
    SINE_OUT(time -> (float)(1.0 - Math.sin((double)time * Math.PI / 2.0))),
    SINE_INOUT(time -> (float)(0.5 * (1.0 - Math.cos((double)time * Math.PI / 2.0)))),
    EXPO_IN(time -> (float)Math.pow(2.0, 10.0f * (time - 1.0f))),
    EXPO_OUT(time -> (float)(1.0 - Math.pow(2.0, -10.0f * time))),
    EXPO_INOUT(time -> (float)(time < 0.5f ? Math.pow(2.0, 10.0f * (2.0f * time - 1.0f) - 1.0f) : 1.0 - Math.pow(2.0, -10.0f * (2.0f * time - 1.0f) - 1.0f))),
    BACK_IN(time -> (float)Math.pow(time, 2.0) * (time * 2.70158f - 1.70158f)),
    BACK_OUT(time -> {
        float k = 1.70158f;
        return (float)(1.0 + Math.pow(time - 1.0f, 2.0) * (double)((time - 1.0f) * 2.70158f + 1.70158f));
    }),
    BACK_INOUT(time -> {
        float k2 = 2.5949094f;
        return (float)(time < 0.5f ? Math.pow(time, 2.0) * 2.0 * (double)(time * 2.0f * 3.5949094f - 2.5949094f) : 1.0 + 2.0 * Math.pow(time - 1.0f, 2.0) * (double)(2.0f * (time - 1.0f) * 3.5949094f + 2.5949094f));
    }),
    BOUNCE_OUT(time -> {
        float BOUNCE_R = 0.36363637f;
        float BOUNCE_K0 = 7.5625f;
        float BOUNCE_K1 = 0.36363637f;
        float BOUNCE_K2 = 0.72727275f;
        float BOUNCE_K3 = 0.54545456f;
        float BOUNCE_K4 = 0.90909094f;
        float BOUNCE_K5 = 0.8181819f;
        float BOUNCE_K6 = 0.9545455f;
        if (time < 0.36363637f) {
            return 7.5625f * time * time;
        }
        if (time < 0.72727275f) {
            float t = time - 0.54545456f;
            return 7.5625f * t * t + 0.75f;
        }
        if (time < 0.90909094f) {
            float t = time - 0.8181819f;
            return 7.5625f * t * t + 0.9375f;
        }
        float t = time - 0.9545455f;
        return 7.5625f * t * t + 0.984375f;
    }),
    BOUNCE_IN(time -> 1.0f - TweenFunction.BOUNCE_OUT.equation.compute(1.0f - time)),
    BOUNCE_INOUT(time -> time * 2.0f < 1.0f ? 0.5f - 0.5f * TweenFunction.BOUNCE_OUT.equation.compute(1.0f - time * 2.0f) : 0.5f + 0.5f * TweenFunction.BOUNCE_OUT.equation.compute(time * 2.0f - 1.0f)),
    ELASTIC_IN(time -> (float)(-Math.pow(2.0, 10.0f * (time - 1.0f)) * Math.sin((double)((time - 1.0f) * 40.0f - 3.0f) * Math.PI / 6.0))),
    ELASTIC_OUT(time -> (float)(1.0 + Math.pow(2.0, 10.0f * -time) * Math.sin((double)(-time * 40.0f - 3.0f) * Math.PI / 6.0))),
    ELASTIC_INOUT(time -> {
        time *= 2.0f;
        float k = (float)((double)(80.0f * (time -= 1.0f) - 9.0f) * Math.PI / 18.0);
        if (time < 0.0f) {
            return (float)(-0.5 * Math.pow(2.0, 10.0f * time) * Math.sin(k));
        }
        return (float)(1.0 + 0.5 * Math.pow(2.0, -10.0f * time) * Math.sin(k));
    });

    private final transient TweenEquation equation;

    private TweenFunction(TweenEquation equation) {
        this.equation = equation;
    }

    public TweenEquation getEquation() {
        return this.equation;
    }

    public float compute(float time) {
        return this.equation.compute(time);
    }
}

