/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics;

import de.pirckheimer_gymnasium.jbox2d.callbacks.ContactFilter;
import de.pirckheimer_gymnasium.jbox2d.callbacks.ContactListener;
import de.pirckheimer_gymnasium.jbox2d.callbacks.PairCallback;
import de.pirckheimer_gymnasium.jbox2d.collision.broadphase.BroadPhase;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Body;
import de.pirckheimer_gymnasium.jbox2d.dynamics.BodyType;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Fixture;
import de.pirckheimer_gymnasium.jbox2d.dynamics.FixtureProxy;
import de.pirckheimer_gymnasium.jbox2d.dynamics.World;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.Contact;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.ContactEdge;

public class ContactManager
implements PairCallback {
    public BroadPhase broadPhase;
    public Contact contactList = null;
    public int contactCount = 0;
    public ContactFilter contactFilter = new ContactFilter();
    public ContactListener contactListener = null;
    private final World pool;

    public ContactManager(World argPool, BroadPhase broadPhase) {
        this.broadPhase = broadPhase;
        this.pool = argPool;
    }

    @Override
    public void addPair(Object proxyUserDataA, Object proxyUserDataB) {
        Body bodyB;
        FixtureProxy proxyA = (FixtureProxy)proxyUserDataA;
        FixtureProxy proxyB = (FixtureProxy)proxyUserDataB;
        Fixture fixtureA = proxyA.fixture;
        Fixture fixtureB = proxyB.fixture;
        int indexA = proxyA.childIndex;
        int indexB = proxyB.childIndex;
        Body bodyA = fixtureA.getBody();
        if (bodyA == (bodyB = fixtureB.getBody())) {
            return;
        }
        ContactEdge edge = bodyB.getContactList();
        while (edge != null) {
            if (edge.other == bodyA) {
                Fixture fA = edge.contact.getFixtureA();
                Fixture fB = edge.contact.getFixtureB();
                int iA = edge.contact.getChildIndexA();
                int iB = edge.contact.getChildIndexB();
                if (fA == fixtureA && iA == indexA && fB == fixtureB && iB == indexB) {
                    return;
                }
                if (fA == fixtureB && iA == indexB && fB == fixtureA && iB == indexA) {
                    return;
                }
            }
            edge = edge.next;
        }
        if (!bodyB.shouldCollide(bodyA)) {
            return;
        }
        if (this.contactFilter != null && !this.contactFilter.shouldCollide(fixtureA, fixtureB)) {
            return;
        }
        Contact c = this.pool.popContact(fixtureA, indexA, fixtureB, indexB);
        if (c == null) {
            return;
        }
        fixtureA = c.getFixtureA();
        fixtureB = c.getFixtureB();
        indexA = c.getChildIndexA();
        indexB = c.getChildIndexB();
        bodyA = fixtureA.getBody();
        bodyB = fixtureB.getBody();
        c.prev = null;
        c.next = this.contactList;
        if (this.contactList != null) {
            this.contactList.prev = c;
        }
        this.contactList = c;
        c.nodeA.contact = c;
        c.nodeA.other = bodyB;
        c.nodeA.prev = null;
        c.nodeA.next = bodyA.contactList;
        if (bodyA.contactList != null) {
            bodyA.contactList.prev = c.nodeA;
        }
        bodyA.contactList = c.nodeA;
        c.nodeB.contact = c;
        c.nodeB.other = bodyA;
        c.nodeB.prev = null;
        c.nodeB.next = bodyB.contactList;
        if (bodyB.contactList != null) {
            bodyB.contactList.prev = c.nodeB;
        }
        bodyB.contactList = c.nodeB;
        if (!fixtureA.isSensor() && !fixtureB.isSensor()) {
            bodyA.setAwake(true);
            bodyB.setAwake(true);
        }
        ++this.contactCount;
    }

    public void findNewContacts() {
        this.broadPhase.updatePairs(this);
    }

    public void destroy(Contact c) {
        Fixture fixtureA = c.getFixtureA();
        Fixture fixtureB = c.getFixtureB();
        Body bodyA = fixtureA.getBody();
        Body bodyB = fixtureB.getBody();
        if (this.contactListener != null && c.isTouching()) {
            this.contactListener.endContact(c);
        }
        if (c.prev != null) {
            c.prev.next = c.next;
        }
        if (c.next != null) {
            c.next.prev = c.prev;
        }
        if (c == this.contactList) {
            this.contactList = c.next;
        }
        if (c.nodeA.prev != null) {
            c.nodeA.prev.next = c.nodeA.next;
        }
        if (c.nodeA.next != null) {
            c.nodeA.next.prev = c.nodeA.prev;
        }
        if (c.nodeA == bodyA.contactList) {
            bodyA.contactList = c.nodeA.next;
        }
        if (c.nodeB.prev != null) {
            c.nodeB.prev.next = c.nodeB.next;
        }
        if (c.nodeB.next != null) {
            c.nodeB.next.prev = c.nodeB.prev;
        }
        if (c.nodeB == bodyB.contactList) {
            bodyB.contactList = c.nodeB.next;
        }
        this.pool.pushContact(c);
        --this.contactCount;
    }

    public void collide() {
        Contact c = this.contactList;
        while (c != null) {
            boolean activeB;
            Fixture fixtureA = c.getFixtureA();
            Fixture fixtureB = c.getFixtureB();
            int indexA = c.getChildIndexA();
            int indexB = c.getChildIndexB();
            Body bodyA = fixtureA.getBody();
            Body bodyB = fixtureB.getBody();
            if ((c.flags & 8) == 8) {
                if (!bodyB.shouldCollide(bodyA)) {
                    Contact cNuke = c;
                    c = cNuke.getNext();
                    this.destroy(cNuke);
                    continue;
                }
                if (this.contactFilter != null && !this.contactFilter.shouldCollide(fixtureA, fixtureB)) {
                    Contact cNuke = c;
                    c = cNuke.getNext();
                    this.destroy(cNuke);
                    continue;
                }
                c.flags &= 0xFFFFFFF7;
            }
            boolean activeA = bodyA.isAwake() && bodyA.type != BodyType.STATIC;
            boolean bl = activeB = bodyB.isAwake() && bodyB.type != BodyType.STATIC;
            if (!activeA && !activeB) {
                c = c.getNext();
                continue;
            }
            int proxyIdA = fixtureA.proxies[indexA].proxyId;
            int proxyIdB = fixtureB.proxies[indexB].proxyId;
            boolean overlap = this.broadPhase.testOverlap(proxyIdA, proxyIdB);
            if (!overlap) {
                Contact cNuke = c;
                c = cNuke.getNext();
                this.destroy(cNuke);
                continue;
            }
            c.update(this.contactListener);
            c = c.getNext();
        }
    }
}

