/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.physics;

import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.BodyType;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionEvent;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureData;
import de.pirckheimer_gymnasium.engine_pi.physics.PhysicsData;
import de.pirckheimer_gymnasium.engine_pi.physics.PhysicsHandler;
import de.pirckheimer_gymnasium.engine_pi.physics.WorldHandler;
import de.pirckheimer_gymnasium.jbox2d.collision.AABB;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Body;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Fixture;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.ContactEdge;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class BodyHandler
implements PhysicsHandler {
    private static final Vec2 NULL_VECTOR = new Vec2();
    private static final int DEFAULT_MASK_BITS = 65535;
    private final WorldHandler worldHandler;
    private final Body body;
    private BodyType type;

    @Internal
    public BodyHandler(Actor actor, PhysicsData physicsData, WorldHandler worldHandler) {
        this.worldHandler = worldHandler;
        this.body = physicsData.createBody(worldHandler, actor);
        this.setType(physicsData.getType());
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveBy(Vector meters) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            this.worldHandler.assertNoWorldStep();
            Vec2 vector = meters.toVec2();
            this.body.setTransform(vector.addLocal(this.body.getPosition()), this.body.getAngle());
            this.body.setAwake(true);
        }
    }

    @Override
    public Vector getCenter() {
        if (this.type == BodyType.DYNAMIC || this.type == BodyType.PARTICLE) {
            return Vector.of(this.body.getWorldCenter());
        }
        return Vector.of(this.calculateBodyAABB().getCenter());
    }

    @Override
    public boolean contains(Vector vector) {
        Vec2 point = vector.toVec2();
        Fixture fixture = this.body.fixtureList;
        while (fixture != null) {
            if (fixture.testPoint(point)) {
                return true;
            }
            fixture = fixture.next;
        }
        return false;
    }

    @Override
    public Vector getPosition() {
        return Vector.of(this.body.getPosition());
    }

    @Override
    public double getRotation() {
        return Math.toDegrees(this.body.getAngle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotateBy(double degree) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            this.worldHandler.assertNoWorldStep();
            this.body.setTransform(this.body.getPosition(), (float)((double)this.body.getAngle() + Math.toRadians(degree)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRotation(double degree) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            this.worldHandler.assertNoWorldStep();
            this.body.setTransform(this.body.getPosition(), (float)Math.toRadians(degree));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDensity(double density) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            Fixture fixture = this.body.fixtureList;
            while (fixture != null) {
                fixture.setDensity((float)density);
                fixture = fixture.next;
            }
            this.body.resetMassData();
        }
    }

    @Override
    public double getDensity() {
        return this.body.fixtureList.getDensity();
    }

    @Override
    public void setGravityScale(double factor) {
        this.body.setGravityScale((float)factor);
        this.body.setAwake(true);
    }

    @Override
    public double getGravityScale() {
        return this.body.getGravityScale();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFriction(double friction) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            Fixture fixture = this.body.fixtureList;
            while (fixture != null) {
                fixture.setFriction((float)friction);
                fixture = fixture.next;
            }
        }
    }

    @Override
    public double getFriction() {
        return this.body.fixtureList.getFriction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRestitution(double elasticity) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            Fixture fixture = this.body.fixtureList;
            while (fixture != null) {
                fixture.setRestitution((float)elasticity);
                fixture = fixture.next;
            }
        }
    }

    @Override
    public double getRestitution() {
        return this.body.fixtureList.getRestitution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLinearDamping(double damping) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            this.body.setLinearDamping((float)damping);
        }
    }

    @Override
    public double getLinearDamping() {
        return this.body.getLinearDamping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAngularDamping(double damping) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            this.body.setAngularDamping((float)damping);
        }
    }

    @Override
    public double getAngularDamping() {
        return this.body.getAngularDamping();
    }

    @Override
    public double getMass() {
        return this.body.getMass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyForce(Vector force) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            this.body.applyForceToCenter(force.toVec2());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyTorque(double torque) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            this.body.applyTorque((float)torque);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyRotationImpulse(double rotationImpulse) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            this.body.applyAngularImpulse((float)rotationImpulse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setType(BodyType type) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            this.worldHandler.assertNoWorldStep();
            if (type == this.type) {
                return;
            }
            this.type = type;
            this.body.setType(type.toBox2D());
            this.body.setActive(true);
            this.body.setAwake(true);
            Fixture fixture = this.body.fixtureList;
            while (fixture != null) {
                fixture.isSensor = type.isSensor();
                switch (type) {
                    case SENSOR: {
                        fixture.filter.categoryBits = 1;
                        fixture.filter.maskBits = 65519;
                        break;
                    }
                    case STATIC: {
                        fixture.filter.categoryBits = 2;
                        fixture.filter.maskBits = 65535;
                        break;
                    }
                    case KINEMATIC: {
                        fixture.filter.categoryBits = 4;
                        fixture.filter.maskBits = 65535;
                        break;
                    }
                    case DYNAMIC: {
                        fixture.filter.categoryBits = 8;
                        fixture.filter.maskBits = 65519;
                        break;
                    }
                    case PARTICLE: {
                        fixture.filter.categoryBits = 16;
                        fixture.filter.maskBits = 6;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown body type: " + type);
                    }
                }
                fixture = fixture.next;
            }
        }
    }

    @Override
    public BodyType getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyForce(Vector forceInN, Vector globalLocation) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            this.body.applyForce(forceInN.toVec2(), globalLocation.toVec2());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyImpulse(Vector impulseInNs, Vector globalLocation) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            this.body.applyLinearImpulse(impulseInNs.toVec2(), globalLocation.toVec2(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetMovement() {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            this.body.setLinearVelocity(NULL_VECTOR);
            this.body.setAngularVelocity(0.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVelocity(Vector metersPerSecond) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            this.body.setLinearVelocity(metersPerSecond.toVec2());
        }
    }

    @Override
    public Vector getVelocity() {
        return Vector.of(this.body.getLinearVelocity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAngularVelocity(double rotationsPerSecond) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            this.body.setAngularVelocity((float)Math.toRadians(rotationsPerSecond * 360.0));
        }
    }

    @Override
    public double getAngularVelocity() {
        return Math.toDegrees(this.body.getAngularVelocity()) / 360.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRotationLocked(boolean locked) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            this.body.setFixedRotation(locked);
        }
    }

    @Override
    public boolean isRotationLocked() {
        return this.body.isFixedRotation();
    }

    private AABB calculateBodyAABB() {
        AABB bodyBounds = new AABB();
        bodyBounds.lowerBound.x = Float.MAX_VALUE;
        bodyBounds.lowerBound.y = Float.MAX_VALUE;
        bodyBounds.upperBound.x = -3.4028235E38f;
        bodyBounds.upperBound.y = -3.4028235E38f;
        Fixture fixture = this.body.fixtureList;
        while (fixture != null) {
            bodyBounds.combine(bodyBounds, fixture.getAABB(0));
            fixture = fixture.next;
        }
        return bodyBounds;
    }

    @Override
    public boolean isGrounded() {
        Fixture[] groundCandidates;
        if (this.getType() != BodyType.DYNAMIC) {
            throw new RuntimeException("Der Steh-Test ist nur f\u00fcr dynamische Objekte definiert");
        }
        AABB bodyBounds = this.calculateBodyAABB();
        AABB testAABB = new AABB();
        double epsilon = 1.0E-4;
        testAABB.lowerBound.set(bodyBounds.lowerBound.x, bodyBounds.lowerBound.y);
        testAABB.upperBound.set(bodyBounds.upperBound.x, (float)((double)bodyBounds.lowerBound.y + 1.0E-4));
        for (Fixture fixture : groundCandidates = this.worldHandler.queryAABB(testAABB)) {
            Actor corresponding = (Actor)fixture.getBody().getUserData();
            if (corresponding == null || corresponding.getBodyType() != BodyType.STATIC) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFixtures(Supplier<List<FixtureData>> fixtures) {
        WorldHandler worldHandler = this.worldHandler;
        synchronized (worldHandler) {
            PhysicsData physicsData = this.getPhysicsData();
            Fixture fixture = this.body.fixtureList;
            while (fixture != null) {
                this.body.destroyFixture(fixture);
                fixture = fixture.next;
            }
            for (FixtureData fixtureData : fixtures.get()) {
                this.body.createFixture(fixtureData.createFixtureDef(physicsData));
            }
        }
    }

    @Override
    @Internal
    public PhysicsData getPhysicsData() {
        return PhysicsData.fromBody(this.body, this.getType());
    }

    @Override
    public void applyMountCallbacks(PhysicsHandler otherHandler) {
    }

    @Override
    public List<CollisionEvent<Actor>> getCollisions() {
        ArrayList<CollisionEvent<Actor>> contacts = new ArrayList<CollisionEvent<Actor>>();
        ContactEdge contact = this.body.getContactList();
        while (contact != null) {
            if (contact.contact.isTouching()) {
                contacts.add(new CollisionEvent<Actor>(contact.contact, (Actor)contact.other.getUserData()));
            }
            contact = contact.next;
        }
        return contacts;
    }

    @Override
    public WorldHandler getWorldHandler() {
        return this.worldHandler;
    }

    @Override
    public void setAwake(boolean value) {
        this.body.setAwake(value);
    }
}

