/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Animation;
import de.pirckheimer_gymnasium.engine_pi.animation.AnimationFrame;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureBuilder;
import java.awt.Graphics2D;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StatefulAnimation<State>
extends Actor {
    private final Map<State, AnimationFrame[]> states = new ConcurrentHashMap<State, AnimationFrame[]>();
    private final Map<State, State> stateTransitions = new ConcurrentHashMap<State, State>();
    private State state = null;
    private AnimationFrame[] animation = null;
    private double time = 0.0;
    private int index = 0;
    protected double width;
    protected double height;
    private boolean flipHorizontal = false;
    private boolean flipVertical = false;
    private boolean animationPaused = false;
    protected double frameDuration;

    public StatefulAnimation(double width, double height, double frameDuration) {
        super(() -> FixtureBuilder.rectangle(width, height));
        this.width = width;
        this.height = height;
        this.frameDuration = frameDuration;
        this.addFrameUpdateListener(this::internalOnFrameUpdate);
    }

    public StatefulAnimation(double width, double height) {
        this(width, height, -1.0);
    }

    @API
    public double getWidth() {
        return this.width;
    }

    @API
    public double getHeight() {
        return this.height;
    }

    @API
    public void addState(State state, Animation stateAnimation) {
        if (this.states.containsKey(state)) {
            throw new RuntimeException("Zustandsname wird bereits in diesem Objekt genutzt: " + String.valueOf(state));
        }
        AnimationFrame[] frames = stateAnimation.getFrames();
        this.states.put(state, frames);
        this.stateTransitions.put(state, state);
        if (this.state == null) {
            this.state = state;
            this.animation = frames;
        }
    }

    @API
    public void setState(State state) {
        if (!this.states.containsKey(state)) {
            throw new RuntimeException("Zustand nicht nicht vorhanden: " + String.valueOf(state));
        }
        this.index = 0;
        this.state = state;
        this.time = 0.0;
        this.animation = this.states.get(state);
    }

    @API
    public void changeState(State state) {
        if (!state.equals(this.state)) {
            this.setState(state);
        }
    }

    @API
    public boolean hasState(State state) {
        return this.states.containsKey(state);
    }

    @API
    public State getState() {
        return this.state;
    }

    @API
    public void setFlipHorizontal(boolean flipHorizontal) {
        this.flipHorizontal = flipHorizontal;
    }

    @API
    public void setFlipVertical(boolean flipVertical) {
        this.flipVertical = flipVertical;
    }

    @API
    public boolean isFlipHorizontal() {
        return this.flipHorizontal;
    }

    @API
    public boolean isFlipVertical() {
        return this.flipVertical;
    }

    @API
    public void setAnimationPaused(boolean animationPaused) {
        this.animationPaused = animationPaused;
    }

    @API
    public boolean isAnimationPaused() {
        return this.animationPaused;
    }

    @API
    public void setStateTransition(State stateFrom, State stateTo) {
        if (!this.states.containsKey(stateFrom)) {
            throw new RuntimeException("Der Von-Zustand ist nicht in dieser Animation eingepflegt: " + String.valueOf(stateFrom));
        }
        if (!this.states.containsKey(stateTo)) {
            throw new RuntimeException("Der To-Zustand ist nicht in dieser Animation eingepflegt: " + String.valueOf(stateTo));
        }
        this.stateTransitions.remove(stateFrom);
        this.stateTransitions.put(stateFrom, stateTo);
    }

    @API
    public void setFrameDuration(State state, double frameDuration) {
        if (!this.states.containsKey(state)) {
            throw new RuntimeException("Der Zustand ist nicht bekannt: " + String.valueOf(state));
        }
        for (AnimationFrame frame : this.states.get(state)) {
            frame.setDuration(frameDuration);
        }
    }

    @Internal
    private void internalOnFrameUpdate(double frameDuration) {
        if (this.animation == null || this.animation.length == 0 || this.animationPaused) {
            return;
        }
        this.time += frameDuration;
        AnimationFrame currentFrame = this.animation[this.index];
        while (this.time > currentFrame.getDuration()) {
            this.time -= currentFrame.getDuration();
            if (this.index + 1 == this.animation.length) {
                this.index = 0;
                State nextState = this.stateTransitions.get(this.state);
                AnimationFrame[] nextAnimation = this.states.get(nextState);
                this.state = nextState;
                this.animation = nextAnimation;
                continue;
            }
            ++this.index;
        }
    }

    @API
    public void setSize(double width, double height) {
        StatefulAnimation.assertPositiveWidthAndHeight(width, height);
        this.width = width;
        this.height = height;
        this.setFixture(() -> FixtureBuilder.rectangle(width, height));
    }

    @Override
    @Internal
    public void render(Graphics2D g, double pixelPerMeter) {
        if (this.animation == null || this.animation.length == 0) {
            return;
        }
        this.animation[this.index].render(g, this.width * pixelPerMeter, this.height * pixelPerMeter, this.flipHorizontal, this.flipVertical);
    }
}

