/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.little_engine;

import de.pirckheimer_gymnasium.engine_pi.little_engine.DrawingWindow;

public class Circle {
    public int x = 60;
    public int y = 60;
    public int radius = 50;
    public String farbe = "rot";
    public boolean sichtbar = true;
    public int winkel = 0;
    DrawingWindow.GrafikSymbol symbol = DrawingWindow.SymbolErzeugen(DrawingWindow.SymbolArt.kreis);

    public Circle() {
        this.symbol.PositionSetzen(this.x - this.radius, this.y - this.radius);
        this.symbol.Gr\u00f6\u00dfeSetzen(this.radius * 2, this.radius * 2);
        this.symbol.FarbeSetzen(this.farbe);
        this.symbol.SichtbarkeitSetzen(this.sichtbar);
        this.symbol.WinkelSetzen(this.winkel);
    }

    public void PositionSetzen(int x, int y) {
        this.x = x;
        this.y = y;
        this.symbol.PositionSetzen(x - this.radius, y - this.radius);
    }

    public void Verschieben(int deltaX, int deltaY) {
        this.x += deltaX;
        this.y += deltaY;
        this.symbol.PositionSetzen(this.x - this.radius, this.y - this.radius);
    }

    public void Drehen(int grad) {
        this.winkel += grad;
        this.symbol.WinkelSetzen(this.winkel);
    }

    public void RadiusSetzen(int radius) {
        this.radius = radius;
        this.symbol.Gr\u00f6\u00dfeSetzen(radius * 2, radius * 2);
        this.symbol.PositionSetzen(this.x - radius, this.y - radius);
    }

    public void FarbeSetzen(String farbe) {
        this.farbe = farbe;
        this.symbol.FarbeSetzen(farbe);
    }

    public void WinkelSetzen(int winkel) {
        this.winkel = winkel;
        this.symbol.WinkelSetzen(winkel);
    }

    public void SichtbarkeitSetzen(boolean sichtbar) {
        this.sichtbar = sichtbar;
        this.symbol.SichtbarkeitSetzen(sichtbar);
    }

    public void Entfernen() {
        this.symbol.remove();
    }

    public void NachVornBringen() {
        this.symbol.raiseLayer();
    }

    public void GanzNachVornBringen() {
        this.symbol.bringToFront();
    }

    public void NachHintenBringen() {
        this.symbol.lowerLayer();
    }

    public void GanzNachHintenBringen() {
        this.symbol.bringToBack();
    }
}

