/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.util;

import de.pirckheimer_gymnasium.engine_pi.util.TextAlignment;
import java.text.DecimalFormat;
import java.util.stream.Collectors;

public class TextUtil {
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.00");

    private TextUtil() {
        throw new UnsupportedOperationException();
    }

    public static String roundNumber(Object number) {
        return decimalFormat.format(number);
    }

    public static int getLineWidth(String text) {
        int[] width = new int[]{0};
        text.lines().forEach(line -> {
            if (line.length() > width[0]) {
                width[0] = line.length();
            }
        });
        return width[0];
    }

    public static int getLineCount(String text) {
        return (int)text.lines().count();
    }

    public static String[] splitLines(String text) {
        return (String[])text.lines().toArray(String[]::new);
    }

    public static String align(String text, int width, TextAlignment alignment) {
        return text.lines().map(line -> {
            line = line.trim();
            int length = line.length();
            int spaces = width - length;
            if (alignment == TextAlignment.RIGHT) {
                return " ".repeat(spaces) + line;
            }
            if (alignment == TextAlignment.CENTER) {
                int left = spaces / 2;
                return " ".repeat(left) + line;
            }
            return line;
        }).collect(Collectors.joining("\n"));
    }

    public static String align(String text, TextAlignment alignment) {
        return TextUtil.align(text, TextUtil.getLineWidth(text), alignment);
    }

    public static String wrap(String text, int width, TextAlignment alignment) {
        if (width < 1) {
            width = TextUtil.getLineWidth(text);
        }
        StringBuilder stringBuilder = new StringBuilder(text);
        int index = 0;
        while (stringBuilder.length() > index + width) {
            int lastLineReturn = stringBuilder.lastIndexOf("\n", index + width);
            if (lastLineReturn > index) {
                index = lastLineReturn;
                continue;
            }
            if ((index = stringBuilder.lastIndexOf(" ", index + width)) == -1) {
                throw new IllegalArgumentException("impossible to slice " + stringBuilder.substring(0, width));
            }
            stringBuilder.replace(index, index + 1, "\n");
            ++index;
        }
        return TextUtil.align(stringBuilder.toString(), width, alignment);
    }

    public static String wrap(String text, int width) {
        return TextUtil.wrap(text, width, TextAlignment.LEFT);
    }
}

