/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.collision.broadphase;

import de.pirckheimer_gymnasium.jbox2d.callbacks.DebugDraw;
import de.pirckheimer_gymnasium.jbox2d.callbacks.PairCallback;
import de.pirckheimer_gymnasium.jbox2d.callbacks.TreeCallback;
import de.pirckheimer_gymnasium.jbox2d.callbacks.TreeRayCastCallback;
import de.pirckheimer_gymnasium.jbox2d.collision.AABB;
import de.pirckheimer_gymnasium.jbox2d.collision.RayCastInput;
import de.pirckheimer_gymnasium.jbox2d.collision.broadphase.BroadPhase;
import de.pirckheimer_gymnasium.jbox2d.collision.broadphase.BroadPhaseStrategy;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import java.util.Arrays;

public class DefaultBroadPhaseBuffer
implements TreeCallback,
BroadPhase {
    private final BroadPhaseStrategy tree;
    private int proxyCount = 0;
    private int[] moveBuffer;
    private int moveCapacity;
    private int moveCount;
    private long[] pairBuffer = new long[this.pairCapacity];
    private int pairCapacity = 16;
    private int pairCount = 0;
    private int queryProxyId;

    public DefaultBroadPhaseBuffer(BroadPhaseStrategy strategy) {
        for (int i = 0; i < this.pairCapacity; ++i) {
            this.pairBuffer[i] = 0L;
        }
        this.moveCapacity = 16;
        this.moveCount = 0;
        this.moveBuffer = new int[this.moveCapacity];
        this.tree = strategy;
        this.queryProxyId = -1;
    }

    @Override
    public final int createProxy(AABB aabb, Object userData) {
        int proxyId = this.tree.createProxy(aabb, userData);
        ++this.proxyCount;
        this.bufferMove(proxyId);
        return proxyId;
    }

    @Override
    public final void destroyProxy(int proxyId) {
        this.unbufferMove(proxyId);
        --this.proxyCount;
        this.tree.destroyProxy(proxyId);
    }

    @Override
    public final void moveProxy(int proxyId, AABB aabb, Vec2 displacement) {
        boolean buffer = this.tree.moveProxy(proxyId, aabb, displacement);
        if (buffer) {
            this.bufferMove(proxyId);
        }
    }

    @Override
    public void touchProxy(int proxyId) {
        this.bufferMove(proxyId);
    }

    @Override
    public Object getUserData(int proxyId) {
        return this.tree.getUserData(proxyId);
    }

    @Override
    public AABB getFatAABB(int proxyId) {
        return this.tree.getFatAABB(proxyId);
    }

    @Override
    public boolean testOverlap(int proxyIdA, int proxyIdB) {
        AABB a = this.tree.getFatAABB(proxyIdA);
        AABB b = this.tree.getFatAABB(proxyIdB);
        if (b.lowerBound.x - a.upperBound.x > 0.0f || b.lowerBound.y - a.upperBound.y > 0.0f) {
            return false;
        }
        return !(a.lowerBound.x - b.upperBound.x > 0.0f) && !(a.lowerBound.y - b.upperBound.y > 0.0f);
    }

    @Override
    public final int getProxyCount() {
        return this.proxyCount;
    }

    @Override
    public void drawTree(DebugDraw argDraw) {
        this.tree.drawTree(argDraw);
    }

    @Override
    public final void updatePairs(PairCallback callback) {
        int i;
        this.pairCount = 0;
        for (i = 0; i < this.moveCount; ++i) {
            this.queryProxyId = this.moveBuffer[i];
            if (this.queryProxyId == -1) continue;
            AABB fatAABB = this.tree.getFatAABB(this.queryProxyId);
            this.tree.query(this, fatAABB);
        }
        this.moveCount = 0;
        Arrays.sort(this.pairBuffer, 0, this.pairCount);
        i = 0;
        while (i < this.pairCount) {
            long pair;
            long primaryPair = this.pairBuffer[i];
            Object userDataA = this.tree.getUserData((int)(primaryPair >> 32));
            Object userDataB = this.tree.getUserData((int)primaryPair);
            callback.addPair(userDataA, userDataB);
            ++i;
            while (i < this.pairCount && (pair = this.pairBuffer[i]) == primaryPair) {
                ++i;
            }
        }
    }

    @Override
    public final void query(TreeCallback callback, AABB aabb) {
        this.tree.query(callback, aabb);
    }

    @Override
    public final void raycast(TreeRayCastCallback callback, RayCastInput input) {
        this.tree.raycast(callback, input);
    }

    @Override
    public final int getTreeHeight() {
        return this.tree.getHeight();
    }

    @Override
    public int getTreeBalance() {
        return this.tree.getMaxBalance();
    }

    @Override
    public float getTreeQuality() {
        return this.tree.getAreaRatio();
    }

    protected final void bufferMove(int proxyId) {
        if (this.moveCount == this.moveCapacity) {
            int[] old = this.moveBuffer;
            this.moveCapacity *= 2;
            this.moveBuffer = new int[this.moveCapacity];
            System.arraycopy(old, 0, this.moveBuffer, 0, old.length);
        }
        this.moveBuffer[this.moveCount] = proxyId;
        ++this.moveCount;
    }

    protected final void unbufferMove(int proxyId) {
        for (int i = 0; i < this.moveCount; ++i) {
            if (this.moveBuffer[i] != proxyId) continue;
            this.moveBuffer[i] = -1;
        }
    }

    @Override
    public final boolean treeCallback(int proxyId) {
        if (proxyId == this.queryProxyId) {
            return true;
        }
        if (this.pairCount == this.pairCapacity) {
            long[] oldBuffer = this.pairBuffer;
            this.pairCapacity *= 2;
            this.pairBuffer = new long[this.pairCapacity];
            System.arraycopy(oldBuffer, 0, this.pairBuffer, 0, oldBuffer.length);
            for (int i = oldBuffer.length; i < this.pairCapacity; ++i) {
                this.pairBuffer[i] = 0L;
            }
        }
        this.pairBuffer[this.pairCount] = proxyId < this.queryProxyId ? (long)proxyId << 32 | (long)this.queryProxyId : (long)this.queryProxyId << 32 | (long)proxyId;
        ++this.pairCount;
        return true;
    }
}

