/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.collision.shapes;

import de.pirckheimer_gymnasium.jbox2d.collision.AABB;
import de.pirckheimer_gymnasium.jbox2d.collision.RayCastInput;
import de.pirckheimer_gymnasium.jbox2d.collision.RayCastOutput;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.EdgeShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.MassData;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.Shape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.ShapeType;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Settings;
import de.pirckheimer_gymnasium.jbox2d.common.Transform;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;

public class ChainShape
extends Shape {
    public Vec2[] vertices = null;
    public int count;
    public final Vec2 prevVertex = new Vec2();
    public final Vec2 nextVertex = new Vec2();
    public boolean hasPrevVertex = false;
    public boolean hasNextVertex = false;
    private final EdgeShape pool0 = new EdgeShape();

    public ChainShape() {
        super(ShapeType.CHAIN);
        this.radius = Settings.polygonRadius;
        this.count = 0;
    }

    public void clear() {
        this.vertices = null;
        this.count = 0;
    }

    @Override
    public int getChildCount() {
        return this.count - 1;
    }

    public void getChildEdge(EdgeShape edge, int index) {
        Vec2 v;
        assert (0 <= index && index < this.count - 1);
        edge.radius = this.radius;
        Vec2 v0 = this.vertices[index];
        Vec2 v1 = this.vertices[index + 1];
        edge.vertex1.x = v0.x;
        edge.vertex1.y = v0.y;
        edge.vertex2.x = v1.x;
        edge.vertex2.y = v1.y;
        if (index > 0) {
            v = this.vertices[index - 1];
            edge.vertex0.x = v.x;
            edge.vertex0.y = v.y;
            edge.hasVertex0 = true;
        } else {
            edge.vertex0.x = this.prevVertex.x;
            edge.vertex0.y = this.prevVertex.y;
            edge.hasVertex0 = this.hasPrevVertex;
        }
        if (index < this.count - 2) {
            v = this.vertices[index + 2];
            edge.vertex3.x = v.x;
            edge.vertex3.y = v.y;
            edge.hasVertex3 = true;
        } else {
            edge.vertex3.x = this.nextVertex.x;
            edge.vertex3.y = this.nextVertex.y;
            edge.hasVertex3 = this.hasNextVertex;
        }
    }

    @Override
    public float computeDistanceToOut(Transform xf, Vec2 p, int childIndex, Vec2 normalOut) {
        EdgeShape edge = this.pool0;
        this.getChildEdge(edge, childIndex);
        return edge.computeDistanceToOut(xf, p, 0, normalOut);
    }

    @Override
    public boolean testPoint(Transform xf, Vec2 p) {
        return false;
    }

    @Override
    public boolean raycast(RayCastOutput output, RayCastInput input, Transform xf, int childIndex) {
        assert (childIndex < this.count);
        EdgeShape edgeShape = this.pool0;
        int i1 = childIndex;
        int i2 = childIndex + 1;
        if (i2 == this.count) {
            i2 = 0;
        }
        Vec2 v = this.vertices[i1];
        edgeShape.vertex1.x = v.x;
        edgeShape.vertex1.y = v.y;
        Vec2 v1 = this.vertices[i2];
        edgeShape.vertex2.x = v1.x;
        edgeShape.vertex2.y = v1.y;
        return edgeShape.raycast(output, input, xf, 0);
    }

    @Override
    public void computeAABB(AABB aabb, Transform xf, int childIndex) {
        assert (childIndex < this.count);
        Vec2 lower = aabb.lowerBound;
        Vec2 upper = aabb.upperBound;
        int i1 = childIndex;
        int i2 = childIndex + 1;
        if (i2 == this.count) {
            i2 = 0;
        }
        Vec2 vi1 = this.vertices[i1];
        Vec2 vi2 = this.vertices[i2];
        Rot xfq = xf.q;
        Vec2 xfp = xf.p;
        float v1x = xfq.c * vi1.x - xfq.s * vi1.y + xfp.x;
        float v1y = xfq.s * vi1.x + xfq.c * vi1.y + xfp.y;
        float v2x = xfq.c * vi2.x - xfq.s * vi2.y + xfp.x;
        float v2y = xfq.s * vi2.x + xfq.c * vi2.y + xfp.y;
        lower.x = Math.min(v1x, v2x);
        lower.y = Math.min(v1y, v2y);
        upper.x = Math.max(v1x, v2x);
        upper.y = Math.max(v1y, v2y);
    }

    @Override
    public void computeMass(MassData massData, float density) {
        massData.mass = 0.0f;
        massData.center.setZero();
        massData.I = 0.0f;
    }

    @Override
    public Shape clone() {
        ChainShape clone = new ChainShape();
        clone.createChain(this.vertices, this.count);
        clone.prevVertex.set(this.prevVertex);
        clone.nextVertex.set(this.nextVertex);
        clone.hasPrevVertex = this.hasPrevVertex;
        clone.hasNextVertex = this.hasNextVertex;
        return clone;
    }

    public void createLoop(Vec2[] vertices, int count) {
        int i;
        assert (this.vertices == null && this.count == 0);
        assert (count >= 3);
        this.count = count + 1;
        this.vertices = new Vec2[this.count];
        for (i = 1; i < count; ++i) {
            Vec2 v1 = vertices[i - 1];
            Vec2 v2 = vertices[i];
            if (!(MathUtils.distanceSquared(v1, v2) < Settings.linearSlop * Settings.linearSlop)) continue;
            throw new RuntimeException("Vertices of chain shape are too close together");
        }
        for (i = 0; i < count; ++i) {
            this.vertices[i] = new Vec2(vertices[i]);
        }
        this.vertices[count] = new Vec2(this.vertices[0]);
        this.prevVertex.set(this.vertices[this.count - 2]);
        this.nextVertex.set(this.vertices[1]);
        this.hasPrevVertex = true;
        this.hasNextVertex = true;
    }

    public void createChain(Vec2[] vertices, int count) {
        int i;
        assert (this.vertices == null && this.count == 0);
        assert (count >= 2);
        this.count = count;
        this.vertices = new Vec2[this.count];
        for (i = 1; i < this.count; ++i) {
            Vec2 v1 = vertices[i - 1];
            Vec2 v2 = vertices[i];
            if (!(MathUtils.distanceSquared(v1, v2) < Settings.linearSlop * Settings.linearSlop)) continue;
            throw new RuntimeException("Vertices of chain shape are too close together");
        }
        for (i = 0; i < this.count; ++i) {
            this.vertices[i] = new Vec2(vertices[i]);
        }
        this.hasPrevVertex = false;
        this.hasNextVertex = false;
        this.prevVertex.setZero();
        this.nextVertex.setZero();
    }

    public void setPrevVertex(Vec2 prevVertex) {
        this.prevVertex.set(prevVertex);
        this.hasPrevVertex = true;
    }

    public void setNextVertex(Vec2 nextVertex) {
        this.nextVertex.set(nextVertex);
        this.hasNextVertex = true;
    }
}

