/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics.joints;

import de.pirckheimer_gymnasium.jbox2d.common.Mat22;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.SolverData;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.FrictionJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.Joint;
import de.pirckheimer_gymnasium.jbox2d.pooling.IWorldPool;

public class FrictionJoint
extends Joint {
    private final Vec2 localAnchorA;
    private final Vec2 localAnchorB;
    private final Vec2 linearImpulse;
    private float angularImpulse;
    private float maxForce;
    private float maxTorque;
    private int indexA;
    private int indexB;
    private final Vec2 rA = new Vec2();
    private final Vec2 rB = new Vec2();
    private final Vec2 localCenterA = new Vec2();
    private final Vec2 localCenterB = new Vec2();
    private float invMassA;
    private float invMassB;
    private float invIA;
    private float invIB;
    private final Mat22 linearMass = new Mat22();
    private float angularMass;

    protected FrictionJoint(IWorldPool argWorldPool, FrictionJointDef def) {
        super(argWorldPool, def);
        this.localAnchorA = new Vec2(def.localAnchorA);
        this.localAnchorB = new Vec2(def.localAnchorB);
        this.linearImpulse = new Vec2();
        this.angularImpulse = 0.0f;
        this.maxForce = def.maxForce;
        this.maxTorque = def.maxTorque;
    }

    public Vec2 getLocalAnchorA() {
        return this.localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.localAnchorB;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.bodyA.getWorldPointToOut(this.localAnchorA, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.bodyB.getWorldPointToOut(this.localAnchorB, argOut);
    }

    @Override
    public void getReactionForce(float invDt, Vec2 argOut) {
        argOut.set(this.linearImpulse).mulLocal(invDt);
    }

    @Override
    public float getReactionTorque(float invDt) {
        return invDt * this.angularImpulse;
    }

    public void setMaxForce(float force) {
        assert (force >= 0.0f);
        this.maxForce = force;
    }

    public float getMaxForce() {
        return this.maxForce;
    }

    public void setMaxTorque(float torque) {
        assert (torque >= 0.0f);
        this.maxTorque = torque;
    }

    public float getMaxTorque() {
        return this.maxTorque;
    }

    @Override
    public void initVelocityConstraints(SolverData data) {
        this.indexA = this.bodyA.islandIndex;
        this.indexB = this.bodyB.islandIndex;
        this.localCenterA.set(this.bodyA.sweep.localCenter);
        this.localCenterB.set(this.bodyB.sweep.localCenter);
        this.invMassA = this.bodyA.invMass;
        this.invMassB = this.bodyB.invMass;
        this.invIA = this.bodyA.invI;
        this.invIB = this.bodyB.invI;
        float aA = data.positions[this.indexA].a;
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        float aB = data.positions[this.indexB].a;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        Vec2 temp = this.pool.popVec2();
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOutUnsafe(qA, temp.set(this.localAnchorA).subLocal(this.localCenterA), this.rA);
        Rot.mulToOutUnsafe(qB, temp.set(this.localAnchorB).subLocal(this.localCenterB), this.rB);
        float mA = this.invMassA;
        float mB = this.invMassB;
        float iA = this.invIA;
        float iB = this.invIB;
        Mat22 K = this.pool.popMat22();
        K.ex.x = mA + mB + iA * this.rA.y * this.rA.y + iB * this.rB.y * this.rB.y;
        K.ey.x = K.ex.y = -iA * this.rA.x * this.rA.y - iB * this.rB.x * this.rB.y;
        K.ey.y = mA + mB + iA * this.rA.x * this.rA.x + iB * this.rB.x * this.rB.x;
        K.invertToOut(this.linearMass);
        this.angularMass = iA + iB;
        if (this.angularMass > 0.0f) {
            this.angularMass = 1.0f / this.angularMass;
        }
        if (data.step.warmStarting) {
            this.linearImpulse.mulLocal(data.step.dtRatio);
            this.angularImpulse *= data.step.dtRatio;
            Vec2 P = this.pool.popVec2();
            P.set(this.linearImpulse);
            temp.set(P).mulLocal(mA);
            vA.subLocal(temp);
            wA -= iA * (Vec2.cross(this.rA, P) + this.angularImpulse);
            temp.set(P).mulLocal(mB);
            vB.addLocal(temp);
            wB += iB * (Vec2.cross(this.rB, P) + this.angularImpulse);
            this.pool.pushVec2(1);
        } else {
            this.linearImpulse.setZero();
            this.angularImpulse = 0.0f;
        }
        assert (data.velocities[this.indexA].w == wA || data.velocities[this.indexA].w != wA);
        data.velocities[this.indexA].w = wA;
        data.velocities[this.indexB].w = wB;
        this.pool.pushRot(2);
        this.pool.pushVec2(1);
        this.pool.pushMat22(1);
    }

    @Override
    public void solveVelocityConstraints(SolverData data) {
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        float mA = this.invMassA;
        float mB = this.invMassB;
        float iA = this.invIA;
        float iB = this.invIB;
        float h = data.step.dt;
        float Cdot = wB - wA;
        float impulse = -this.angularMass * Cdot;
        float oldImpulse = this.angularImpulse;
        float maxImpulse = h * this.maxTorque;
        this.angularImpulse = MathUtils.clamp(this.angularImpulse + impulse, -maxImpulse, maxImpulse);
        impulse = this.angularImpulse - oldImpulse;
        Vec2 Cdot2 = this.pool.popVec2();
        Vec2 temp = this.pool.popVec2();
        Vec2.crossToOutUnsafe(wA -= iA * impulse, this.rA, temp);
        Vec2.crossToOutUnsafe(wB += iB * impulse, this.rB, Cdot2);
        Cdot2.addLocal(vB).subLocal(vA).subLocal(temp);
        Vec2 impulse2 = this.pool.popVec2();
        Mat22.mulToOutUnsafe(this.linearMass, Cdot2, impulse2);
        impulse2.negateLocal();
        Vec2 oldImpulse2 = this.pool.popVec2();
        oldImpulse2.set(this.linearImpulse);
        this.linearImpulse.addLocal(impulse2);
        float maxImpulse2 = h * this.maxForce;
        if (this.linearImpulse.lengthSquared() > maxImpulse2 * maxImpulse2) {
            this.linearImpulse.normalize();
            this.linearImpulse.mulLocal(maxImpulse2);
        }
        impulse2.set(this.linearImpulse).subLocal(oldImpulse2);
        temp.set(impulse2).mulLocal(mA);
        vA.subLocal(temp);
        wA -= iA * Vec2.cross(this.rA, impulse2);
        temp.set(impulse2).mulLocal(mB);
        vB.addLocal(temp);
        wB += iB * Vec2.cross(this.rB, impulse2);
        assert (data.velocities[this.indexA].w == wA || data.velocities[this.indexA].w != wA);
        data.velocities[this.indexA].w = wA;
        data.velocities[this.indexB].w = wB;
        this.pool.pushVec2(4);
    }

    @Override
    public boolean solvePositionConstraints(SolverData data) {
        return true;
    }
}

