/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics.joints;

import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Body;
import de.pirckheimer_gymnasium.jbox2d.dynamics.SolverData;
import de.pirckheimer_gymnasium.jbox2d.dynamics.World;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.ConstantVolumeJoint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.ConstantVolumeJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.DistanceJoint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.DistanceJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.FrictionJoint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.FrictionJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.GearJoint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.GearJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.JointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.JointEdge;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.JointType;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.MotorJoint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.MotorJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.MouseJoint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.MouseJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.PrismaticJoint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.PrismaticJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.PulleyJoint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.PulleyJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RopeJoint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RopeJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.WeldJoint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.WeldJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.WheelJoint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.WheelJointDef;
import de.pirckheimer_gymnasium.jbox2d.pooling.IWorldPool;

public abstract class Joint {
    private final JointType type;
    public Joint prev;
    public Joint next;
    public JointEdge edgeA;
    public JointEdge edgeB;
    protected Body bodyA;
    protected Body bodyB;
    public boolean islandFlag;
    private final boolean collideConnected;
    public Object userData;
    protected IWorldPool pool;

    public static Joint create(World world, JointDef def) {
        return switch (def.type) {
            case JointType.MOUSE -> new MouseJoint(world.getPool(), (MouseJointDef)def);
            case JointType.DISTANCE -> new DistanceJoint(world.getPool(), (DistanceJointDef)def);
            case JointType.PRISMATIC -> new PrismaticJoint(world.getPool(), (PrismaticJointDef)def);
            case JointType.REVOLUTE -> new RevoluteJoint(world.getPool(), (RevoluteJointDef)def);
            case JointType.WELD -> new WeldJoint(world.getPool(), (WeldJointDef)def);
            case JointType.FRICTION -> new FrictionJoint(world.getPool(), (FrictionJointDef)def);
            case JointType.WHEEL -> new WheelJoint(world.getPool(), (WheelJointDef)def);
            case JointType.GEAR -> new GearJoint(world.getPool(), (GearJointDef)def);
            case JointType.PULLEY -> new PulleyJoint(world.getPool(), (PulleyJointDef)def);
            case JointType.CONSTANT_VOLUME -> new ConstantVolumeJoint(world, (ConstantVolumeJointDef)def);
            case JointType.ROPE -> new RopeJoint(world.getPool(), (RopeJointDef)def);
            case JointType.MOTOR -> new MotorJoint(world.getPool(), (MotorJointDef)def);
            default -> null;
        };
    }

    public static void destroy(Joint joint) {
        joint.destructor();
    }

    protected Joint(IWorldPool worldPool, JointDef def) {
        assert (def.bodyA != def.bodyB);
        this.pool = worldPool;
        this.type = def.type;
        this.prev = null;
        this.next = null;
        this.bodyA = def.bodyA;
        this.bodyB = def.bodyB;
        this.collideConnected = def.collideConnected;
        this.islandFlag = false;
        this.userData = def.userData;
        this.edgeA = new JointEdge();
        this.edgeA.joint = null;
        this.edgeA.other = null;
        this.edgeA.prev = null;
        this.edgeA.next = null;
        this.edgeB = new JointEdge();
        this.edgeB.joint = null;
        this.edgeB.other = null;
        this.edgeB.prev = null;
        this.edgeB.next = null;
    }

    public JointType getType() {
        return this.type;
    }

    public final Body getBodyA() {
        return this.bodyA;
    }

    public final Body getBodyB() {
        return this.bodyB;
    }

    public abstract void getAnchorA(Vec2 var1);

    public abstract void getAnchorB(Vec2 var1);

    public abstract void getReactionForce(float var1, Vec2 var2);

    public abstract float getReactionTorque(float var1);

    public Joint getNext() {
        return this.next;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object data) {
        this.userData = data;
    }

    public final boolean getCollideConnected() {
        return this.collideConnected;
    }

    public boolean isActive() {
        return this.bodyA.isActive() && this.bodyB.isActive();
    }

    public abstract void initVelocityConstraints(SolverData var1);

    public abstract void solveVelocityConstraints(SolverData var1);

    public abstract boolean solvePositionConstraints(SolverData var1);

    public void destructor() {
    }
}

