/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics.joints;

import de.pirckheimer_gymnasium.jbox2d.common.Mat22;
import de.pirckheimer_gymnasium.jbox2d.common.Mat33;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Settings;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.common.Vec3;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Body;
import de.pirckheimer_gymnasium.jbox2d.dynamics.SolverData;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.Joint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.LimitState;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJointDef;
import de.pirckheimer_gymnasium.jbox2d.pooling.IWorldPool;

public class RevoluteJoint
extends Joint {
    protected final Vec2 localAnchorA = new Vec2();
    protected final Vec2 localAnchorB = new Vec2();
    private final Vec3 impulse = new Vec3();
    private float motorImpulse;
    private boolean enableMotor;
    private float maxMotorTorque;
    private float motorSpeed;
    private boolean enableLimit;
    protected float referenceAngle;
    private float lowerAngle;
    private float upperAngle;
    private int indexA;
    private int indexB;
    private final Vec2 rA = new Vec2();
    private final Vec2 rB = new Vec2();
    private final Vec2 localCenterA = new Vec2();
    private final Vec2 localCenterB = new Vec2();
    private float invMassA;
    private float invMassB;
    private float invIA;
    private float invIB;
    private final Mat33 mass = new Mat33();
    private float motorMass;
    private LimitState limitState;

    protected RevoluteJoint(IWorldPool argWorld, RevoluteJointDef def) {
        super(argWorld, def);
        this.localAnchorA.set(def.localAnchorA);
        this.localAnchorB.set(def.localAnchorB);
        this.referenceAngle = def.referenceAngle;
        this.motorImpulse = 0.0f;
        this.lowerAngle = def.lowerAngle;
        this.upperAngle = def.upperAngle;
        this.maxMotorTorque = def.maxMotorTorque;
        this.motorSpeed = def.motorSpeed;
        this.enableLimit = def.enableLimit;
        this.enableMotor = def.enableMotor;
        this.limitState = LimitState.INACTIVE;
    }

    @Override
    public void initVelocityConstraints(SolverData data) {
        this.indexA = this.bodyA.islandIndex;
        this.indexB = this.bodyB.islandIndex;
        this.localCenterA.set(this.bodyA.sweep.localCenter);
        this.localCenterB.set(this.bodyB.sweep.localCenter);
        this.invMassA = this.bodyA.invMass;
        this.invMassB = this.bodyB.invMass;
        this.invIA = this.bodyA.invI;
        this.invIB = this.bodyB.invI;
        float aA = data.positions[this.indexA].a;
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        float aB = data.positions[this.indexB].a;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 temp = this.pool.popVec2();
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOutUnsafe(qA, temp.set(this.localAnchorA).subLocal(this.localCenterA), this.rA);
        Rot.mulToOutUnsafe(qB, temp.set(this.localAnchorB).subLocal(this.localCenterB), this.rB);
        float mA = this.invMassA;
        float mB = this.invMassB;
        float iA = this.invIA;
        float iB = this.invIB;
        boolean fixedRotation = iA + iB == 0.0f;
        this.mass.ex.x = mA + mB + this.rA.y * this.rA.y * iA + this.rB.y * this.rB.y * iB;
        this.mass.ey.x = -this.rA.y * this.rA.x * iA - this.rB.y * this.rB.x * iB;
        this.mass.ez.x = -this.rA.y * iA - this.rB.y * iB;
        this.mass.ex.y = this.mass.ey.x;
        this.mass.ey.y = mA + mB + this.rA.x * this.rA.x * iA + this.rB.x * this.rB.x * iB;
        this.mass.ez.y = this.rA.x * iA + this.rB.x * iB;
        this.mass.ex.z = this.mass.ez.x;
        this.mass.ey.z = this.mass.ez.y;
        this.mass.ez.z = iA + iB;
        this.motorMass = iA + iB;
        if (this.motorMass > 0.0f) {
            this.motorMass = 1.0f / this.motorMass;
        }
        if (!this.enableMotor || fixedRotation) {
            this.motorImpulse = 0.0f;
        }
        if (this.enableLimit && !fixedRotation) {
            float jointAngle = aB - aA - this.referenceAngle;
            if (MathUtils.abs(this.upperAngle - this.lowerAngle) < 2.0f * Settings.angularSlop) {
                this.limitState = LimitState.EQUAL;
            } else if (jointAngle <= this.lowerAngle) {
                if (this.limitState != LimitState.AT_LOWER) {
                    this.impulse.z = 0.0f;
                }
                this.limitState = LimitState.AT_LOWER;
            } else if (jointAngle >= this.upperAngle) {
                if (this.limitState != LimitState.AT_UPPER) {
                    this.impulse.z = 0.0f;
                }
                this.limitState = LimitState.AT_UPPER;
            } else {
                this.limitState = LimitState.INACTIVE;
                this.impulse.z = 0.0f;
            }
        } else {
            this.limitState = LimitState.INACTIVE;
        }
        if (data.step.warmStarting) {
            Vec2 P = this.pool.popVec2();
            this.impulse.x *= data.step.dtRatio;
            this.impulse.y *= data.step.dtRatio;
            this.motorImpulse *= data.step.dtRatio;
            P.x = this.impulse.x;
            P.y = this.impulse.y;
            vA.x -= mA * P.x;
            vA.y -= mA * P.y;
            wA -= iA * (Vec2.cross(this.rA, P) + this.motorImpulse + this.impulse.z);
            vB.x += mB * P.x;
            vB.y += mB * P.y;
            wB += iB * (Vec2.cross(this.rB, P) + this.motorImpulse + this.impulse.z);
            this.pool.pushVec2(1);
        } else {
            this.impulse.setZero();
            this.motorImpulse = 0.0f;
        }
        data.velocities[this.indexA].w = wA;
        data.velocities[this.indexB].w = wB;
        this.pool.pushVec2(1);
        this.pool.pushRot(2);
    }

    @Override
    public void solveVelocityConstraints(SolverData data) {
        boolean fixedRotation;
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        float mA = this.invMassA;
        float mB = this.invMassB;
        float iA = this.invIA;
        float iB = this.invIB;
        boolean bl = fixedRotation = iA + iB == 0.0f;
        if (this.enableMotor && this.limitState != LimitState.EQUAL && !fixedRotation) {
            float Cdot = wB - wA - this.motorSpeed;
            float impulse = -this.motorMass * Cdot;
            float oldImpulse = this.motorImpulse;
            float maxImpulse = data.step.dt * this.maxMotorTorque;
            this.motorImpulse = MathUtils.clamp(this.motorImpulse + impulse, -maxImpulse, maxImpulse);
            impulse = this.motorImpulse - oldImpulse;
            wA -= iA * impulse;
            wB += iB * impulse;
        }
        Vec2 temp = this.pool.popVec2();
        if (this.enableLimit && this.limitState != LimitState.INACTIVE && !fixedRotation) {
            Vec2 Cdot1 = this.pool.popVec2();
            Vec3 Cdot = this.pool.popVec3();
            Vec2.crossToOutUnsafe(wA, this.rA, temp);
            Vec2.crossToOutUnsafe(wB, this.rB, Cdot1);
            Cdot1.addLocal(vB).subLocal(vA).subLocal(temp);
            float Cdot2 = wB - wA;
            Cdot.set(Cdot1.x, Cdot1.y, Cdot2);
            Vec3 impulse = this.pool.popVec3();
            this.mass.solve33ToOut(Cdot, impulse);
            impulse.negateLocal();
            if (this.limitState == LimitState.EQUAL) {
                this.impulse.addLocal(impulse);
            } else if (this.limitState == LimitState.AT_LOWER) {
                newImpulse = this.impulse.z + impulse.z;
                if (newImpulse < 0.0f) {
                    Vec2 rhs = this.pool.popVec2();
                    rhs.set(this.mass.ez.x, this.mass.ez.y).mulLocal(this.impulse.z).subLocal(Cdot1);
                    this.mass.solve22ToOut(rhs, temp);
                    impulse.x = temp.x;
                    impulse.y = temp.y;
                    impulse.z = -this.impulse.z;
                    this.impulse.x += temp.x;
                    this.impulse.y += temp.y;
                    this.impulse.z = 0.0f;
                    this.pool.pushVec2(1);
                } else {
                    this.impulse.addLocal(impulse);
                }
            } else if (this.limitState == LimitState.AT_UPPER) {
                newImpulse = this.impulse.z + impulse.z;
                if (newImpulse > 0.0f) {
                    Vec2 rhs = this.pool.popVec2();
                    rhs.set(this.mass.ez.x, this.mass.ez.y).mulLocal(this.impulse.z).subLocal(Cdot1);
                    this.mass.solve22ToOut(rhs, temp);
                    impulse.x = temp.x;
                    impulse.y = temp.y;
                    impulse.z = -this.impulse.z;
                    this.impulse.x += temp.x;
                    this.impulse.y += temp.y;
                    this.impulse.z = 0.0f;
                    this.pool.pushVec2(1);
                } else {
                    this.impulse.addLocal(impulse);
                }
            }
            Vec2 P = this.pool.popVec2();
            P.set(impulse.x, impulse.y);
            vA.x -= mA * P.x;
            vA.y -= mA * P.y;
            wA -= iA * (Vec2.cross(this.rA, P) + impulse.z);
            vB.x += mB * P.x;
            vB.y += mB * P.y;
            wB += iB * (Vec2.cross(this.rB, P) + impulse.z);
            this.pool.pushVec2(2);
            this.pool.pushVec3(2);
        } else {
            Vec2 Cdot = this.pool.popVec2();
            Vec2 impulse = this.pool.popVec2();
            Vec2.crossToOutUnsafe(wA, this.rA, temp);
            Vec2.crossToOutUnsafe(wB, this.rB, Cdot);
            Cdot.addLocal(vB).subLocal(vA).subLocal(temp);
            this.mass.solve22ToOut(Cdot.negateLocal(), impulse);
            this.impulse.x += impulse.x;
            this.impulse.y += impulse.y;
            vA.x -= mA * impulse.x;
            vA.y -= mA * impulse.y;
            wA -= iA * Vec2.cross(this.rA, impulse);
            vB.x += mB * impulse.x;
            vB.y += mB * impulse.y;
            wB += iB * Vec2.cross(this.rB, impulse);
            this.pool.pushVec2(2);
        }
        data.velocities[this.indexA].w = wA;
        data.velocities[this.indexB].w = wB;
        this.pool.pushVec2(1);
    }

    @Override
    public boolean solvePositionConstraints(SolverData data) {
        boolean fixedRotation;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 cA = data.positions[this.indexA].c;
        float aA = data.positions[this.indexA].a;
        Vec2 cB = data.positions[this.indexB].c;
        float aB = data.positions[this.indexB].a;
        qA.set(aA);
        qB.set(aB);
        float angularError = 0.0f;
        boolean bl = fixedRotation = this.invIA + this.invIB == 0.0f;
        if (this.enableLimit && this.limitState != LimitState.INACTIVE && !fixedRotation) {
            float angle = aB - aA - this.referenceAngle;
            float limitImpulse = 0.0f;
            if (this.limitState == LimitState.EQUAL) {
                C = MathUtils.clamp(angle - this.lowerAngle, -Settings.maxAngularCorrection, Settings.maxAngularCorrection);
                limitImpulse = -this.motorMass * C;
                angularError = MathUtils.abs(C);
            } else if (this.limitState == LimitState.AT_LOWER) {
                C = angle - this.lowerAngle;
                angularError = -C;
                C = MathUtils.clamp(C + Settings.angularSlop, -Settings.maxAngularCorrection, 0.0f);
                limitImpulse = -this.motorMass * C;
            } else if (this.limitState == LimitState.AT_UPPER) {
                angularError = C = angle - this.upperAngle;
                C = MathUtils.clamp(C - Settings.angularSlop, 0.0f, Settings.maxAngularCorrection);
                limitImpulse = -this.motorMass * C;
            }
            aA -= this.invIA * limitImpulse;
            aB += this.invIB * limitImpulse;
        }
        qA.set(aA);
        qB.set(aB);
        Vec2 rA = this.pool.popVec2();
        Vec2 rB = this.pool.popVec2();
        Vec2 C = this.pool.popVec2();
        Vec2 impulse = this.pool.popVec2();
        Rot.mulToOutUnsafe(qA, C.set(this.localAnchorA).subLocal(this.localCenterA), rA);
        Rot.mulToOutUnsafe(qB, C.set(this.localAnchorB).subLocal(this.localCenterB), rB);
        C.set(cB).addLocal(rB).subLocal(cA).subLocal(rA);
        float positionError = C.length();
        float mA = this.invMassA;
        float mB = this.invMassB;
        float iA = this.invIA;
        float iB = this.invIB;
        Mat22 K = this.pool.popMat22();
        K.ex.x = mA + mB + iA * rA.y * rA.y + iB * rB.y * rB.y;
        K.ey.x = K.ex.y = -iA * rA.x * rA.y - iB * rB.x * rB.y;
        K.ey.y = mA + mB + iA * rA.x * rA.x + iB * rB.x * rB.x;
        K.solveToOut(C, impulse);
        impulse.negateLocal();
        cA.x -= mA * impulse.x;
        cA.y -= mA * impulse.y;
        cB.x += mB * impulse.x;
        cB.y += mB * impulse.y;
        this.pool.pushVec2(4);
        this.pool.pushMat22(1);
        data.positions[this.indexA].a = aA -= iA * Vec2.cross(rA, impulse);
        data.positions[this.indexB].a = aB += iB * Vec2.cross(rB, impulse);
        this.pool.pushRot(2);
        return positionError <= Settings.linearSlop && angularError <= Settings.angularSlop;
    }

    public Vec2 getLocalAnchorA() {
        return this.localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.localAnchorB;
    }

    public float getReferenceAngle() {
        return this.referenceAngle;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.bodyA.getWorldPointToOut(this.localAnchorA, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.bodyB.getWorldPointToOut(this.localAnchorB, argOut);
    }

    @Override
    public void getReactionForce(float invDt, Vec2 argOut) {
        argOut.set(this.impulse.x, this.impulse.y).mulLocal(invDt);
    }

    @Override
    public float getReactionTorque(float invDt) {
        return invDt * this.impulse.z;
    }

    public float getJointAngle() {
        Body b1 = this.bodyA;
        Body b2 = this.bodyB;
        return b2.sweep.a - b1.sweep.a - this.referenceAngle;
    }

    public float getJointSpeed() {
        Body b1 = this.bodyA;
        Body b2 = this.bodyB;
        return b2.angularVelocity - b1.angularVelocity;
    }

    public boolean isMotorEnabled() {
        return this.enableMotor;
    }

    public void enableMotor(boolean flag) {
        this.bodyA.setAwake(true);
        this.bodyB.setAwake(true);
        this.enableMotor = flag;
    }

    public float getMotorTorque(float inv_dt) {
        return this.motorImpulse * inv_dt;
    }

    public void setMotorSpeed(float speed) {
        this.bodyA.setAwake(true);
        this.bodyB.setAwake(true);
        this.motorSpeed = speed;
    }

    public void setMaxMotorTorque(float torque) {
        this.bodyA.setAwake(true);
        this.bodyB.setAwake(true);
        this.maxMotorTorque = torque;
    }

    public float getMotorSpeed() {
        return this.motorSpeed;
    }

    public float getMaxMotorTorque() {
        return this.maxMotorTorque;
    }

    public boolean isLimitEnabled() {
        return this.enableLimit;
    }

    public void enableLimit(boolean flag) {
        if (flag != this.enableLimit) {
            this.bodyA.setAwake(true);
            this.bodyB.setAwake(true);
            this.enableLimit = flag;
            this.impulse.z = 0.0f;
        }
    }

    public float getLowerLimit() {
        return this.lowerAngle;
    }

    public float getUpperLimit() {
        return this.upperAngle;
    }

    public void setLimits(float lower, float upper) {
        assert (lower <= upper);
        if (lower != this.lowerAngle || upper != this.upperAngle) {
            this.bodyA.setAwake(true);
            this.bodyB.setAwake(true);
            this.impulse.z = 0.0f;
            this.lowerAngle = lower;
            this.upperAngle = upper;
        }
    }
}

