/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics.joints;

import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Settings;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Body;
import de.pirckheimer_gymnasium.jbox2d.dynamics.SolverData;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.Joint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.WheelJointDef;
import de.pirckheimer_gymnasium.jbox2d.pooling.IWorldPool;

public class WheelJoint
extends Joint {
    private float frequencyHz;
    private float dampingRatio;
    private final Vec2 localAnchorA = new Vec2();
    private final Vec2 localAnchorB = new Vec2();
    private final Vec2 localXAxisA = new Vec2();
    private final Vec2 localYAxisA = new Vec2();
    private float impulse;
    private float motorImpulse;
    private float springImpulse;
    private float maxMotorTorque;
    private float motorSpeed;
    private boolean enableMotor;
    private int indexA;
    private int indexB;
    private final Vec2 localCenterA = new Vec2();
    private final Vec2 localCenterB = new Vec2();
    private float invMassA;
    private float invMassB;
    private float invIA;
    private float invIB;
    private final Vec2 ax = new Vec2();
    private final Vec2 ay = new Vec2();
    private float sAx;
    private float sBx;
    private float sAy;
    private float sBy;
    private float mass;
    private float motorMass;
    private float springMass;
    private float bias;
    private float gamma;
    private final Vec2 rA = new Vec2();
    private final Vec2 rB = new Vec2();
    private final Vec2 d = new Vec2();

    protected WheelJoint(IWorldPool argPool, WheelJointDef def) {
        super(argPool, def);
        this.localAnchorA.set(def.localAnchorA);
        this.localAnchorB.set(def.localAnchorB);
        this.localXAxisA.set(def.localAxisA);
        Vec2.crossToOutUnsafe(1.0f, this.localXAxisA, this.localYAxisA);
        this.motorMass = 0.0f;
        this.motorImpulse = 0.0f;
        this.maxMotorTorque = def.maxMotorTorque;
        this.motorSpeed = def.motorSpeed;
        this.enableMotor = def.enableMotor;
        this.frequencyHz = def.frequencyHz;
        this.dampingRatio = def.dampingRatio;
    }

    public Vec2 getLocalAnchorA() {
        return this.localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.localAnchorB;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.bodyA.getWorldPointToOut(this.localAnchorA, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.bodyB.getWorldPointToOut(this.localAnchorB, argOut);
    }

    @Override
    public void getReactionForce(float invDt, Vec2 argOut) {
        Vec2 temp = this.pool.popVec2();
        temp.set(this.ay).mulLocal(this.impulse);
        argOut.set(this.ax).mulLocal(this.springImpulse).addLocal(temp).mulLocal(invDt);
        this.pool.pushVec2(1);
    }

    @Override
    public float getReactionTorque(float invDt) {
        return invDt * this.motorImpulse;
    }

    public float getJointTranslation() {
        Body b1 = this.bodyA;
        Body b2 = this.bodyB;
        Vec2 p1 = this.pool.popVec2();
        Vec2 p2 = this.pool.popVec2();
        Vec2 axis = this.pool.popVec2();
        b1.getWorldPointToOut(this.localAnchorA, p1);
        b2.getWorldPointToOut(this.localAnchorA, p2);
        p2.subLocal(p1);
        b1.getWorldVectorToOut(this.localXAxisA, axis);
        float translation = Vec2.dot(p2, axis);
        this.pool.pushVec2(3);
        return translation;
    }

    public Vec2 getLocalAxisA() {
        return this.localXAxisA;
    }

    public float getJointSpeed() {
        return this.bodyA.angularVelocity - this.bodyB.angularVelocity;
    }

    public boolean isMotorEnabled() {
        return this.enableMotor;
    }

    public void enableMotor(boolean flag) {
        this.bodyA.setAwake(true);
        this.bodyB.setAwake(true);
        this.enableMotor = flag;
    }

    public void setMotorSpeed(float speed) {
        this.bodyA.setAwake(true);
        this.bodyB.setAwake(true);
        this.motorSpeed = speed;
    }

    public float getMotorSpeed() {
        return this.motorSpeed;
    }

    public float getMaxMotorTorque() {
        return this.maxMotorTorque;
    }

    public void setMaxMotorTorque(float torque) {
        this.bodyA.setAwake(true);
        this.bodyB.setAwake(true);
        this.maxMotorTorque = torque;
    }

    public float getMotorTorque(float inv_dt) {
        return this.motorImpulse * inv_dt;
    }

    public void setSpringFrequencyHz(float hz) {
        this.frequencyHz = hz;
    }

    public float getSpringFrequencyHz() {
        return this.frequencyHz;
    }

    public void setSpringDampingRatio(float ratio) {
        this.dampingRatio = ratio;
    }

    public float getSpringDampingRatio() {
        return this.dampingRatio;
    }

    @Override
    public void initVelocityConstraints(SolverData data) {
        this.indexA = this.bodyA.islandIndex;
        this.indexB = this.bodyB.islandIndex;
        this.localCenterA.set(this.bodyA.sweep.localCenter);
        this.localCenterB.set(this.bodyB.sweep.localCenter);
        this.invMassA = this.bodyA.invMass;
        this.invMassB = this.bodyB.invMass;
        this.invIA = this.bodyA.invI;
        this.invIB = this.bodyB.invI;
        float mA = this.invMassA;
        float mB = this.invMassB;
        float iA = this.invIA;
        float iB = this.invIB;
        Vec2 cA = data.positions[this.indexA].c;
        float aA = data.positions[this.indexA].a;
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        Vec2 cB = data.positions[this.indexB].c;
        float aB = data.positions[this.indexB].a;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 temp = this.pool.popVec2();
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOutUnsafe(qA, temp.set(this.localAnchorA).subLocal(this.localCenterA), this.rA);
        Rot.mulToOutUnsafe(qB, temp.set(this.localAnchorB).subLocal(this.localCenterB), this.rB);
        this.d.set(cB).addLocal(this.rB).subLocal(cA).subLocal(this.rA);
        Rot.mulToOut(qA, this.localYAxisA, this.ay);
        this.sAy = Vec2.cross(temp.set(this.d).addLocal(this.rA), this.ay);
        this.sBy = Vec2.cross(this.rB, this.ay);
        this.mass = mA + mB + iA * this.sAy * this.sAy + iB * this.sBy * this.sBy;
        if (this.mass > 0.0f) {
            this.mass = 1.0f / this.mass;
        }
        this.springMass = 0.0f;
        this.bias = 0.0f;
        this.gamma = 0.0f;
        if (this.frequencyHz > 0.0f) {
            Rot.mulToOut(qA, this.localXAxisA, this.ax);
            this.sAx = Vec2.cross(temp.set(this.d).addLocal(this.rA), this.ax);
            this.sBx = Vec2.cross(this.rB, this.ax);
            float invMass = mA + mB + iA * this.sAx * this.sAx + iB * this.sBx * this.sBx;
            if (invMass > 0.0f) {
                this.springMass = 1.0f / invMass;
                float C = Vec2.dot(this.d, this.ax);
                float omega = (float)Math.PI * 2 * this.frequencyHz;
                float d = 2.0f * this.springMass * this.dampingRatio * omega;
                float k = this.springMass * omega * omega;
                float h = data.step.dt;
                this.gamma = h * (d + h * k);
                if (this.gamma > 0.0f) {
                    this.gamma = 1.0f / this.gamma;
                }
                this.bias = C * h * k * this.gamma;
                this.springMass = invMass + this.gamma;
                if (this.springMass > 0.0f) {
                    this.springMass = 1.0f / this.springMass;
                }
            }
        } else {
            this.springImpulse = 0.0f;
        }
        if (this.enableMotor) {
            this.motorMass = iA + iB;
            if (this.motorMass > 0.0f) {
                this.motorMass = 1.0f / this.motorMass;
            }
        } else {
            this.motorMass = 0.0f;
            this.motorImpulse = 0.0f;
        }
        if (data.step.warmStarting) {
            Vec2 P = this.pool.popVec2();
            this.impulse *= data.step.dtRatio;
            this.springImpulse *= data.step.dtRatio;
            this.motorImpulse *= data.step.dtRatio;
            P.x = this.impulse * this.ay.x + this.springImpulse * this.ax.x;
            P.y = this.impulse * this.ay.y + this.springImpulse * this.ax.y;
            float LA = this.impulse * this.sAy + this.springImpulse * this.sAx + this.motorImpulse;
            float LB = this.impulse * this.sBy + this.springImpulse * this.sBx + this.motorImpulse;
            vA.x -= this.invMassA * P.x;
            vA.y -= this.invMassA * P.y;
            wA -= this.invIA * LA;
            vB.x += this.invMassB * P.x;
            vB.y += this.invMassB * P.y;
            wB += this.invIB * LB;
            this.pool.pushVec2(1);
        } else {
            this.impulse = 0.0f;
            this.springImpulse = 0.0f;
            this.motorImpulse = 0.0f;
        }
        this.pool.pushRot(2);
        this.pool.pushVec2(1);
        data.velocities[this.indexA].w = wA;
        data.velocities[this.indexB].w = wB;
    }

    @Override
    public void solveVelocityConstraints(SolverData data) {
        float mA = this.invMassA;
        float mB = this.invMassB;
        float iA = this.invIA;
        float iB = this.invIB;
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        Vec2 temp = this.pool.popVec2();
        Vec2 P = this.pool.popVec2();
        float Cdot = Vec2.dot(this.ax, temp.set(vB).subLocal(vA)) + this.sBx * wB - this.sAx * wA;
        float impulse = -this.springMass * (Cdot + this.bias + this.gamma * this.springImpulse);
        this.springImpulse += impulse;
        P.x = impulse * this.ax.x;
        P.y = impulse * this.ax.y;
        float LA = impulse * this.sAx;
        float LB = impulse * this.sBx;
        vA.x -= mA * P.x;
        vA.y -= mA * P.y;
        vB.x += mB * P.x;
        vB.y += mB * P.y;
        Cdot = (wB += iB * LB) - (wA -= iA * LA) - this.motorSpeed;
        impulse = -this.motorMass * Cdot;
        float oldImpulse = this.motorImpulse;
        float maxImpulse = data.step.dt * this.maxMotorTorque;
        this.motorImpulse = MathUtils.clamp(this.motorImpulse + impulse, -maxImpulse, maxImpulse);
        impulse = this.motorImpulse - oldImpulse;
        Cdot = Vec2.dot(this.ay, temp.set(vB).subLocal(vA)) + this.sBy * (wB += iB * impulse) - this.sAy * (wA -= iA * impulse);
        impulse = -this.mass * Cdot;
        this.impulse += impulse;
        P.x = impulse * this.ay.x;
        P.y = impulse * this.ay.y;
        LA = impulse * this.sAy;
        LB = impulse * this.sBy;
        vA.x -= mA * P.x;
        vA.y -= mA * P.y;
        vB.x += mB * P.x;
        vB.y += mB * P.y;
        this.pool.pushVec2(2);
        data.velocities[this.indexA].w = wA -= iA * LA;
        data.velocities[this.indexB].w = wB += iB * LB;
    }

    @Override
    public boolean solvePositionConstraints(SolverData data) {
        Vec2 cA = data.positions[this.indexA].c;
        float aA = data.positions[this.indexA].a;
        Vec2 cB = data.positions[this.indexB].c;
        float aB = data.positions[this.indexB].a;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 temp = this.pool.popVec2();
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOut(qA, temp.set(this.localAnchorA).subLocal(this.localCenterA), this.rA);
        Rot.mulToOut(qB, temp.set(this.localAnchorB).subLocal(this.localCenterB), this.rB);
        this.d.set(cB).subLocal(cA).addLocal(this.rB).subLocal(this.rA);
        Vec2 ay = this.pool.popVec2();
        Rot.mulToOut(qA, this.localYAxisA, ay);
        float sAy = Vec2.cross(temp.set(this.d).addLocal(this.rA), ay);
        float sBy = Vec2.cross(this.rB, ay);
        float C = Vec2.dot(this.d, ay);
        float k = this.invMassA + this.invMassB + this.invIA * this.sAy * this.sAy + this.invIB * this.sBy * this.sBy;
        float impulse = k != 0.0f ? -C / k : 0.0f;
        Vec2 P = this.pool.popVec2();
        P.x = impulse * ay.x;
        P.y = impulse * ay.y;
        float LA = impulse * sAy;
        float LB = impulse * sBy;
        cA.x -= this.invMassA * P.x;
        cA.y -= this.invMassA * P.y;
        cB.x += this.invMassB * P.x;
        cB.y += this.invMassB * P.y;
        this.pool.pushVec2(3);
        this.pool.pushRot(2);
        data.positions[this.indexA].a = aA -= this.invIA * LA;
        data.positions[this.indexB].a = aB += this.invIB * LB;
        return MathUtils.abs(C) <= Settings.linearSlop;
    }
}

