/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.animation;

import de.pirckheimer_gymnasium.engine_pi.animation.Interpolator;
import de.pirckheimer_gymnasium.engine_pi.animation.interpolation.EaseInOutDouble;
import de.pirckheimer_gymnasium.engine_pi.animation.interpolation.LinearDouble;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;

public class KeyFrame<Value extends Number>
implements Comparable<KeyFrame<Value>> {
    private Type type;
    private double timecode;
    private Value value;
    private KeyFrame<Value> next = null;

    @API
    public KeyFrame(Value value, Type type, double timecode) {
        this.value = value;
        this.type = type;
        this.setTimecode(timecode);
    }

    @API
    public void setValue(Value value) {
        this.value = value;
    }

    @API
    public Value getValue() {
        return this.value;
    }

    @API
    public void setType(Type type) {
        this.type = type;
    }

    @API
    public Type getType() {
        return this.type;
    }

    @API
    public void setTimecode(double timecode) {
        if (timecode < 0.0) {
            throw new IllegalArgumentException("Der Timecode eines Keyframes kann nicht kleiner als 0 sein. Er war: " + timecode);
        }
        this.timecode = timecode;
    }

    @API
    public double getTimecode() {
        return this.timecode;
    }

    @Internal
    void setNext(KeyFrame<Value> next) {
        this.next = next;
    }

    @Override
    public int compareTo(KeyFrame<Value> o) {
        return (int)((this.getTimecode() - o.getTimecode()) * 1000.0);
    }

    @Internal
    Interpolator<Double> generateInterpolator(Value destinationValue) {
        switch (this.type) {
            case LINEAR: {
                return new LinearDouble(((Number)this.value).doubleValue(), ((Number)destinationValue).doubleValue());
            }
            case SMOOTHED_SIN: {
                return new EaseInOutDouble(((Number)this.value).doubleValue(), ((Number)destinationValue).doubleValue());
            }
        }
        throw new RuntimeException("The impossible happened.");
    }

    @Internal
    boolean hasNext() {
        return this.next != null;
    }

    @Internal
    KeyFrame<Value> getNext() {
        return this.next;
    }

    @API
    public static enum Type {
        SMOOTHED_SIN,
        LINEAR;

    }
}

