/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.resources;

import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.resources.ResourceLoader;
import de.pirckheimer_gymnasium.engine_pi.resources.ResourcesContainer;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FontContainer
extends ResourcesContainer<Font> {
    private static final int DEFAULT_SIZE = 12;
    public static final String[] systemFonts;
    private static final Logger log;

    @API
    public static boolean isSystemFont(String fontName) {
        for (String s : systemFonts) {
            if (!s.equals(fontName)) continue;
            return true;
        }
        return false;
    }

    public static void printSystemFonts() {
        for (String s : systemFonts) {
            System.out.println(s);
        }
    }

    @API
    public static String[] getSystemFonts() {
        return (String[])systemFonts.clone();
    }

    @API
    public static Font loadByName(String fontName) {
        return new Font(fontName, 0, 12);
    }

    public Font get(String name, float size) {
        Font font = this.get(name);
        if (font == null) {
            return null;
        }
        return font.deriveFont(size);
    }

    public Font get(String name, int style) {
        Font font = this.get(name);
        if (font == null) {
            return null;
        }
        return font.deriveFont(style);
    }

    public Font get(String name, int style, float size) {
        Font font = this.get(name);
        if (font == null) {
            return null;
        }
        return font.deriveFont(style, size);
    }

    @Override
    public Font get(String name) {
        if (FontContainer.isSystemFont(name)) {
            return FontContainer.loadByName(name);
        }
        return (Font)super.get(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Font load(URL resourceName) {
        try (InputStream fontStream = ResourceLoader.get(resourceName);){
            if (fontStream == null) {
                log.log(Level.SEVERE, "font {0} could not be loaded", resourceName);
                Font font2 = null;
                return font2;
            }
            Font font = Font.createFont(0, fontStream);
            return font;
        }
        catch (FontFormatException | IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    static {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        systemFonts = ge.getAvailableFontFamilyNames();
        log = Logger.getLogger(FontContainer.class.getName());
    }
}

