/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.sound;

import de.pirckheimer_gymnasium.engine_pi.sound.Sound;
import de.pirckheimer_gymnasium.engine_pi.sound.Track;
import java.util.Iterator;
import java.util.Objects;
import javax.sound.sampled.AudioFormat;

public class IntroTrack
implements Track {
    private final Sound intro;
    private final Sound loop;

    public IntroTrack(Sound intro, Sound loop) {
        Objects.requireNonNull(intro);
        Objects.requireNonNull(loop);
        if (!intro.getFormat().matches(loop.getFormat())) {
            throw new IllegalArgumentException(String.valueOf(intro.getFormat()) + " does not match " + String.valueOf(loop.getFormat()));
        }
        this.intro = intro;
        this.loop = loop;
    }

    @Override
    public Iterator<Sound> iterator() {
        return new Iter();
    }

    @Override
    public AudioFormat getFormat() {
        return this.loop.getFormat();
    }

    public Sound getIntro() {
        return this.intro;
    }

    public Sound getLoop() {
        return this.loop;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof IntroTrack) {
            IntroTrack it = (IntroTrack)anObject;
            return this.intro == it.intro && this.loop == it.loop;
        }
        return false;
    }

    public int hashCode() {
        return this.loop.hashCode() * 31 + this.intro.hashCode();
    }

    public String toString() {
        return "looped track: " + String.valueOf(this.loop) + ", with intro: " + String.valueOf(this.intro);
    }

    private class Iter
    implements Iterator<Sound> {
        private boolean first = true;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Sound next() {
            if (this.first) {
                this.first = false;
                return IntroTrack.this.intro;
            }
            return IntroTrack.this.loop;
        }
    }
}

