/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.ActorAdder;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.actor.Triangle;

public class Logo
implements ActorAdder {
    private final Scene scene;
    private final double factor;
    private final Vector anchor;
    public Rectangle rectangleP;
    public Triangle triangleP;
    public Circle circleP;
    public Rectangle rectangleI;
    public Circle circleI;

    public Logo(Scene scene, Vector anchor, double factor) {
        this.scene = scene;
        this.factor = factor;
        this.anchor = anchor;
        this.draw();
    }

    @Override
    public Scene getScene() {
        return this.scene;
    }

    public void applyPhysicSettings(Actor actor) {
        actor.makeStatic();
        actor.setElasticity(0.97);
    }

    private Vector shift(double x, double y) {
        return Vector.v(x, y).multiply(this.factor).add(this.anchor);
    }

    private Vector shift() {
        return this.shift(0.0, 0.0);
    }

    private Rectangle drawRectangle() {
        Rectangle rectangle = this.addRectangle(this.factor, 2.0 * this.factor);
        this.applyPhysicSettings(rectangle);
        return rectangle;
    }

    private Circle drawCircle() {
        Circle circle = this.addCircle(this.factor);
        this.applyPhysicSettings(circle);
        return circle;
    }

    private void draw() {
        int iX = 2;
        this.rectangleP = this.drawRectangle();
        this.rectangleP.setPosition(this.shift());
        this.triangleP = this.addTriangle(3.0 * this.factor);
        this.applyPhysicSettings(this.triangleP);
        this.triangleP.rotateBy(-90.0).setPosition(this.shift(-0.25, 4.0));
        this.circleP = this.drawCircle();
        this.circleP.setPosition(this.shift(0.0, 2.0));
        this.rectangleI = this.drawRectangle();
        this.rectangleI.setPosition(this.shift(iX, 0.0));
        this.circleI = this.drawCircle();
        this.circleI.setPosition(this.shift(iX, 2.8));
    }
}

