/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.event;

import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.event.PeriodicTask;

public final class PeriodicTaskExecutor
implements FrameUpdateListener {
    private double countdown;
    private double interval;
    private int counter;
    private int repetitions = -1;
    private PeriodicTask task;
    private PeriodicTask finalTask;
    private FrameUpdateListenerRegistration container;
    public boolean isPaused;

    public PeriodicTaskExecutor(double interval, int repetitions, PeriodicTask task, PeriodicTask finalTask, FrameUpdateListenerRegistration container) {
        this.setInterval(interval);
        this.repetitions = repetitions;
        this.task = task;
        this.finalTask = finalTask;
        this.container = container;
    }

    public PeriodicTaskExecutor(double interval, PeriodicTask task, FrameUpdateListenerRegistration container) {
        this.setInterval(interval);
        this.task = task;
        this.container = container;
    }

    public PeriodicTaskExecutor(double interval, PeriodicTask task) {
        this(interval, task, null);
    }

    @API
    public PeriodicTaskExecutor setInterval(double interval) {
        if (interval <= 0.0) {
            throw new RuntimeException("Das Interval eines periodischen Tasks muss gr\u00f6\u00dfer als 0 sein, war " + interval);
        }
        this.interval = interval;
        this.countdown = interval;
        return this;
    }

    @API
    public double getInterval() {
        return this.interval;
    }

    public PeriodicTaskExecutor setRepetitions(int repetitions) {
        this.repetitions = repetitions;
        return this;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public PeriodicTaskExecutor setTask(PeriodicTask task) {
        this.task = task;
        return this;
    }

    public PeriodicTask getTask() {
        return this.task;
    }

    public PeriodicTaskExecutor setFinalTask(PeriodicTask finalTask) {
        this.finalTask = finalTask;
        return this;
    }

    public PeriodicTask getFinalTask() {
        return this.finalTask;
    }

    public void pause() {
        this.isPaused = true;
    }

    public void resume() {
        this.isPaused = false;
    }

    public void toggle() {
        if (this.isPaused) {
            this.resume();
        } else {
            this.pause();
        }
    }

    public void unregister() {
        if (this.container == null) {
            throw new RuntimeException("Die periodischen Aufgabe kann nicht angemeldet werden, da sie keine Referenz auf den \u00fcbergeordneten Beh\u00e4lter hat, in dem diese periodische Aufgabe angemeldet wurde.");
        }
        this.container.removeFrameUpdateListener(this);
    }

    public void unregisterSafe() {
        if (this.container != null) {
            this.container.removeFrameUpdateListener(this);
        }
    }

    @Override
    @Internal
    public void onFrameUpdate(double pastTime) {
        if (this.isPaused) {
            return;
        }
        this.countdown -= pastTime;
        while (this.countdown < 0.0) {
            if (this.repetitions > 0) {
                --this.repetitions;
            }
            this.countdown += this.interval;
            if (this.repetitions == 0 && this.finalTask != null) {
                ++this.counter;
                this.finalTask.run(this.counter);
            } else {
                ++this.counter;
                this.task.run(this.counter);
            }
            if (this.repetitions != 0) continue;
            this.unregister();
            return;
        }
    }
}

