/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.little_engine;

import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.little_engine.Character;
import de.pirckheimer_gymnasium.engine_pi.little_engine.Circle;
import de.pirckheimer_gymnasium.engine_pi.little_engine.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.little_engine.Triangle;
import de.pirckheimer_gymnasium.engine_pi.little_engine.Turtle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DrawingWindow {
    private static DrawingWindow zeichenfl\u00e4che = null;
    private JFrame fenster;
    private JComponent malfl\u00e4che;
    private JButton stop;
    private JButton start;
    private JSlider slider;
    private ArrayList<GrafikSymbol> alleSymbole = new ArrayList();
    private ArrayList<AktionsEmpfaenger> aktionsEmpf\u00e4nger = new ArrayList();
    private Timer timer;

    private DrawingWindow() {
        this.fenster = new JFrame("Zeichenfenster");
        this.fenster.setLocation(50, 50);
        this.fenster.setSize(800, 600);
        this.fenster.setDefaultCloseOperation(0);
        this.malfl\u00e4che = new JComponent(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paint(Graphics g) {
                g.setColor(new Color(230, 230, 230));
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                JComponent jComponent = DrawingWindow.this.malfl\u00e4che;
                synchronized (jComponent) {
                    for (GrafikSymbol s : DrawingWindow.this.alleSymbole) {
                        if (!s.sichtbar) continue;
                        s.Zeichnen(g);
                    }
                }
            }
        };
        this.malfl\u00e4che.setOpaque(true);
        this.malfl\u00e4che.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DrawingWindow.this.malfl\u00e4che.requestFocus();
                ArrayList<AktionsEmpfaenger> empf\u00e4nger = new ArrayList<AktionsEmpfaenger>(DrawingWindow.this.aktionsEmpf\u00e4nger);
                for (AktionsEmpfaenger em : empf\u00e4nger) {
                    em.Geklickt(e.getX(), e.getY(), e.getClickCount());
                }
            }
        });
        this.malfl\u00e4che.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                block7: {
                    ArrayList<AktionsEmpfaenger> empf\u00e4nger;
                    block6: {
                        empf\u00e4nger = new ArrayList<AktionsEmpfaenger>(DrawingWindow.this.aktionsEmpf\u00e4nger);
                        if (e.getKeyChar() != '\uffff') break block6;
                        switch (e.getKeyCode()) {
                            case 10: {
                                for (AktionsEmpfaenger em : empf\u00e4nger) {
                                    em.Taste('\n');
                                }
                                break block7;
                            }
                            default: {
                                for (AktionsEmpfaenger em : empf\u00e4nger) {
                                    em.SonderTaste(e.getKeyCode());
                                }
                                break block7;
                            }
                        }
                    }
                    for (AktionsEmpfaenger em : empf\u00e4nger) {
                        em.Taste(e.getKeyChar());
                    }
                }
            }
        });
        this.malfl\u00e4che.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentResized(ComponentEvent e) {
                JComponent jComponent = DrawingWindow.this.malfl\u00e4che;
                synchronized (jComponent) {
                    for (GrafikSymbol s : DrawingWindow.this.alleSymbole) {
                        if (!(s instanceof TurtleInternal)) continue;
                        ((TurtleInternal)s).NeueGr\u00f6\u00dfeSetzen();
                    }
                }
            }
        });
        this.fenster.add((Component)this.malfl\u00e4che, "Center");
        JPanel panel = new JPanel();
        panel.setMinimumSize(new Dimension(200, 60));
        panel.setSize(200, 60);
        panel.setVisible(true);
        panel.setLayout(new GridLayout(1, 2));
        JPanel panel2 = new JPanel();
        panel2.setMinimumSize(new Dimension(100, 60));
        panel2.setSize(100, 60);
        panel2.setVisible(true);
        panel2.setLayout(new GridLayout(1, 1));
        this.stop = new JButton();
        this.start = new JButton();
        this.start.setLocation(10, 10);
        this.start.setSize(80, 30);
        this.start.setText("Start");
        this.start.setVisible(true);
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DrawingWindow.this.TaktgeberStartenIntern();
                DrawingWindow.this.malfl\u00e4che.requestFocus();
            }
        });
        panel2.add(this.start);
        this.stop.setLocation(100, 10);
        this.stop.setSize(80, 30);
        this.stop.setText("Stop");
        this.stop.setVisible(true);
        this.stop.setEnabled(false);
        this.stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DrawingWindow.this.TaktgeberStoppenIntern();
                DrawingWindow.this.malfl\u00e4che.requestFocus();
            }
        });
        panel2.add(this.stop);
        panel.add(panel2);
        this.slider = new JSlider(0, 1000, 100);
        this.slider.setLocation(190, 10);
        this.slider.setSize(160, 40);
        this.slider.setMinimumSize(new Dimension(160, 40));
        this.slider.setPreferredSize(new Dimension(160, 40));
        this.slider.setMajorTickSpacing(100);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setValue(1000);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DrawingWindow.this.timer.setDelay(DrawingWindow.this.slider.getValue());
                DrawingWindow.this.malfl\u00e4che.requestFocus();
            }
        });
        panel.add(this.slider);
        this.fenster.add((Component)panel, "South");
        this.fenster.setVisible(true);
        this.malfl\u00e4che.requestFocus();
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArrayList<AktionsEmpfaenger> empf\u00e4nger = new ArrayList<AktionsEmpfaenger>(DrawingWindow.this.aktionsEmpf\u00e4nger);
                for (AktionsEmpfaenger e : empf\u00e4nger) {
                    e.Ausf\u00fchren();
                }
            }
        });
    }

    public static int Malfl\u00e4chenBreiteGeben() {
        if (zeichenfl\u00e4che == null) {
            zeichenfl\u00e4che = new DrawingWindow();
        }
        return DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.getWidth();
    }

    public static int Malfl\u00e4chenH\u00f6heGeben() {
        if (zeichenfl\u00e4che == null) {
            zeichenfl\u00e4che = new DrawingWindow();
        }
        return DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.getHeight();
    }

    public static void AktionsEmpf\u00e4ngerEintragen(AktionsEmpfaenger neu) {
        if (zeichenfl\u00e4che == null) {
            zeichenfl\u00e4che = new DrawingWindow();
        }
        DrawingWindow.zeichenfl\u00e4che.aktionsEmpf\u00e4nger.add(neu);
    }

    public static void AktionsEmpf\u00e4ngerEntfernen(AktionsEmpfaenger alt) {
        if (zeichenfl\u00e4che == null) {
            zeichenfl\u00e4che = new DrawingWindow();
        }
        DrawingWindow.zeichenfl\u00e4che.aktionsEmpf\u00e4nger.remove(alt);
    }

    public static GrafikSymbol SymbolErzeugen(SymbolArt art) {
        if (zeichenfl\u00e4che == null) {
            zeichenfl\u00e4che = new DrawingWindow();
        }
        return zeichenfl\u00e4che.SymbolAnlegen(art);
    }

    public static void TaktgeberStarten() {
        if (zeichenfl\u00e4che == null) {
            zeichenfl\u00e4che = new DrawingWindow();
        }
        zeichenfl\u00e4che.TaktgeberStartenIntern();
    }

    public static void TaktgeberStoppen() {
        if (zeichenfl\u00e4che == null) {
            zeichenfl\u00e4che = new DrawingWindow();
        }
        zeichenfl\u00e4che.TaktgeberStoppenIntern();
    }

    public static void TaktdauerSetzen(int dauer) {
        if (zeichenfl\u00e4che == null) {
            zeichenfl\u00e4che = new DrawingWindow();
        }
        DrawingWindow.zeichenfl\u00e4che.slider.setValue(dauer < 0 ? 0 : (dauer > 1000 ? 1000 : dauer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GrafikSymbol SymbolAnlegen(SymbolArt art) {
        GrafikSymbol neu = null;
        switch (art) {
            case rechteck: {
                neu = new RectangleInternal();
                break;
            }
            case kreis: {
                neu = new EllipseInternal();
                break;
            }
            case dreieck: {
                neu = new TriangleInternal();
                break;
            }
            case turtle: {
                neu = new TurtleInternal();
                break;
            }
            case figur: {
                neu = new CharacterInternal();
                break;
            }
            case text: {
                neu = new TextInternal();
            }
        }
        JComponent jComponent = DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che;
        synchronized (jComponent) {
            DrawingWindow.zeichenfl\u00e4che.alleSymbole.add(neu);
        }
        this.malfl\u00e4che.repaint();
        return neu;
    }

    private void TaktgeberStartenIntern() {
        this.start.setEnabled(false);
        this.stop.setEnabled(true);
        this.timer.start();
    }

    private void TaktgeberStoppenIntern() {
        this.start.setEnabled(true);
        this.stop.setEnabled(false);
        this.timer.stop();
    }

    static enum SymbolArt {
        kreis,
        dreieck,
        rechteck,
        turtle,
        figur,
        text;

    }

    abstract class GrafikSymbol {
        protected int x = 10;
        protected int y = 10;
        protected int b = 100;
        protected int h = 100;
        protected Color c = Resources.COLORS.get("red");
        protected boolean sichtbar = true;
        protected int winkel = 0;
        protected Area form;

        GrafikSymbol() {
            this.FormErzeugen();
        }

        int WinkelNormieren(int winkel) {
            while (winkel < 0) {
                winkel += 360;
            }
            return winkel % 360;
        }

        void setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            this.FormErzeugen();
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        void setSize(int breite, int h\u00f6he) {
            this.b = breite;
            this.h = h\u00f6he;
            this.FormErzeugen();
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        Color FarbeCodieren(String farbe) {
            return Resources.COLORS.getSafe(farbe);
        }

        void setColor(String farbe) {
            this.FarbeSetzen(this.FarbeCodieren(farbe));
        }

        void FarbeSetzen(Color c) {
            this.c = c;
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        void setVisibility(boolean sichtbar) {
            this.sichtbar = sichtbar;
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        void setRotation(int winkel) {
            this.winkel = this.WinkelNormieren(winkel);
            this.FormErzeugen();
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove() {
            JComponent jComponent = DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che;
            synchronized (jComponent) {
                DrawingWindow.zeichenfl\u00e4che.alleSymbole.remove(this);
                DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void raiseLayer() {
            JComponent jComponent = DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che;
            synchronized (jComponent) {
                int index = DrawingWindow.zeichenfl\u00e4che.alleSymbole.indexOf(this);
                if (index < DrawingWindow.zeichenfl\u00e4che.alleSymbole.size() - 1) {
                    DrawingWindow.zeichenfl\u00e4che.alleSymbole.set(index, DrawingWindow.zeichenfl\u00e4che.alleSymbole.get(index + 1));
                    DrawingWindow.zeichenfl\u00e4che.alleSymbole.set(index + 1, this);
                    DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void bringToFront() {
            JComponent jComponent = DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che;
            synchronized (jComponent) {
                int index = DrawingWindow.zeichenfl\u00e4che.alleSymbole.indexOf(this);
                if (index < DrawingWindow.zeichenfl\u00e4che.alleSymbole.size() - 1) {
                    DrawingWindow.zeichenfl\u00e4che.alleSymbole.remove(index);
                    DrawingWindow.zeichenfl\u00e4che.alleSymbole.add(this);
                    DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void lowerLayer() {
            JComponent jComponent = DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che;
            synchronized (jComponent) {
                int index = DrawingWindow.zeichenfl\u00e4che.alleSymbole.indexOf(this);
                if (index > 0) {
                    DrawingWindow.zeichenfl\u00e4che.alleSymbole.set(index, DrawingWindow.zeichenfl\u00e4che.alleSymbole.get(index - 1));
                    DrawingWindow.zeichenfl\u00e4che.alleSymbole.set(index - 1, this);
                    DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void bringToBack() {
            JComponent jComponent = DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che;
            synchronized (jComponent) {
                int index = DrawingWindow.zeichenfl\u00e4che.alleSymbole.indexOf(this);
                if (index > 0) {
                    DrawingWindow.zeichenfl\u00e4che.alleSymbole.remove(index);
                    DrawingWindow.zeichenfl\u00e4che.alleSymbole.add(0, this);
                    DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
                }
            }
        }

        boolean IstInnerhalb(int x, int y) {
            return this.form.contains(x, y);
        }

        boolean Schneidet(Area wen) {
            Area area = new Area(this.form);
            area.intersect(wen);
            return !area.isEmpty();
        }

        void Zeichnen(Graphics g) {
            g.setColor(this.c);
            ((Graphics2D)g).fill(this.form);
        }

        double DrehwinkelGeben(int winkel) {
            return -Math.PI * (double)(winkel > 180 ? winkel - 360 : winkel) / 180.0;
        }

        abstract void FormErzeugen();
    }

    private class RectangleInternal
    extends GrafikSymbol {
        private RectangleInternal() {
        }

        @Override
        void FormErzeugen() {
            AffineTransform a = new AffineTransform();
            a.rotate(this.DrehwinkelGeben(this.winkel), this.x + this.b / 2, this.y + this.h / 2);
            this.form = new Area(new Path2D.Double(new Rectangle2D.Double(this.x, this.y, this.b, this.h), a));
        }
    }

    private class EllipseInternal
    extends GrafikSymbol {
        private EllipseInternal() {
        }

        @Override
        void FormErzeugen() {
            AffineTransform a = new AffineTransform();
            a.rotate(this.DrehwinkelGeben(this.winkel), this.x + this.b / 2, this.y + this.h / 2);
            this.form = new Area(new Path2D.Double(new Ellipse2D.Double(this.x, this.y, this.b, this.h), a));
        }
    }

    private class TriangleInternal
    extends GrafikSymbol {
        private TriangleInternal() {
        }

        @Override
        void FormErzeugen() {
            Polygon rand = new Polygon(new int[]{this.x + this.b / 2, this.x + this.b, this.x, this.x + this.b / 2}, new int[]{this.y, this.y + this.h, this.y + this.h, this.y}, 4);
            AffineTransform a = new AffineTransform();
            a.rotate(this.DrehwinkelGeben(this.winkel), this.x + this.b / 2, this.y + this.h / 2);
            this.form = new Area(new Path2D.Double(rand, a));
        }
    }

    class TurtleInternal
    extends GrafikSymbol {
        double xD;
        double yD;
        private int homeX;
        private int homeY;
        private int homeWinkel;
        boolean stiftUnten;
        private boolean symbolSichtbar;
        private ArrayList<LinienElement> linien;
        private LinkedList<CharacterElement> standardFigur;
        private HintergrundBild hintergrund;

        TurtleInternal() {
            this.x = 100;
            this.y = 200;
            this.xD = this.x;
            this.yD = this.y;
            this.h = 40;
            this.b = 40;
            this.homeX = this.x;
            this.homeY = this.y;
            this.homeWinkel = this.winkel;
            this.c = Resources.COLORS.get("black");
            this.stiftUnten = true;
            this.symbolSichtbar = true;
            this.linien = new ArrayList();
            this.hintergrund = new HintergrundBild();
            this.standardFigur = new LinkedList();
            this.StandardfigurErzeugen();
            this.FormErzeugen();
        }

        private void StandardfigurErzeugen() {
            this.standardFigur.add(new CharacterElementEllipse(50.0, -12.5, 25.0, 25.0, Resources.COLORS.get("green")));
            this.standardFigur.add(new CharacterElementEllipse(22.5, -32.5, 12.5, 17.5, Resources.COLORS.get("green")));
            this.standardFigur.add(new CharacterElementEllipse(40.0, -32.5, 12.5, 17.5, Resources.COLORS.get("green")));
            this.standardFigur.add(new CharacterElementEllipse(22.5, 15.0, 12.5, 17.5, Resources.COLORS.get("green")));
            this.standardFigur.add(new CharacterElementEllipse(40.0, 15.0, 12.5, 17.5, Resources.COLORS.get("green")));
            this.standardFigur.add(new CharacterElementRectangle(67.5, -10.0, 5.0, 7.5, this.c));
            this.standardFigur.add(new CharacterElementRectangle(67.5, 2.5, 5.0, 7.5, this.c));
            this.standardFigur.add(new CharacterElementEllipse(0.0, -3.75, 25.0, 7.5, this.c));
            this.standardFigur.add(new CharacterElementEllipse(7.5, -23.75, 57.5, 47.5, Resources.COLORS.get("brown")));
        }

        void NeueGr\u00f6\u00dfeSetzen() {
            this.hintergrund = new HintergrundBild();
            for (LinienElement l : this.linien) {
                this.hintergrund.LinieZeichnen(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void FormErzeugen() {
            double gr\u00f6\u00dfe;
            Area area = new Area();
            AffineTransform a = new AffineTransform();
            a.rotate(this.DrehwinkelGeben(this.winkel), this.x, this.y);
            double d = gr\u00f6\u00dfe = this.h > this.b ? (double)this.b : (double)this.h;
            if (this.standardFigur != null) {
                LinkedList<CharacterElement> linkedList = this.standardFigur;
                synchronized (linkedList) {
                    for (CharacterElement e : this.standardFigur) {
                        Path2D.Double p = new Path2D.Double();
                        e.ElementZuForm(p, gr\u00f6\u00dfe, this.x, this.y);
                        area.add(new Area(new Path2D.Double(p, a)));
                    }
                }
            }
            this.form = area;
        }

        @Override
        void setPosition(int x, int y) {
            super.setPosition(x, y);
            this.xD = x;
            this.yD = y;
        }

        void moveToStartPoint() {
            this.x = this.homeX;
            this.y = this.homeY;
            this.xD = this.x;
            this.yD = this.y;
            this.winkel = this.homeWinkel;
            this.FormErzeugen();
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void move(double l\u00e4nge) {
            double neuX = this.xD + Math.cos(this.DrehwinkelGeben(this.winkel)) * l\u00e4nge;
            double neuY = this.yD + Math.sin(this.DrehwinkelGeben(this.winkel)) * l\u00e4nge;
            if (this.stiftUnten) {
                TurtleInternal turtleInternal = this;
                synchronized (turtleInternal) {
                    LinienElement l = new LinienElement(this.xD, this.yD, neuX, neuY, this.c);
                    this.linien.add(l);
                    this.hintergrund.LinieZeichnen(l);
                }
            }
            this.xD = neuX;
            this.yD = neuY;
            this.x = (int)Math.round(this.xD);
            this.y = (int)Math.round(this.yD);
            this.FormErzeugen();
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        void rotate(int grad) {
            this.winkel = this.WinkelNormieren(this.winkel + grad);
            this.FormErzeugen();
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        void reset() {
            this.linien.clear();
            this.hintergrund = new HintergrundBild();
            this.moveToStartPoint();
        }

        void liftPen() {
            this.stiftUnten = false;
        }

        void lowerPen() {
            this.stiftUnten = true;
        }

        void setSymbolVisibility(boolean sichtbar) {
            this.symbolSichtbar = sichtbar;
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        boolean isTouching() {
            for (GrafikSymbol g : DrawingWindow.zeichenfl\u00e4che.alleSymbole) {
                if (g == this || !g.IstInnerhalb(this.x, this.y) || !g.sichtbar || g instanceof TurtleInternal && !((TurtleInternal)g).symbolSichtbar) continue;
                return true;
            }
            return false;
        }

        boolean isTouching(String farbe) {
            Color c2 = this.FarbeCodieren(farbe);
            boolean ok = false;
            for (GrafikSymbol g : DrawingWindow.zeichenfl\u00e4che.alleSymbole) {
                GrafikSymbol t;
                if (g == this || !g.IstInnerhalb(this.x, this.y) || !g.sichtbar) continue;
                if (g instanceof TurtleInternal) {
                    t = (TurtleInternal)g;
                    if (!t.symbolSichtbar) continue;
                    for (CharacterElement e : t.standardFigur) {
                        Path2D.Double p = new Path2D.Double();
                        double gr\u00f6\u00dfe = t.h > t.b ? (double)t.b : (double)t.h;
                        e.ElementZuForm(p, gr\u00f6\u00dfe, t.x, t.y);
                        AffineTransform a = new AffineTransform();
                        a.rotate(this.DrehwinkelGeben(t.winkel), t.x, t.y);
                        if (!(p = new Path2D.Double(p, a)).contains(this.x, this.y)) continue;
                        ok = c2.equals(e.c);
                    }
                    continue;
                }
                if (g instanceof CharacterInternal) {
                    t = (CharacterInternal)g;
                    LinkedList<CharacterElement> figur = ((CharacterInternal)t).eigeneFigur == null || ((CharacterInternal)t).eigeneFigur.size() == 0 ? ((CharacterInternal)t).standardFigur : ((CharacterInternal)t).eigeneFigur;
                    for (CharacterElement e : figur) {
                        Path2D.Double p = new Path2D.Double();
                        double gr\u00f6\u00dfe = ((CharacterInternal)t).h > ((CharacterInternal)t).b ? (double)((CharacterInternal)t).b : (double)((CharacterInternal)t).h;
                        e.ElementZuForm(p, gr\u00f6\u00dfe, ((CharacterInternal)t).x, ((CharacterInternal)t).y);
                        AffineTransform a = new AffineTransform();
                        a.rotate(this.DrehwinkelGeben(((CharacterInternal)t).winkel), ((CharacterInternal)t).x, ((CharacterInternal)t).y);
                        if (!(p = new Path2D.Double(p, a)).contains(this.x, this.y)) continue;
                        ok = c2.equals(e.c);
                    }
                    continue;
                }
                ok = ok || c2.equals(g.c);
            }
            return ok;
        }

        boolean isTouching(Object object) {
            GrafikSymbol s = null;
            if (object instanceof Rectangle) {
                s = ((Rectangle)object).symbol;
            } else if (object instanceof Triangle) {
                s = ((Triangle)object).symbol;
            } else if (object instanceof Circle) {
                s = ((Circle)object).symbol;
            } else if (object instanceof Turtle) {
                s = ((Turtle)object).symbol;
            } else if (object instanceof Character) {
                s = ((Character)object).symbol;
            }
            return s != null && s != this && s.IstInnerhalb(this.x, this.y) && s.sichtbar && (!(s instanceof TurtleInternal) || ((TurtleInternal)s).symbolSichtbar);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void Zeichnen(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            TurtleInternal turtleInternal = this;
            synchronized (turtleInternal) {
                this.hintergrund.BildZeichnen(g2);
            }
            if (this.symbolSichtbar) {
                g.setColor(Resources.COLORS.get("black"));
                double gr\u00f6\u00dfe = this.h > this.b ? (double)this.b : (double)this.h;
                AffineTransform alt = g2.getTransform();
                g2.rotate(this.DrehwinkelGeben(this.winkel), this.x, this.y);
                if (this.standardFigur != null) {
                    LinkedList<CharacterElement> linkedList = this.standardFigur;
                    synchronized (linkedList) {
                        for (CharacterElement e : this.standardFigur) {
                            e.ElementZeichnen(g2, gr\u00f6\u00dfe, this.x, this.y);
                        }
                    }
                }
                g2.setTransform(alt);
            }
        }

        private class HintergrundBild {
            private BufferedImage bild = new BufferedImage(DrawingWindow.Malfl\u00e4chenBreiteGeben(), DrawingWindow.Malfl\u00e4chenBreiteGeben(), 2);
            private Graphics2D g = this.bild.createGraphics();

            HintergrundBild() {
                this.g.setColor(new Color(0, 0, 0, 0));
                this.g.fillRect(0, 0, this.bild.getWidth(), this.bild.getHeight());
            }

            void LinieZeichnen(LinienElement linie) {
                linie.Zeichnen(this.g);
            }

            void BildZeichnen(Graphics2D wohin) {
                wohin.drawImage(this.bild, null, 0, 0);
            }
        }

        private class LinienElement {
            private double xStart;
            private double yStart;
            private double xEnde;
            private double yEnde;
            private Color c;

            LinienElement(double xStart, double yStart, double xEnde, double yEnde, Color c) {
                this.xStart = xStart;
                this.yStart = yStart;
                this.xEnde = xEnde;
                this.yEnde = yEnde;
                this.c = c;
            }

            void Zeichnen(Graphics2D g) {
                g.setColor(this.c);
                g.draw(new Line2D.Double(this.xStart, this.yStart, this.xEnde, this.yEnde));
            }
        }
    }

    class CharacterInternal
    extends GrafikSymbol {
        double xD;
        double yD;
        private int homeX;
        private int homeY;
        private int homeWinkel;
        private LinkedList<CharacterElement> eigeneFigur;
        private LinkedList<CharacterElement> standardFigur;

        CharacterInternal() {
            this.x = 100;
            this.y = 200;
            this.xD = this.x;
            this.yD = this.y;
            this.h = 40;
            this.b = 40;
            this.homeX = this.x;
            this.homeY = this.y;
            this.homeWinkel = this.winkel;
            this.c = Resources.COLORS.get("black");
            this.eigeneFigur = new LinkedList();
            this.standardFigur = new LinkedList();
            this.StandardfigurErzeugen();
            this.FormErzeugen();
        }

        private void StandardfigurErzeugen() {
            int[] x = new int[]{-50, 50, -50};
            int[] y = new int[]{-50, 0, 50};
            this.standardFigur.add(new CharacterElementPolygon(x, y, Resources.COLORS.get("yellow")));
            this.standardFigur.add(new CharacterElementEllipse(-10.0, -10.0, 20.0, 20.0, Resources.COLORS.get("blue")));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void FormErzeugen() {
            double gr\u00f6\u00dfe;
            Area area = new Area();
            AffineTransform a = new AffineTransform();
            a.rotate(this.DrehwinkelGeben(this.winkel), this.x, this.y);
            double d = gr\u00f6\u00dfe = this.h > this.b ? (double)this.b : (double)this.h;
            if (this.standardFigur != null) {
                LinkedList<CharacterElement> figur;
                LinkedList<CharacterElement> linkedList = figur = this.eigeneFigur == null || this.eigeneFigur.size() == 0 ? this.standardFigur : this.eigeneFigur;
                synchronized (linkedList) {
                    for (CharacterElement e : figur) {
                        Path2D.Double p = new Path2D.Double();
                        e.ElementZuForm(p, gr\u00f6\u00dfe, this.x, this.y);
                        area.add(new Area(new Path2D.Double(p, a)));
                    }
                }
            }
            this.form = area;
        }

        @Override
        void setPosition(int x, int y) {
            super.setPosition(x, y);
            this.xD = x;
            this.yD = y;
        }

        void ZumStartpunktGehen() {
            this.x = this.homeX;
            this.y = this.homeY;
            this.xD = this.x;
            this.yD = this.y;
            this.winkel = this.homeWinkel;
            this.FormErzeugen();
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        void Gehen(double l\u00e4nge) {
            double neuX = this.xD + Math.cos(this.DrehwinkelGeben(this.winkel)) * l\u00e4nge;
            double neuY = this.yD + Math.sin(this.DrehwinkelGeben(this.winkel)) * l\u00e4nge;
            this.xD = neuX;
            this.yD = neuY;
            this.x = (int)Math.round(this.xD);
            this.y = (int)Math.round(this.yD);
            this.FormErzeugen();
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        void Drehen(int grad) {
            this.winkel = this.WinkelNormieren(this.winkel + grad);
            this.FormErzeugen();
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        boolean Ber\u00fchrt() {
            for (GrafikSymbol g : DrawingWindow.zeichenfl\u00e4che.alleSymbole) {
                if (g == this || !g.Schneidet(this.form) || !g.sichtbar || g instanceof TurtleInternal && !((TurtleInternal)g).symbolSichtbar) continue;
                return true;
            }
            return false;
        }

        boolean Ber\u00fchrt(String farbe) {
            Color c2 = this.FarbeCodieren(farbe);
            boolean ok = false;
            for (GrafikSymbol g : DrawingWindow.zeichenfl\u00e4che.alleSymbole) {
                GrafikSymbol t;
                if (g == this || !g.Schneidet(this.form) || !g.sichtbar) continue;
                if (g instanceof TurtleInternal) {
                    t = (TurtleInternal)g;
                    if (!t.symbolSichtbar) continue;
                    Area[] areas = new Area[t.standardFigur.size()];
                    Color[] colors = new Color[t.standardFigur.size()];
                    AffineTransform a = new AffineTransform();
                    a.rotate(this.DrehwinkelGeben(t.winkel), t.x, t.y);
                    int pos = 0;
                    for (CharacterElement e : t.standardFigur) {
                        Path2D.Double p = new Path2D.Double();
                        double gr\u00f6\u00dfe = t.h > t.b ? (double)t.b : (double)t.h;
                        e.ElementZuForm(p, gr\u00f6\u00dfe, t.x, t.y);
                        p = new Path2D.Double(p, a);
                        areas[pos] = new Area(p);
                        colors[pos] = e.c;
                        for (int i = pos - 1; i >= 0; --i) {
                            areas[i].subtract(areas[pos]);
                        }
                        ++pos;
                    }
                    for (int i = 0; i < areas.length; ++i) {
                        if (!this.Schneidet(areas[i]) || !c2.equals(colors[i])) continue;
                        ok = true;
                    }
                    continue;
                }
                if (g instanceof CharacterInternal) {
                    t = (CharacterInternal)g;
                    LinkedList<CharacterElement> figur = ((CharacterInternal)t).eigeneFigur == null || ((CharacterInternal)t).eigeneFigur.size() == 0 ? ((CharacterInternal)t).standardFigur : ((CharacterInternal)t).eigeneFigur;
                    Area[] areas = new Area[figur.size()];
                    Color[] colors = new Color[figur.size()];
                    AffineTransform a = new AffineTransform();
                    a.rotate(this.DrehwinkelGeben(((CharacterInternal)t).winkel), ((CharacterInternal)t).x, ((CharacterInternal)t).y);
                    int pos = 0;
                    for (CharacterElement e : figur) {
                        Path2D.Double p = new Path2D.Double();
                        double gr\u00f6\u00dfe = ((CharacterInternal)t).h > ((CharacterInternal)t).b ? (double)((CharacterInternal)t).b : (double)((CharacterInternal)t).h;
                        e.ElementZuForm(p, gr\u00f6\u00dfe, ((CharacterInternal)t).x, ((CharacterInternal)t).y);
                        p = new Path2D.Double(p, a);
                        areas[pos] = new Area(p);
                        colors[pos] = e.c;
                        for (int i = pos - 1; i >= 0; --i) {
                            areas[i].subtract(areas[pos]);
                        }
                        ++pos;
                    }
                    for (int i = 0; i < areas.length; ++i) {
                        if (!this.Schneidet(areas[i]) || !c2.equals(colors[i])) continue;
                        ok = true;
                    }
                    continue;
                }
                ok = ok || c2.equals(g.c);
            }
            return ok;
        }

        boolean Ber\u00fchrt(Object object) {
            GrafikSymbol s = null;
            if (object instanceof Rectangle) {
                s = ((Rectangle)object).symbol;
            } else if (object instanceof Triangle) {
                s = ((Triangle)object).symbol;
            } else if (object instanceof Circle) {
                s = ((Circle)object).symbol;
            } else if (object instanceof Turtle) {
                s = ((Turtle)object).symbol;
            } else if (object instanceof Character) {
                s = ((Character)object).symbol;
            }
            return s != null && s != this && s.Schneidet(this.form) && s.sichtbar && (!(s instanceof TurtleInternal) || ((TurtleInternal)s).symbolSichtbar);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void FigurteilFestlegenRechteck(int x, int y, int breite, int h\u00f6he, String farbe) {
            LinkedList<CharacterElement> linkedList = this.eigeneFigur;
            synchronized (linkedList) {
                this.eigeneFigur.add(new CharacterElementRectangle(x, y, breite, h\u00f6he, this.FarbeCodieren(farbe)));
            }
            this.FormErzeugen();
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void FigurteilFestlegenEllipse(int x, int y, int breite, int h\u00f6he, String farbe) {
            LinkedList<CharacterElement> linkedList = this.eigeneFigur;
            synchronized (linkedList) {
                this.eigeneFigur.add(new CharacterElementEllipse(x, y, breite, h\u00f6he, this.FarbeCodieren(farbe)));
            }
            this.FormErzeugen();
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void FigurteilFestlegenDreieck(int x1, int y1, int x2, int y2, int x3, int y3, String farbe) {
            LinkedList<CharacterElement> linkedList = this.eigeneFigur;
            synchronized (linkedList) {
                int[] x = new int[]{x1, x2, x3};
                int[] y = new int[]{y1, y2, y3};
                this.eigeneFigur.add(new CharacterElementPolygon(x, y, this.FarbeCodieren(farbe)));
            }
            this.FormErzeugen();
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        void EigeneFigurL\u00f6schen() {
            this.eigeneFigur.clear();
            this.FormErzeugen();
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void Zeichnen(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g.setColor(Resources.COLORS.get("black"));
            Stroke stAlt = g2.getStroke();
            g2.setStroke(new BasicStroke(3.0f));
            g2.draw(this.form);
            g2.setStroke(stAlt);
            double gr\u00f6\u00dfe = this.h > this.b ? (double)this.b : (double)this.h;
            AffineTransform alt = g2.getTransform();
            g2.rotate(this.DrehwinkelGeben(this.winkel), this.x, this.y);
            if (this.standardFigur != null) {
                LinkedList<CharacterElement> figur;
                LinkedList<CharacterElement> linkedList = figur = this.eigeneFigur == null || this.eigeneFigur.size() == 0 ? this.standardFigur : this.eigeneFigur;
                synchronized (linkedList) {
                    for (CharacterElement e : figur) {
                        e.ElementZeichnen(g2, gr\u00f6\u00dfe, this.x, this.y);
                    }
                }
            }
            g2.setTransform(alt);
        }
    }

    class TextInternal
    extends GrafikSymbol {
        private String text = "Text";
        float size = 12.0f;

        TextInternal() {
            this.c = Resources.COLORS.get("black");
        }

        @Override
        void FormErzeugen() {
            this.form = new Area();
        }

        @Override
        boolean IstInnerhalb(int x, int y) {
            return false;
        }

        void TextSetzen(String t) {
            this.text = t;
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        void TextGr\u00f6\u00dfeSetzen(int gr\u00f6\u00dfe) {
            this.size = gr\u00f6\u00dfe;
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        void TextVergr\u00f6\u00dfern() {
            this.size = this.size <= 10.0f ? (this.size += 1.0f) : (this.size <= 40.0f ? (this.size += 2.0f) : (this.size += 4.0f));
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        void TextVerkleinern() {
            this.size = this.size <= 10.0f ? (this.size -= 1.0f) : (this.size <= 40.0f ? (this.size -= 2.0f) : (this.size -= 4.0f));
            if (this.size < 1.0f) {
                this.size = 1.0f;
            }
            DrawingWindow.zeichenfl\u00e4che.malfl\u00e4che.repaint();
        }

        @Override
        void Zeichnen(Graphics g) {
            g.setColor(this.c);
            Font f = g.getFont();
            Font f2 = f.deriveFont(this.size);
            g.setFont(f2);
            if (this.winkel == 0) {
                g.drawString(this.text, this.x, this.y);
            } else {
                Graphics2D g2 = (Graphics2D)g;
                AffineTransform alt = g2.getTransform();
                Rectangle2D bounds = f2.getStringBounds(this.text, g2.getFontRenderContext());
                g2.rotate(this.DrehwinkelGeben(this.winkel), (double)this.x + bounds.getWidth() / 2.0, (double)this.y - bounds.getHeight() / 2.0);
                g.drawString(this.text, this.x, this.y);
                g2.setTransform(alt);
            }
            g.setFont(f);
        }
    }

    private class CharacterElementPolygon
    extends CharacterElement {
        private Polygon poly;

        CharacterElementPolygon(int[] x, int[] y, Color c) {
            int anz = x.length <= y.length ? x.length : y.length;
            this.poly = new Polygon(x, y, anz);
            Rectangle2D bounds = this.poly.getBounds2D();
            this.xe = bounds.getX();
            this.ye = bounds.getY();
            this.breite = bounds.getWidth();
            this.h\u00f6he = bounds.getHeight();
            this.c = c;
        }

        @Override
        void ElementZeichnen(Graphics2D g, double gr\u00f6\u00dfe, int x, int y) {
            g.setColor(this.c);
            AffineTransform at = new AffineTransform(gr\u00f6\u00dfe / 100.0, 0.0, 0.0, gr\u00f6\u00dfe / 100.0, (double)x, (double)y);
            g.fill(new Path2D.Double(this.poly, at));
        }

        @Override
        void ElementZuForm(Path2D.Double p, double gr\u00f6\u00dfe, int x, int y) {
            AffineTransform at = new AffineTransform(gr\u00f6\u00dfe / 100.0, 0.0, 0.0, gr\u00f6\u00dfe / 100.0, (double)x, (double)y);
            Path2D.Double p2 = new Path2D.Double(this.poly, at);
            p2.closePath();
            p2.setWindingRule(0);
            p.append(p2, false);
        }
    }

    private class CharacterElementEllipse
    extends CharacterElement {
        CharacterElementEllipse(double x, double y, double breite, double h\u00f6he, Color c) {
            this.xe = x;
            this.ye = y;
            this.breite = breite;
            this.h\u00f6he = h\u00f6he;
            this.c = c;
        }

        @Override
        void ElementZeichnen(Graphics2D g, double gr\u00f6\u00dfe, int x, int y) {
            g.setColor(this.c);
            g.fill(new Ellipse2D.Double((double)x + gr\u00f6\u00dfe * this.xe / 100.0, (double)y + gr\u00f6\u00dfe * this.ye / 100.0, gr\u00f6\u00dfe * this.breite / 100.0, gr\u00f6\u00dfe * this.h\u00f6he / 100.0));
        }

        @Override
        void ElementZuForm(Path2D.Double p, double gr\u00f6\u00dfe, int x, int y) {
            p.append(new Ellipse2D.Double((double)x + gr\u00f6\u00dfe * this.xe / 100.0, (double)y + gr\u00f6\u00dfe * this.ye / 100.0, gr\u00f6\u00dfe * this.breite / 100.0, gr\u00f6\u00dfe * this.h\u00f6he / 100.0), false);
        }
    }

    private class CharacterElementRectangle
    extends CharacterElement {
        CharacterElementRectangle(double x, double y, double breite, double h\u00f6he, Color c) {
            this.xe = x;
            this.ye = y;
            this.breite = breite;
            this.h\u00f6he = h\u00f6he;
            this.c = c;
        }

        @Override
        void ElementZeichnen(Graphics2D g, double gr\u00f6\u00dfe, int x, int y) {
            g.setColor(this.c);
            g.fill(new Rectangle2D.Double((double)x + gr\u00f6\u00dfe * this.xe / 100.0, (double)y + gr\u00f6\u00dfe * this.ye / 100.0, gr\u00f6\u00dfe * this.breite / 100.0, gr\u00f6\u00dfe * this.h\u00f6he / 100.0));
        }

        @Override
        void ElementZuForm(Path2D.Double p, double gr\u00f6\u00dfe, int x, int y) {
            p.append(new Rectangle2D.Double((double)x + gr\u00f6\u00dfe * this.xe / 100.0, (double)y + gr\u00f6\u00dfe * this.ye / 100.0, gr\u00f6\u00dfe * this.breite / 100.0, gr\u00f6\u00dfe * this.h\u00f6he / 100.0), false);
        }
    }

    private abstract class CharacterElement {
        double xe;
        double ye;
        double breite;
        double h\u00f6he;
        Color c;

        private CharacterElement() {
        }

        abstract void ElementZeichnen(Graphics2D var1, double var2, int var4, int var5);

        abstract void ElementZuForm(Path2D.Double var1, double var2, int var4, int var5);
    }

    static interface AktionsEmpfaenger {
        public void Ausf\u00fchren();

        public void Taste(char var1);

        public void SonderTaste(int var1);

        public void Geklickt(int var1, int var2, int var3);
    }
}

