/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.little_engine;

import de.pirckheimer_gymnasium.engine_pi.little_engine.DrawingWindow;

public class Rectangle {
    public int x = 10;
    public int y = 10;
    public int width = 100;
    public int height = 100;
    public String color = "rot";
    public boolean visible = true;
    public int rotation = 0;
    DrawingWindow.GrafikSymbol symbol = DrawingWindow.SymbolErzeugen(DrawingWindow.SymbolArt.rechteck);

    public Rectangle() {
        this.symbol.setPosition(this.x, this.y);
        this.symbol.setSize(this.width, this.height);
        this.symbol.setColor(this.color);
        this.symbol.setVisibility(this.visible);
        this.symbol.setRotation(this.rotation);
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.symbol.setPosition(x, y);
    }

    public void move(int deltaX, int deltaY) {
        this.x += deltaX;
        this.y += deltaY;
        this.symbol.setPosition(this.x, this.y);
    }

    public void rotate(int angle) {
        this.rotation += angle;
        this.symbol.setRotation(this.rotation);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.symbol.setSize(width, height);
    }

    public void setColor(String color) {
        this.color = color;
        this.symbol.setColor(color);
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
        this.symbol.setRotation(rotation);
    }

    public void setVisibility(boolean sichtbar) {
        this.visible = sichtbar;
        this.symbol.setVisibility(sichtbar);
    }

    public void remove() {
        this.symbol.remove();
    }

    public void raiseLayer() {
        this.symbol.raiseLayer();
    }

    public void bringToFront() {
        this.symbol.bringToFront();
    }

    public void lowerLayer() {
        this.symbol.lowerLayer();
    }

    public void bringToBack() {
        this.symbol.bringToBack();
    }
}

