/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics;

import de.pirckheimer_gymnasium.jbox2d.collision.AABB;
import de.pirckheimer_gymnasium.jbox2d.collision.RayCastInput;
import de.pirckheimer_gymnasium.jbox2d.collision.RayCastOutput;
import de.pirckheimer_gymnasium.jbox2d.collision.broadphase.BroadPhase;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.MassData;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.Shape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.ShapeType;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Transform;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Body;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Filter;
import de.pirckheimer_gymnasium.jbox2d.dynamics.FixtureDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.FixtureProxy;
import de.pirckheimer_gymnasium.jbox2d.dynamics.World;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.Contact;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.ContactEdge;

public class Fixture {
    public float density;
    public Fixture next = null;
    public Body body = null;
    public Shape shape = null;
    public float friction;
    public float restitution;
    public FixtureProxy[] proxies = null;
    public int proxyCount = 0;
    public final Filter filter;
    public boolean isSensor;
    public Object userData = null;
    private final AABB pool1 = new AABB();
    private final AABB pool2 = new AABB();
    private final Vec2 displacement = new Vec2();

    public Fixture() {
        this.filter = new Filter();
    }

    public ShapeType getType() {
        return this.shape.getType();
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean isSensor() {
        return this.isSensor;
    }

    public void setSensor(boolean sensor) {
        if (sensor != this.isSensor) {
            this.body.setAwake(true);
            this.isSensor = sensor;
        }
    }

    public void setFilterData(Filter filter) {
        this.filter.set(filter);
        this.refilter();
    }

    public Filter getFilterData() {
        return this.filter;
    }

    public void refilter() {
        if (this.body == null) {
            return;
        }
        ContactEdge edge = this.body.getContactList();
        while (edge != null) {
            Contact contact = edge.contact;
            Fixture fixtureA = contact.getFixtureA();
            Fixture fixtureB = contact.getFixtureB();
            if (fixtureA == this || fixtureB == this) {
                contact.flagForFiltering();
            }
            edge = edge.next;
        }
        World world = this.body.getWorld();
        if (world == null) {
            return;
        }
        BroadPhase broadPhase = world.contactManager.broadPhase;
        for (int i = 0; i < this.proxyCount; ++i) {
            broadPhase.touchProxy(this.proxies[i].proxyId);
        }
    }

    public Body getBody() {
        return this.body;
    }

    public Fixture getNext() {
        return this.next;
    }

    public void setDensity(float density) {
        assert (density >= 0.0f);
        this.density = density;
    }

    public float getDensity() {
        return this.density;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object data) {
        this.userData = data;
    }

    public boolean testPoint(Vec2 p) {
        return this.shape.testPoint(this.body.xf, p);
    }

    public boolean raycast(RayCastOutput output, RayCastInput input, int childIndex) {
        return this.shape.raycast(output, input, this.body.xf, childIndex);
    }

    public void getMassData(MassData massData) {
        this.shape.computeMass(massData, this.density);
    }

    public float getFriction() {
        return this.friction;
    }

    public void setFriction(float friction) {
        this.friction = friction;
    }

    public float getRestitution() {
        return this.restitution;
    }

    public void setRestitution(float restitution) {
        this.restitution = restitution;
    }

    public AABB getAABB(int childIndex) {
        assert (childIndex >= 0 && childIndex < this.proxyCount);
        return this.proxies[childIndex].aabb;
    }

    public float computeDistance(Vec2 p, int childIndex, Vec2 normalOut) {
        return this.shape.computeDistanceToOut(this.body.getTransform(), p, childIndex, normalOut);
    }

    public void create(Body body, FixtureDef def) {
        this.userData = def.userData;
        this.friction = def.friction;
        this.restitution = def.restitution;
        this.body = body;
        this.next = null;
        this.filter.set(def.filter);
        this.isSensor = def.isSensor;
        this.shape = def.shape.clone();
        int childCount = this.shape.getChildCount();
        if (this.proxies == null) {
            this.proxies = new FixtureProxy[childCount];
            for (int i = 0; i < childCount; ++i) {
                this.proxies[i] = new FixtureProxy();
                this.proxies[i].fixture = null;
                this.proxies[i].proxyId = -1;
            }
        }
        if (this.proxies.length < childCount) {
            FixtureProxy[] old = this.proxies;
            int newLen = MathUtils.max(old.length * 2, childCount);
            this.proxies = new FixtureProxy[newLen];
            System.arraycopy(old, 0, this.proxies, 0, old.length);
            for (int i = 0; i < newLen; ++i) {
                if (i >= old.length) {
                    this.proxies[i] = new FixtureProxy();
                }
                this.proxies[i].fixture = null;
                this.proxies[i].proxyId = -1;
            }
        }
        this.proxyCount = 0;
        this.density = def.density;
    }

    public void destroy() {
        assert (this.proxyCount == 0);
        this.shape = null;
        this.proxies = null;
        this.next = null;
    }

    public void createProxies(BroadPhase broadPhase, Transform xf) {
        assert (this.proxyCount == 0);
        this.proxyCount = this.shape.getChildCount();
        int i = 0;
        while (i < this.proxyCount) {
            FixtureProxy proxy = this.proxies[i];
            this.shape.computeAABB(proxy.aabb, xf, i);
            proxy.proxyId = broadPhase.createProxy(proxy.aabb, proxy);
            proxy.fixture = this;
            proxy.childIndex = i++;
        }
    }

    public void destroyProxies(BroadPhase broadPhase) {
        for (int i = 0; i < this.proxyCount; ++i) {
            FixtureProxy proxy = this.proxies[i];
            broadPhase.destroyProxy(proxy.proxyId);
            proxy.proxyId = -1;
        }
        this.proxyCount = 0;
    }

    protected void synchronize(BroadPhase broadPhase, Transform transform1, Transform transform2) {
        if (this.proxyCount == 0) {
            return;
        }
        for (int i = 0; i < this.proxyCount; ++i) {
            FixtureProxy proxy = this.proxies[i];
            AABB aabb1 = this.pool1;
            AABB aab = this.pool2;
            this.shape.computeAABB(aabb1, transform1, proxy.childIndex);
            this.shape.computeAABB(aab, transform2, proxy.childIndex);
            proxy.aabb.lowerBound.x = aabb1.lowerBound.x < aab.lowerBound.x ? aabb1.lowerBound.x : aab.lowerBound.x;
            proxy.aabb.lowerBound.y = aabb1.lowerBound.y < aab.lowerBound.y ? aabb1.lowerBound.y : aab.lowerBound.y;
            proxy.aabb.upperBound.x = aabb1.upperBound.x > aab.upperBound.x ? aabb1.upperBound.x : aab.upperBound.x;
            proxy.aabb.upperBound.y = aabb1.upperBound.y > aab.upperBound.y ? aabb1.upperBound.y : aab.upperBound.y;
            this.displacement.x = transform2.p.x - transform1.p.x;
            this.displacement.y = transform2.p.y - transform1.p.y;
            broadPhase.moveProxy(proxy.proxyId, proxy.aabb, this.displacement);
        }
    }
}

