/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics;

import de.pirckheimer_gymnasium.jbox2d.callbacks.ContactFilter;
import de.pirckheimer_gymnasium.jbox2d.callbacks.ContactListener;
import de.pirckheimer_gymnasium.jbox2d.callbacks.DebugDraw;
import de.pirckheimer_gymnasium.jbox2d.callbacks.DestructionListener;
import de.pirckheimer_gymnasium.jbox2d.callbacks.ParticleDestructionListener;
import de.pirckheimer_gymnasium.jbox2d.callbacks.ParticleQueryCallback;
import de.pirckheimer_gymnasium.jbox2d.callbacks.ParticleRaycastCallback;
import de.pirckheimer_gymnasium.jbox2d.callbacks.QueryCallback;
import de.pirckheimer_gymnasium.jbox2d.callbacks.RayCastCallback;
import de.pirckheimer_gymnasium.jbox2d.collision.AABB;
import de.pirckheimer_gymnasium.jbox2d.collision.RayCastInput;
import de.pirckheimer_gymnasium.jbox2d.collision.TimeOfImpact;
import de.pirckheimer_gymnasium.jbox2d.collision.broadphase.BroadPhase;
import de.pirckheimer_gymnasium.jbox2d.collision.broadphase.BroadPhaseStrategy;
import de.pirckheimer_gymnasium.jbox2d.collision.broadphase.DefaultBroadPhaseBuffer;
import de.pirckheimer_gymnasium.jbox2d.collision.broadphase.DynamicTree;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.ChainShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.CircleShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.EdgeShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.PolygonShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.Shape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.ShapeType;
import de.pirckheimer_gymnasium.jbox2d.common.Color3f;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Settings;
import de.pirckheimer_gymnasium.jbox2d.common.Sweep;
import de.pirckheimer_gymnasium.jbox2d.common.Timer;
import de.pirckheimer_gymnasium.jbox2d.common.Transform;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Body;
import de.pirckheimer_gymnasium.jbox2d.dynamics.BodyDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.BodyType;
import de.pirckheimer_gymnasium.jbox2d.dynamics.ContactManager;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Fixture;
import de.pirckheimer_gymnasium.jbox2d.dynamics.FixtureProxy;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Island;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Profile;
import de.pirckheimer_gymnasium.jbox2d.dynamics.TimeStep;
import de.pirckheimer_gymnasium.jbox2d.dynamics.WorldQueryWrapper;
import de.pirckheimer_gymnasium.jbox2d.dynamics.WorldRayCastWrapper;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.Contact;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.ContactEdge;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.ContactRegister;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.Joint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.JointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.JointEdge;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.PulleyJoint;
import de.pirckheimer_gymnasium.jbox2d.particle.ParticleBodyContact;
import de.pirckheimer_gymnasium.jbox2d.particle.ParticleColor;
import de.pirckheimer_gymnasium.jbox2d.particle.ParticleContact;
import de.pirckheimer_gymnasium.jbox2d.particle.ParticleDef;
import de.pirckheimer_gymnasium.jbox2d.particle.ParticleGroup;
import de.pirckheimer_gymnasium.jbox2d.particle.ParticleGroupDef;
import de.pirckheimer_gymnasium.jbox2d.particle.ParticleSystem;
import de.pirckheimer_gymnasium.jbox2d.pooling.IDynamicStack;
import de.pirckheimer_gymnasium.jbox2d.pooling.IWorldPool;
import de.pirckheimer_gymnasium.jbox2d.pooling.arrays.Vec2Array;
import de.pirckheimer_gymnasium.jbox2d.pooling.normal.DefaultWorldPool;

public class World {
    public static final int WORLD_POOL_SIZE = 100;
    public static final int WORLD_POOL_CONTAINER_SIZE = 10;
    public static final int NEW_FIXTURE = 1;
    public static final int LOCKED = 2;
    public static final int CLEAR_FORCES = 4;
    public int activeContacts = 0;
    public int contactPoolCount = 0;
    protected int flags;
    protected ContactManager contactManager;
    private Body bodyList;
    private Joint jointList;
    private int bodyCount;
    private int jointCount;
    private final Vec2 gravity = new Vec2();
    private boolean allowSleep;
    private DestructionListener destructionListener;
    private ParticleDestructionListener particleDestructionListener;
    private DebugDraw debugDraw;
    private final IWorldPool pool;
    private float invDt0;
    private boolean warmStarting;
    private boolean continuousPhysics;
    private boolean subStepping;
    private boolean stepComplete;
    private final Profile profile;
    private final ParticleSystem particleSystem;
    private final ContactRegister[][] contactStacks = new ContactRegister[ShapeType.values().length][ShapeType.values().length];
    private final TimeStep step = new TimeStep();
    private final Timer stepTimer = new Timer();
    private final Timer tempTimer = new Timer();
    private final Color3f color = new Color3f();
    private final Transform xf = new Transform();
    private final Vec2 cA = new Vec2();
    private final Vec2 cB = new Vec2();
    private final Vec2Array avs = new Vec2Array();
    private final WorldQueryWrapper wqwrapper = new WorldQueryWrapper();
    private final WorldRayCastWrapper wrcwrapper = new WorldRayCastWrapper();
    private final RayCastInput input = new RayCastInput();
    private final Island island = new Island();
    private Body[] stack = new Body[10];
    private final Timer broadphaseTimer = new Timer();
    private final Island toiIsland = new Island();
    private final TimeOfImpact.TOIInput toiInput = new TimeOfImpact.TOIInput();
    private final TimeOfImpact.TOIOutput toiOutput = new TimeOfImpact.TOIOutput();
    private final TimeStep subStep = new TimeStep();
    private final Body[] tempBodies = new Body[2];
    private final Sweep backup1 = new Sweep();
    private final Sweep backup2 = new Sweep();
    private static final Integer LIQUID_INT = 1234598372;
    private float averageLinearVel = -1.0f;
    private final Vec2 liquidOffset = new Vec2();
    private final Vec2 circCenterMoved = new Vec2();
    private final Color3f liquidColor = new Color3f(0.4f, 0.4f, 1.0f);
    private final Vec2 center = new Vec2();
    private final Vec2 axis = new Vec2();
    private final Vec2 v1 = new Vec2();
    private final Vec2 v2 = new Vec2();
    private final Vec2Array tlvertices = new Vec2Array();

    public World(Vec2 gravity) {
        this(gravity, new DefaultWorldPool(100, 10));
    }

    public World(Vec2 gravity, IWorldPool pool) {
        this(gravity, pool, new DynamicTree());
    }

    public World(Vec2 gravity, IWorldPool pool, BroadPhaseStrategy strategy) {
        this(gravity, pool, new DefaultBroadPhaseBuffer(strategy));
    }

    public World(Vec2 gravity, IWorldPool pool, BroadPhase broadPhase) {
        this.pool = pool;
        this.destructionListener = null;
        this.debugDraw = null;
        this.bodyList = null;
        this.jointList = null;
        this.bodyCount = 0;
        this.jointCount = 0;
        this.warmStarting = true;
        this.continuousPhysics = true;
        this.subStepping = false;
        this.stepComplete = true;
        this.allowSleep = true;
        this.gravity.set(gravity);
        this.flags = 4;
        this.invDt0 = 0.0f;
        this.contactManager = new ContactManager(this, broadPhase);
        this.profile = new Profile();
        this.particleSystem = new ParticleSystem(this);
        this.initializeRegisters();
    }

    public void setAllowSleep(boolean flag) {
        if (flag == this.allowSleep) {
            return;
        }
        this.allowSleep = flag;
        if (!this.allowSleep) {
            Body b = this.bodyList;
            while (b != null) {
                b.setAwake(true);
                b = b.next;
            }
        }
    }

    public void setSubStepping(boolean subStepping) {
        this.subStepping = subStepping;
    }

    public boolean isSubStepping() {
        return this.subStepping;
    }

    public boolean isAllowSleep() {
        return this.allowSleep;
    }

    private void addType(IDynamicStack<Contact> creator, ShapeType type1, ShapeType type2) {
        ContactRegister register = new ContactRegister();
        register.creator = creator;
        register.primary = true;
        this.contactStacks[type1.ordinal()][type2.ordinal()] = register;
        if (type1 != type2) {
            ContactRegister register2 = new ContactRegister();
            register2.creator = creator;
            register2.primary = false;
            this.contactStacks[type2.ordinal()][type1.ordinal()] = register2;
        }
    }

    private void initializeRegisters() {
        this.addType(this.pool.getCircleContactStack(), ShapeType.CIRCLE, ShapeType.CIRCLE);
        this.addType(this.pool.getPolyCircleContactStack(), ShapeType.POLYGON, ShapeType.CIRCLE);
        this.addType(this.pool.getPolyContactStack(), ShapeType.POLYGON, ShapeType.POLYGON);
        this.addType(this.pool.getEdgeCircleContactStack(), ShapeType.EDGE, ShapeType.CIRCLE);
        this.addType(this.pool.getEdgePolyContactStack(), ShapeType.EDGE, ShapeType.POLYGON);
        this.addType(this.pool.getChainCircleContactStack(), ShapeType.CHAIN, ShapeType.CIRCLE);
        this.addType(this.pool.getChainPolyContactStack(), ShapeType.CHAIN, ShapeType.POLYGON);
    }

    public DestructionListener getDestructionListener() {
        return this.destructionListener;
    }

    public ParticleDestructionListener getParticleDestructionListener() {
        return this.particleDestructionListener;
    }

    public void setParticleDestructionListener(ParticleDestructionListener listener) {
        this.particleDestructionListener = listener;
    }

    public Contact popContact(Fixture fixtureA, int indexA, Fixture fixtureB, int indexB) {
        ShapeType type1 = fixtureA.getType();
        ShapeType type2 = fixtureB.getType();
        ContactRegister reg = this.contactStacks[type1.ordinal()][type2.ordinal()];
        if (reg != null) {
            Contact c = reg.creator.pop();
            if (reg.primary) {
                c.init(fixtureA, indexA, fixtureB, indexB);
            } else {
                c.init(fixtureB, indexB, fixtureA, indexA);
            }
            return c;
        }
        return null;
    }

    public void pushContact(Contact contact) {
        Fixture fixtureA = contact.getFixtureA();
        Fixture fixtureB = contact.getFixtureB();
        if (contact.manifold.pointCount > 0 && !fixtureA.isSensor() && !fixtureB.isSensor()) {
            fixtureA.getBody().setAwake(true);
            fixtureB.getBody().setAwake(true);
        }
        ShapeType type1 = fixtureA.getType();
        ShapeType type2 = fixtureB.getType();
        IDynamicStack<Contact> creator = this.contactStacks[type1.ordinal()][type2.ordinal()].creator;
        creator.push(contact);
    }

    public IWorldPool getPool() {
        return this.pool;
    }

    public void setDestructionListener(DestructionListener listener) {
        this.destructionListener = listener;
    }

    public void setContactFilter(ContactFilter filter) {
        this.contactManager.contactFilter = filter;
    }

    public void setContactListener(ContactListener listener) {
        this.contactManager.contactListener = listener;
    }

    public void setDebugDraw(DebugDraw debugDraw) {
        this.debugDraw = debugDraw;
    }

    public Body createBody(BodyDef def) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return null;
        }
        Body b = new Body(def, this);
        b.prev = null;
        b.next = this.bodyList;
        if (this.bodyList != null) {
            this.bodyList.prev = b;
        }
        this.bodyList = b;
        ++this.bodyCount;
        return b;
    }

    public void destroyBody(Body body) {
        assert (this.bodyCount > 0);
        assert (!this.isLocked());
        if (this.isLocked()) {
            return;
        }
        JointEdge je = body.jointList;
        while (je != null) {
            JointEdge je0 = je;
            je = je.next;
            if (this.destructionListener != null) {
                this.destructionListener.sayGoodbye(je0.joint);
            }
            this.destroyJoint(je0.joint);
            body.jointList = je;
        }
        body.jointList = null;
        ContactEdge ce = body.contactList;
        while (ce != null) {
            ContactEdge ce0 = ce;
            ce = ce.next;
            this.contactManager.destroy(ce0.contact);
        }
        body.contactList = null;
        Fixture f = body.fixtureList;
        while (f != null) {
            Fixture f0 = f;
            f = f.next;
            if (this.destructionListener != null) {
                this.destructionListener.sayGoodbye(f0);
            }
            f0.destroyProxies(this.contactManager.broadPhase);
            f0.destroy();
            body.fixtureList = f;
            --body.fixtureCount;
        }
        body.fixtureList = null;
        body.fixtureCount = 0;
        if (body.prev != null) {
            body.prev.next = body.next;
        }
        if (body.next != null) {
            body.next.prev = body.prev;
        }
        if (body == this.bodyList) {
            this.bodyList = body.next;
        }
        --this.bodyCount;
    }

    public Joint createJoint(JointDef def) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return null;
        }
        Joint j = Joint.create(this, def);
        j.prev = null;
        j.next = this.jointList;
        if (this.jointList != null) {
            this.jointList.prev = j;
        }
        this.jointList = j;
        ++this.jointCount;
        j.edgeA.joint = j;
        j.edgeA.other = j.getBodyB();
        j.edgeA.prev = null;
        j.edgeA.next = j.getBodyA().jointList;
        if (j.getBodyA().jointList != null) {
            j.getBodyA().jointList.prev = j.edgeA;
        }
        j.getBodyA().jointList = j.edgeA;
        j.edgeB.joint = j;
        j.edgeB.other = j.getBodyA();
        j.edgeB.prev = null;
        j.edgeB.next = j.getBodyB().jointList;
        if (j.getBodyB().jointList != null) {
            j.getBodyB().jointList.prev = j.edgeB;
        }
        j.getBodyB().jointList = j.edgeB;
        Body bodyA = def.bodyA;
        Body bodyB = def.bodyB;
        if (!def.collideConnected) {
            ContactEdge edge = bodyB.getContactList();
            while (edge != null) {
                if (edge.other == bodyA) {
                    edge.contact.flagForFiltering();
                }
                edge = edge.next;
            }
        }
        return j;
    }

    public void destroyJoint(Joint j) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return;
        }
        boolean collideConnected = j.getCollideConnected();
        if (j.prev != null) {
            j.prev.next = j.next;
        }
        if (j.next != null) {
            j.next.prev = j.prev;
        }
        if (j == this.jointList) {
            this.jointList = j.next;
        }
        Body bodyA = j.getBodyA();
        Body bodyB = j.getBodyB();
        bodyA.setAwake(true);
        bodyB.setAwake(true);
        if (j.edgeA.prev != null) {
            j.edgeA.prev.next = j.edgeA.next;
        }
        if (j.edgeA.next != null) {
            j.edgeA.next.prev = j.edgeA.prev;
        }
        if (j.edgeA == bodyA.jointList) {
            bodyA.jointList = j.edgeA.next;
        }
        j.edgeA.prev = null;
        j.edgeA.next = null;
        if (j.edgeB.prev != null) {
            j.edgeB.prev.next = j.edgeB.next;
        }
        if (j.edgeB.next != null) {
            j.edgeB.next.prev = j.edgeB.prev;
        }
        if (j.edgeB == bodyB.jointList) {
            bodyB.jointList = j.edgeB.next;
        }
        j.edgeB.prev = null;
        j.edgeB.next = null;
        Joint.destroy(j);
        assert (this.jointCount > 0);
        --this.jointCount;
        if (!collideConnected) {
            ContactEdge edge = bodyB.getContactList();
            while (edge != null) {
                if (edge.other == bodyA) {
                    edge.contact.flagForFiltering();
                }
                edge = edge.next;
            }
        }
    }

    public void step(float dt, int velocityIterations, int positionIterations) {
        this.stepTimer.reset();
        this.tempTimer.reset();
        if ((this.flags & 1) == 1) {
            this.contactManager.findNewContacts();
            this.flags &= 0xFFFFFFFE;
        }
        this.flags |= 2;
        this.step.dt = dt;
        this.step.velocityIterations = velocityIterations;
        this.step.positionIterations = positionIterations;
        this.step.inv_dt = dt > 0.0f ? 1.0f / dt : 0.0f;
        this.step.dtRatio = this.invDt0 * dt;
        this.step.warmStarting = this.warmStarting;
        this.profile.stepInit.record(this.tempTimer.getMilliseconds());
        this.tempTimer.reset();
        this.contactManager.collide();
        this.profile.collide.record(this.tempTimer.getMilliseconds());
        if (this.stepComplete && this.step.dt > 0.0f) {
            this.tempTimer.reset();
            this.particleSystem.solve(this.step);
            this.profile.solveParticleSystem.record(this.tempTimer.getMilliseconds());
            this.tempTimer.reset();
            this.solve(this.step);
            this.profile.solve.record(this.tempTimer.getMilliseconds());
        }
        if (this.continuousPhysics && this.step.dt > 0.0f) {
            this.tempTimer.reset();
            this.solveTOI(this.step);
            this.profile.solveTOI.record(this.tempTimer.getMilliseconds());
        }
        if (this.step.dt > 0.0f) {
            this.invDt0 = this.step.inv_dt;
        }
        if ((this.flags & 4) == 4) {
            this.clearForces();
        }
        this.flags &= 0xFFFFFFFD;
        this.profile.step.record(this.stepTimer.getMilliseconds());
    }

    public void clearForces() {
        for (Body body = this.bodyList; body != null; body = body.getNext()) {
            body.force.setZero();
            body.torque = 0.0f;
        }
    }

    public void drawDebugData() {
        Fixture f;
        Body b;
        boolean wireframe;
        if (this.debugDraw == null) {
            return;
        }
        int flags = this.debugDraw.getFlags();
        boolean bl = wireframe = (flags & 0x80) != 0;
        if ((flags & 2) != 0) {
            for (b = this.bodyList; b != null; b = b.getNext()) {
                this.xf.set(b.getTransform());
                for (f = b.getFixtureList(); f != null; f = f.getNext()) {
                    if (!b.isActive()) {
                        this.color.set(0.5f, 0.5f, 0.3f);
                        this.drawShape(f, this.xf, this.color, wireframe);
                        continue;
                    }
                    if (b.getType() == BodyType.STATIC) {
                        this.color.set(0.5f, 0.9f, 0.3f);
                        this.drawShape(f, this.xf, this.color, wireframe);
                        continue;
                    }
                    if (b.getType() == BodyType.KINEMATIC) {
                        this.color.set(0.5f, 0.5f, 0.9f);
                        this.drawShape(f, this.xf, this.color, wireframe);
                        continue;
                    }
                    if (!b.isAwake()) {
                        this.color.set(0.5f, 0.5f, 0.5f);
                        this.drawShape(f, this.xf, this.color, wireframe);
                        continue;
                    }
                    this.color.set(0.9f, 0.7f, 0.7f);
                    this.drawShape(f, this.xf, this.color, wireframe);
                }
            }
            this.drawParticleSystem(this.particleSystem);
        }
        if ((flags & 4) != 0) {
            for (Joint j = this.jointList; j != null; j = j.getNext()) {
                this.drawJoint(j);
            }
        }
        if ((flags & 0x10) != 0) {
            this.color.set(0.3f, 0.9f, 0.9f);
            for (Contact c = this.contactManager.contactList; c != null; c = c.getNext()) {
                Fixture fixtureA = c.getFixtureA();
                Fixture fixtureB = c.getFixtureB();
                fixtureA.getAABB(c.getChildIndexA()).getCenterToOut(this.cA);
                fixtureB.getAABB(c.getChildIndexB()).getCenterToOut(this.cB);
                this.debugDraw.drawSegment(this.cA, this.cB, this.color);
            }
        }
        if ((flags & 8) != 0) {
            this.color.set(0.9f, 0.3f, 0.9f);
            for (b = this.bodyList; b != null; b = b.getNext()) {
                if (!b.isActive()) continue;
                for (f = b.getFixtureList(); f != null; f = f.getNext()) {
                    for (int i = 0; i < f.proxyCount; ++i) {
                        FixtureProxy proxy = f.proxies[i];
                        AABB aabb = this.contactManager.broadPhase.getFatAABB(proxy.proxyId);
                        if (aabb == null) continue;
                        Vec2[] vs = this.avs.get(4);
                        vs[0].set(aabb.lowerBound.x, aabb.lowerBound.y);
                        vs[1].set(aabb.upperBound.x, aabb.lowerBound.y);
                        vs[2].set(aabb.upperBound.x, aabb.upperBound.y);
                        vs[3].set(aabb.lowerBound.x, aabb.upperBound.y);
                        this.debugDraw.drawPolygon(vs, 4, this.color);
                    }
                }
            }
        }
        if ((flags & 0x20) != 0) {
            for (b = this.bodyList; b != null; b = b.getNext()) {
                this.xf.set(b.getTransform());
                this.xf.p.set(b.getWorldCenter());
                this.debugDraw.drawTransform(this.xf);
            }
        }
        if ((flags & 0x40) != 0) {
            this.contactManager.broadPhase.drawTree(this.debugDraw);
        }
        this.debugDraw.flush();
    }

    public void queryAABB(QueryCallback callback, AABB aabb) {
        this.wqwrapper.broadPhase = this.contactManager.broadPhase;
        this.wqwrapper.callback = callback;
        this.contactManager.broadPhase.query(this.wqwrapper, aabb);
    }

    public void queryAABB(QueryCallback callback, ParticleQueryCallback particleCallback, AABB aabb) {
        this.wqwrapper.broadPhase = this.contactManager.broadPhase;
        this.wqwrapper.callback = callback;
        this.contactManager.broadPhase.query(this.wqwrapper, aabb);
        this.particleSystem.queryAABB(particleCallback, aabb);
    }

    public void queryAABB(ParticleQueryCallback particleCallback, AABB aabb) {
        this.particleSystem.queryAABB(particleCallback, aabb);
    }

    public void raycast(RayCastCallback callback, Vec2 point1, Vec2 point2) {
        this.wrcwrapper.broadPhase = this.contactManager.broadPhase;
        this.wrcwrapper.callback = callback;
        this.input.maxFraction = 1.0f;
        this.input.p1.set(point1);
        this.input.p2.set(point2);
        this.contactManager.broadPhase.raycast(this.wrcwrapper, this.input);
    }

    public void raycast(RayCastCallback callback, ParticleRaycastCallback particleCallback, Vec2 point1, Vec2 point2) {
        this.wrcwrapper.broadPhase = this.contactManager.broadPhase;
        this.wrcwrapper.callback = callback;
        this.input.maxFraction = 1.0f;
        this.input.p1.set(point1);
        this.input.p2.set(point2);
        this.contactManager.broadPhase.raycast(this.wrcwrapper, this.input);
        this.particleSystem.raycast(particleCallback, point1, point2);
    }

    public void raycast(ParticleRaycastCallback particleCallback, Vec2 point1, Vec2 point2) {
        this.particleSystem.raycast(particleCallback, point1, point2);
    }

    public Body getBodyList() {
        return this.bodyList;
    }

    public Joint getJointList() {
        return this.jointList;
    }

    public Contact getContactList() {
        return this.contactManager.contactList;
    }

    public boolean isSleepingAllowed() {
        return this.allowSleep;
    }

    public void setSleepingAllowed(boolean sleepingAllowed) {
        this.allowSleep = sleepingAllowed;
    }

    public void setWarmStarting(boolean flag) {
        this.warmStarting = flag;
    }

    public boolean isWarmStarting() {
        return this.warmStarting;
    }

    public void setContinuousPhysics(boolean flag) {
        this.continuousPhysics = flag;
    }

    public boolean isContinuousPhysics() {
        return this.continuousPhysics;
    }

    public int getProxyCount() {
        return this.contactManager.broadPhase.getProxyCount();
    }

    public int getBodyCount() {
        return this.bodyCount;
    }

    public int getJointCount() {
        return this.jointCount;
    }

    public int getContactCount() {
        return this.contactManager.contactCount;
    }

    public int getTreeHeight() {
        return this.contactManager.broadPhase.getTreeHeight();
    }

    public int getTreeBalance() {
        return this.contactManager.broadPhase.getTreeBalance();
    }

    public float getTreeQuality() {
        return this.contactManager.broadPhase.getTreeQuality();
    }

    public void setGravity(Vec2 gravity) {
        this.gravity.set(gravity);
    }

    public Vec2 getGravity() {
        return this.gravity;
    }

    public boolean isLocked() {
        return (this.flags & 2) == 2;
    }

    public void setAutoClearForces(boolean flag) {
        this.flags = flag ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public boolean getAutoClearForces() {
        return (this.flags & 4) == 4;
    }

    public ContactManager getContactManager() {
        return this.contactManager;
    }

    public Profile getProfile() {
        return this.profile;
    }

    private void solve(TimeStep step) {
        this.profile.solveInit.startAccum();
        this.profile.solveVelocity.startAccum();
        this.profile.solvePosition.startAccum();
        Body b = this.bodyList;
        while (b != null) {
            b.xf0.set(b.xf);
            b = b.next;
        }
        this.island.init(this.bodyCount, this.contactManager.contactCount, this.jointCount, this.contactManager.contactListener);
        b = this.bodyList;
        while (b != null) {
            b.flags &= 0xFFFFFFFE;
            b = b.next;
        }
        Contact c = this.contactManager.contactList;
        while (c != null) {
            c.flags &= 0xFFFFFFFE;
            c = c.next;
        }
        Joint j = this.jointList;
        while (j != null) {
            j.islandFlag = false;
            j = j.next;
        }
        int stackSize = this.bodyCount;
        if (this.stack.length < stackSize) {
            this.stack = new Body[stackSize];
        }
        Body seed = this.bodyList;
        while (seed != null) {
            if ((seed.flags & 1) != 1 && seed.isAwake() && seed.isActive() && seed.getType() != BodyType.STATIC) {
                this.island.clear();
                int stackCount = 0;
                this.stack[stackCount++] = seed;
                seed.flags |= 1;
                while (stackCount > 0) {
                    Body b2 = this.stack[--stackCount];
                    assert (b2.isActive());
                    this.island.add(b2);
                    b2.setAwake(true);
                    if (b2.getType() == BodyType.STATIC) continue;
                    ContactEdge ce = b2.contactList;
                    while (ce != null) {
                        Contact contact = ce.contact;
                        if ((contact.flags & 1) != 1 && contact.isEnabled() && contact.isTouching()) {
                            boolean sensorA = contact.fixtureA.isSensor;
                            boolean sensorB = contact.fixtureB.isSensor;
                            if (!sensorA && !sensorB) {
                                this.island.add(contact);
                                contact.flags |= 1;
                                Body other = ce.other;
                                if ((other.flags & 1) != 1) {
                                    assert (stackCount < stackSize);
                                    this.stack[stackCount++] = other;
                                    other.flags |= 1;
                                }
                            }
                        }
                        ce = ce.next;
                    }
                    JointEdge je = b2.jointList;
                    while (je != null) {
                        Body other;
                        if (!je.joint.islandFlag && (other = je.other).isActive()) {
                            this.island.add(je.joint);
                            je.joint.islandFlag = true;
                            if ((other.flags & 1) != 1) {
                                assert (stackCount < stackSize);
                                this.stack[stackCount++] = other;
                                other.flags |= 1;
                            }
                        }
                        je = je.next;
                    }
                }
                this.island.solve(this.profile, step, this.gravity, this.allowSleep);
                for (int i = 0; i < this.island.bodyCount; ++i) {
                    Body b3 = this.island.bodies[i];
                    if (b3.getType() != BodyType.STATIC) continue;
                    b3.flags &= 0xFFFFFFFE;
                }
            }
            seed = seed.next;
        }
        this.profile.solveInit.endAccum();
        this.profile.solveVelocity.endAccum();
        this.profile.solvePosition.endAccum();
        this.broadphaseTimer.reset();
        for (Body b4 = this.bodyList; b4 != null; b4 = b4.getNext()) {
            if ((b4.flags & 1) == 0 || b4.getType() == BodyType.STATIC) continue;
            b4.synchronizeFixtures();
        }
        this.contactManager.findNewContacts();
        this.profile.broadphase.record(this.broadphaseTimer.getMilliseconds());
    }

    private void solveTOI(TimeStep step) {
        block31: {
            Island island = this.toiIsland;
            island.init(2 * Settings.maxTOIContacts, Settings.maxTOIContacts, 0, this.contactManager.contactListener);
            if (this.stepComplete) {
                Body b = this.bodyList;
                while (b != null) {
                    b.flags &= 0xFFFFFFFE;
                    b.sweep.alpha0 = 0.0f;
                    b = b.next;
                }
                Contact c = this.contactManager.contactList;
                while (c != null) {
                    c.flags &= 0xFFFFFFDE;
                    c.toiCount = 0.0f;
                    c.toi = 1.0f;
                    c = c.next;
                }
            }
            while (true) {
                ContactEdge ce;
                Body body;
                int i;
                Contact minContact = null;
                float minAlpha = 1.0f;
                Contact c = this.contactManager.contactList;
                while (c != null) {
                    block32: {
                        float alpha;
                        block34: {
                            boolean collideB;
                            boolean activeB;
                            block33: {
                                if (!c.isEnabled() || c.toiCount > (float)Settings.maxSubSteps) break block32;
                                alpha = 1.0f;
                                if ((c.flags & 0x20) == 0) break block33;
                                alpha = c.toi;
                                break block34;
                            }
                            Fixture fA = c.getFixtureA();
                            Fixture fB = c.getFixtureB();
                            if (fA.isSensor() || fB.isSensor()) break block32;
                            Body bA = fA.getBody();
                            Body bB = fB.getBody();
                            BodyType typeA = bA.type;
                            BodyType typeB = bB.type;
                            assert (typeA == BodyType.DYNAMIC || typeB == BodyType.DYNAMIC);
                            boolean activeA = bA.isAwake() && typeA != BodyType.STATIC;
                            boolean bl = activeB = bB.isAwake() && typeB != BodyType.STATIC;
                            if (!activeA && !activeB) break block32;
                            boolean collideA = bA.isBullet() || typeA != BodyType.DYNAMIC;
                            boolean bl2 = collideB = bB.isBullet() || typeB != BodyType.DYNAMIC;
                            if (!collideA && !collideB) break block32;
                            float alpha0 = bA.sweep.alpha0;
                            if (bA.sweep.alpha0 < bB.sweep.alpha0) {
                                alpha0 = bB.sweep.alpha0;
                                bA.sweep.advance(alpha0);
                            } else if (bB.sweep.alpha0 < bA.sweep.alpha0) {
                                alpha0 = bA.sweep.alpha0;
                                bB.sweep.advance(alpha0);
                            }
                            assert (alpha0 < 1.0f);
                            int indexA = c.getChildIndexA();
                            int indexB = c.getChildIndexB();
                            TimeOfImpact.TOIInput input = this.toiInput;
                            input.proxyA.set(fA.getShape(), indexA);
                            input.proxyB.set(fB.getShape(), indexB);
                            input.sweepA.set(bA.sweep);
                            input.sweepB.set(bB.sweep);
                            input.tMax = 1.0f;
                            this.pool.getTimeOfImpact().timeOfImpact(this.toiOutput, input);
                            float beta = this.toiOutput.t;
                            alpha = this.toiOutput.state == TimeOfImpact.TOIOutputState.TOUCHING ? MathUtils.min(alpha0 + (1.0f - alpha0) * beta, 1.0f) : 1.0f;
                            c.toi = alpha;
                            c.flags |= 0x20;
                        }
                        if (alpha < minAlpha) {
                            minContact = c;
                            minAlpha = alpha;
                        }
                    }
                    c = c.next;
                }
                if (minContact == null || 0.9999988f < minAlpha) {
                    this.stepComplete = true;
                    break block31;
                }
                Fixture fA = minContact.getFixtureA();
                Fixture fB = minContact.getFixtureB();
                Body bA = fA.getBody();
                Body bB = fB.getBody();
                this.backup1.set(bA.sweep);
                this.backup2.set(bB.sweep);
                bA.advance(minAlpha);
                bB.advance(minAlpha);
                minContact.update(this.contactManager.contactListener);
                minContact.flags &= 0xFFFFFFDF;
                minContact.toiCount += 1.0f;
                if (!minContact.isEnabled() || !minContact.isTouching()) {
                    minContact.setEnabled(false);
                    bA.sweep.set(this.backup1);
                    bB.sweep.set(this.backup2);
                    bA.synchronizeTransform();
                    bB.synchronizeTransform();
                    continue;
                }
                bA.setAwake(true);
                bB.setAwake(true);
                island.clear();
                island.add(bA);
                island.add(bB);
                island.add(minContact);
                bA.flags |= 1;
                bB.flags |= 1;
                minContact.flags |= 1;
                this.tempBodies[0] = bA;
                this.tempBodies[1] = bB;
                for (i = 0; i < 2; ++i) {
                    body = this.tempBodies[i];
                    if (body.type != BodyType.DYNAMIC) continue;
                    ce = body.contactList;
                    while (ce != null && island.bodyCount != island.bodyCapacity && island.contactCount != island.contactCapacity) {
                        Contact contact = ce.contact;
                        if ((contact.flags & 1) == 0) {
                            Body other = ce.other;
                            if (other.type != BodyType.DYNAMIC || body.isBullet() || other.isBullet()) {
                                boolean sensorA = contact.fixtureA.isSensor;
                                boolean sensorB = contact.fixtureB.isSensor;
                                if (!sensorA && !sensorB) {
                                    this.backup1.set(other.sweep);
                                    if ((other.flags & 1) == 0) {
                                        other.advance(minAlpha);
                                    }
                                    contact.update(this.contactManager.contactListener);
                                    if (!contact.isEnabled()) {
                                        other.sweep.set(this.backup1);
                                        other.synchronizeTransform();
                                    } else if (!contact.isTouching()) {
                                        other.sweep.set(this.backup1);
                                        other.synchronizeTransform();
                                    } else {
                                        contact.flags |= 1;
                                        island.add(contact);
                                        if ((other.flags & 1) == 0) {
                                            other.flags |= 1;
                                            if (other.type != BodyType.STATIC) {
                                                other.setAwake(true);
                                            }
                                            island.add(other);
                                        }
                                    }
                                }
                            }
                        }
                        ce = ce.next;
                    }
                }
                this.subStep.dt = (1.0f - minAlpha) * step.dt;
                this.subStep.inv_dt = 1.0f / this.subStep.dt;
                this.subStep.dtRatio = 1.0f;
                this.subStep.positionIterations = 20;
                this.subStep.velocityIterations = step.velocityIterations;
                this.subStep.warmStarting = false;
                island.solveTOI(this.subStep, bA.islandIndex, bB.islandIndex);
                for (i = 0; i < island.bodyCount; ++i) {
                    body = island.bodies[i];
                    body.flags &= 0xFFFFFFFE;
                    if (body.type != BodyType.DYNAMIC) continue;
                    body.synchronizeFixtures();
                    ce = body.contactList;
                    while (ce != null) {
                        ce.contact.flags &= 0xFFFFFFDE;
                        ce = ce.next;
                    }
                }
                this.contactManager.findNewContacts();
                if (this.subStepping) break;
            }
            this.stepComplete = false;
        }
    }

    private void drawJoint(Joint joint) {
        Body bodyA = joint.getBodyA();
        Body bodyB = joint.getBodyB();
        Transform xf1 = bodyA.getTransform();
        Transform xf2 = bodyB.getTransform();
        Vec2 x1 = xf1.p;
        Vec2 x2 = xf2.p;
        Vec2 p1 = this.pool.popVec2();
        Vec2 p2 = this.pool.popVec2();
        joint.getAnchorA(p1);
        joint.getAnchorB(p2);
        this.color.set(0.5f, 0.8f, 0.8f);
        switch (joint.getType()) {
            case DISTANCE: {
                this.debugDraw.drawSegment(p1, p2, this.color);
                break;
            }
            case PULLEY: {
                PulleyJoint pulley = (PulleyJoint)joint;
                Vec2 s1 = pulley.getGroundAnchorA();
                Vec2 s2 = pulley.getGroundAnchorB();
                this.debugDraw.drawSegment(s1, p1, this.color);
                this.debugDraw.drawSegment(s2, p2, this.color);
                this.debugDraw.drawSegment(s1, s2, this.color);
                break;
            }
            case CONSTANT_VOLUME: 
            case MOUSE: {
                break;
            }
            default: {
                this.debugDraw.drawSegment(x1, p1, this.color);
                this.debugDraw.drawSegment(p1, p2, this.color);
                this.debugDraw.drawSegment(x2, p2, this.color);
            }
        }
        this.pool.pushVec2(2);
    }

    private void drawShape(Fixture fixture, Transform xf, Color3f color, boolean wireframe) {
        switch (fixture.getType()) {
            case CIRCLE: {
                CircleShape circle = (CircleShape)fixture.getShape();
                Transform.mulToOutUnsafe(xf, circle.p, this.center);
                float radius = circle.radius;
                xf.q.getXAxis(this.axis);
                if (fixture.getUserData() != null && fixture.getUserData().equals(LIQUID_INT)) {
                    Body b = fixture.getBody();
                    this.liquidOffset.set(b.linearVelocity);
                    float linVelLength = b.linearVelocity.length();
                    this.averageLinearVel = this.averageLinearVel == -1.0f ? linVelLength : 0.98f * this.averageLinearVel + 0.02f * linVelLength;
                    float liquidLength = 0.12f;
                    this.liquidOffset.mulLocal(liquidLength / this.averageLinearVel / 2.0f);
                    this.circCenterMoved.set(this.center).addLocal(this.liquidOffset);
                    this.center.subLocal(this.liquidOffset);
                    this.debugDraw.drawSegment(this.center, this.circCenterMoved, this.liquidColor);
                    return;
                }
                if (wireframe) {
                    this.debugDraw.drawCircle(this.center, radius, this.axis, color);
                    break;
                }
                this.debugDraw.drawSolidCircle(this.center, radius, this.axis, color);
                break;
            }
            case POLYGON: {
                PolygonShape poly = (PolygonShape)fixture.getShape();
                int vertexCount = poly.count;
                assert (vertexCount <= Settings.maxPolygonVertices);
                Vec2[] vertices = this.tlvertices.get(Settings.maxPolygonVertices);
                for (int i = 0; i < vertexCount; ++i) {
                    Transform.mulToOutUnsafe(xf, poly.vertices[i], vertices[i]);
                }
                if (wireframe) {
                    this.debugDraw.drawPolygon(vertices, vertexCount, color);
                    break;
                }
                this.debugDraw.drawSolidPolygon(vertices, vertexCount, color);
                break;
            }
            case EDGE: {
                EdgeShape edge = (EdgeShape)fixture.getShape();
                Transform.mulToOutUnsafe(xf, edge.vertex1, this.v1);
                Transform.mulToOutUnsafe(xf, edge.vertex2, this.v2);
                this.debugDraw.drawSegment(this.v1, this.v2, color);
                break;
            }
            case CHAIN: {
                ChainShape chain = (ChainShape)fixture.getShape();
                int count = chain.count;
                Vec2[] vertices = chain.vertices;
                Transform.mulToOutUnsafe(xf, vertices[0], this.v1);
                for (int i = 1; i < count; ++i) {
                    Transform.mulToOutUnsafe(xf, vertices[i], this.v2);
                    this.debugDraw.drawSegment(this.v1, this.v2, color);
                    this.debugDraw.drawCircle(this.v1, 0.05f, color);
                    this.v1.set(this.v2);
                }
                break;
            }
        }
    }

    private void drawParticleSystem(ParticleSystem system) {
        boolean wireframe = (this.debugDraw.getFlags() & 0x80) != 0;
        int particleCount = system.getParticleCount();
        if (particleCount != 0) {
            float particleRadius = system.getParticleRadius();
            Vec2[] positionBuffer = system.getParticlePositionBuffer();
            ParticleColor[] colorBuffer = null;
            if (system.colorBuffer.data != null) {
                colorBuffer = system.getParticleColorBuffer();
            }
            if (wireframe) {
                this.debugDraw.drawParticlesWireframe(positionBuffer, particleRadius, colorBuffer, particleCount);
            } else {
                this.debugDraw.drawParticles(positionBuffer, particleRadius, colorBuffer, particleCount);
            }
        }
    }

    public int createParticle(ParticleDef def) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return 0;
        }
        return this.particleSystem.createParticle(def);
    }

    public void destroyParticle(int index) {
        this.destroyParticle(index, false);
    }

    public void destroyParticle(int index, boolean callDestructionListener) {
        this.particleSystem.destroyParticle(index, callDestructionListener);
    }

    public int destroyParticlesInShape(Shape shape, Transform xf) {
        return this.destroyParticlesInShape(shape, xf, false);
    }

    public int destroyParticlesInShape(Shape shape, Transform xf, boolean callDestructionListener) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return 0;
        }
        return this.particleSystem.destroyParticlesInShape(shape, xf, callDestructionListener);
    }

    public ParticleGroup createParticleGroup(ParticleGroupDef def) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return null;
        }
        return this.particleSystem.createParticleGroup(def);
    }

    public void joinParticleGroups(ParticleGroup groupA, ParticleGroup groupB) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return;
        }
        this.particleSystem.joinParticleGroups(groupA, groupB);
    }

    public void destroyParticlesInGroup(ParticleGroup group, boolean callDestructionListener) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return;
        }
        this.particleSystem.destroyParticlesInGroup(group, callDestructionListener);
    }

    public void destroyParticlesInGroup(ParticleGroup group) {
        this.destroyParticlesInGroup(group, false);
    }

    public ParticleGroup[] getParticleGroupList() {
        return this.particleSystem.getParticleGroupList();
    }

    public int getParticleGroupCount() {
        return this.particleSystem.getParticleGroupCount();
    }

    public int getParticleCount() {
        return this.particleSystem.getParticleCount();
    }

    public int getParticleMaxCount() {
        return this.particleSystem.getParticleMaxCount();
    }

    public void setParticleMaxCount(int count) {
        this.particleSystem.setParticleMaxCount(count);
    }

    public void setParticleDensity(float density) {
        this.particleSystem.setParticleDensity(density);
    }

    public float getParticleDensity() {
        return this.particleSystem.getParticleDensity();
    }

    public void setParticleGravityScale(float gravityScale) {
        this.particleSystem.setParticleGravityScale(gravityScale);
    }

    public float getParticleGravityScale() {
        return this.particleSystem.getParticleGravityScale();
    }

    public void setParticleDamping(float damping) {
        this.particleSystem.setParticleDamping(damping);
    }

    public float getParticleDamping() {
        return this.particleSystem.getParticleDamping();
    }

    public void setParticleRadius(float radius) {
        this.particleSystem.setParticleRadius(radius);
    }

    public float getParticleRadius() {
        return this.particleSystem.getParticleRadius();
    }

    public int[] getParticleFlagsBuffer() {
        return this.particleSystem.getParticleFlagsBuffer();
    }

    public Vec2[] getParticlePositionBuffer() {
        return this.particleSystem.getParticlePositionBuffer();
    }

    public Vec2[] getParticleVelocityBuffer() {
        return this.particleSystem.getParticleVelocityBuffer();
    }

    public ParticleColor[] getParticleColorBuffer() {
        return this.particleSystem.getParticleColorBuffer();
    }

    public ParticleGroup[] getParticleGroupBuffer() {
        return this.particleSystem.getParticleGroupBuffer();
    }

    public Object[] getParticleUserDataBuffer() {
        return this.particleSystem.getParticleUserDataBuffer();
    }

    public void setParticleFlagsBuffer(int[] buffer, int capacity) {
        this.particleSystem.setParticleFlagsBuffer(buffer, capacity);
    }

    public void setParticlePositionBuffer(Vec2[] buffer, int capacity) {
        this.particleSystem.setParticlePositionBuffer(buffer, capacity);
    }

    public void setParticleVelocityBuffer(Vec2[] buffer, int capacity) {
        this.particleSystem.setParticleVelocityBuffer(buffer, capacity);
    }

    public void setParticleColorBuffer(ParticleColor[] buffer, int capacity) {
        this.particleSystem.setParticleColorBuffer(buffer, capacity);
    }

    public void setParticleUserDataBuffer(Object[] buffer, int capacity) {
        this.particleSystem.setParticleUserDataBuffer(buffer, capacity);
    }

    public ParticleContact[] getParticleContacts() {
        return this.particleSystem.contactBuffer;
    }

    public int getParticleContactCount() {
        return this.particleSystem.contactCount;
    }

    public ParticleBodyContact[] getParticleBodyContacts() {
        return this.particleSystem.bodyContactBuffer;
    }

    public int getParticleBodyContactCount() {
        return this.particleSystem.bodyContactCount;
    }

    public float computeParticleCollisionEnergy() {
        return this.particleSystem.computeParticleCollisionEnergy();
    }
}

