/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics.contacts;

import de.pirckheimer_gymnasium.jbox2d.callbacks.ContactListener;
import de.pirckheimer_gymnasium.jbox2d.collision.ContactID;
import de.pirckheimer_gymnasium.jbox2d.collision.Manifold;
import de.pirckheimer_gymnasium.jbox2d.collision.ManifoldPoint;
import de.pirckheimer_gymnasium.jbox2d.collision.WorldManifold;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.Shape;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Transform;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Body;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Fixture;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.ContactEdge;
import de.pirckheimer_gymnasium.jbox2d.pooling.IWorldPool;

public abstract class Contact {
    public static final int ISLAND_FLAG = 1;
    public static final int TOUCHING_FLAG = 2;
    public static final int ENABLED_FLAG = 4;
    public static final int FILTER_FLAG = 8;
    public static final int BULLET_HIT_FLAG = 16;
    public static final int TOI_FLAG = 32;
    public int flags;
    public Contact prev;
    public Contact next;
    public ContactEdge nodeA;
    public ContactEdge nodeB;
    public Fixture fixtureA = null;
    public Fixture fixtureB = null;
    public int indexA;
    public int indexB;
    public final Manifold manifold;
    public float toiCount;
    public float toi;
    public float friction;
    public float restitution;
    public float tangentSpeed;
    protected final IWorldPool pool;
    private final Manifold oldManifold = new Manifold();

    protected Contact(IWorldPool argPool) {
        this.nodeA = new ContactEdge();
        this.nodeB = new ContactEdge();
        this.manifold = new Manifold();
        this.pool = argPool;
    }

    public void init(Fixture fA, int indexA, Fixture fB, int indexB) {
        this.flags = 4;
        this.fixtureA = fA;
        this.fixtureB = fB;
        this.indexA = indexA;
        this.indexB = indexB;
        this.manifold.pointCount = 0;
        this.prev = null;
        this.next = null;
        this.nodeA.contact = null;
        this.nodeA.prev = null;
        this.nodeA.next = null;
        this.nodeA.other = null;
        this.nodeB.contact = null;
        this.nodeB.prev = null;
        this.nodeB.next = null;
        this.nodeB.other = null;
        this.toiCount = 0.0f;
        this.friction = Contact.mixFriction(fA.friction, fB.friction);
        this.restitution = Contact.mixRestitution(fA.restitution, fB.restitution);
        this.tangentSpeed = 0.0f;
    }

    public Manifold getManifold() {
        return this.manifold;
    }

    public void getWorldManifold(WorldManifold worldManifold) {
        Body bodyA = this.fixtureA.getBody();
        Body bodyB = this.fixtureB.getBody();
        Shape shapeA = this.fixtureA.getShape();
        Shape shapeB = this.fixtureB.getShape();
        worldManifold.initialize(this.manifold, bodyA.getTransform(), shapeA.radius, bodyB.getTransform(), shapeB.radius);
    }

    public boolean isTouching() {
        return (this.flags & 2) == 2;
    }

    public void setEnabled(boolean flag) {
        this.flags = flag ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public boolean isEnabled() {
        return (this.flags & 4) == 4;
    }

    public Contact getNext() {
        return this.next;
    }

    public Fixture getFixtureA() {
        return this.fixtureA;
    }

    public int getChildIndexA() {
        return this.indexA;
    }

    public Fixture getFixtureB() {
        return this.fixtureB;
    }

    public int getChildIndexB() {
        return this.indexB;
    }

    public void setFriction(float friction) {
        this.friction = friction;
    }

    public float getFriction() {
        return this.friction;
    }

    public void resetFriction() {
        this.friction = Contact.mixFriction(this.fixtureA.friction, this.fixtureB.friction);
    }

    public void setRestitution(float restitution) {
        this.restitution = restitution;
    }

    public float getRestitution() {
        return this.restitution;
    }

    public void resetRestitution() {
        this.restitution = Contact.mixRestitution(this.fixtureA.restitution, this.fixtureB.restitution);
    }

    public void setTangentSpeed(float speed) {
        this.tangentSpeed = speed;
    }

    public float getTangentSpeed() {
        return this.tangentSpeed;
    }

    public abstract void evaluate(Manifold var1, Transform var2, Transform var3);

    public void flagForFiltering() {
        this.flags |= 8;
    }

    public void update(ContactListener listener) {
        boolean touching;
        this.oldManifold.set(this.manifold);
        this.flags |= 4;
        boolean wasTouching = (this.flags & 2) == 2;
        boolean sensorA = this.fixtureA.isSensor();
        boolean sensorB = this.fixtureB.isSensor();
        boolean sensor = sensorA || sensorB;
        Body bodyA = this.fixtureA.getBody();
        Body bodyB = this.fixtureB.getBody();
        Transform xfA = bodyA.getTransform();
        Transform xfB = bodyB.getTransform();
        if (sensor) {
            Shape shapeA = this.fixtureA.getShape();
            Shape shapeB = this.fixtureB.getShape();
            touching = this.pool.getCollision().testOverlap(shapeA, this.indexA, shapeB, this.indexB, xfA, xfB);
            this.manifold.pointCount = 0;
        } else {
            this.evaluate(this.manifold, xfA, xfB);
            touching = this.manifold.pointCount > 0;
            block0: for (int i = 0; i < this.manifold.pointCount; ++i) {
                ManifoldPoint mp2 = this.manifold.points[i];
                mp2.normalImpulse = 0.0f;
                mp2.tangentImpulse = 0.0f;
                ContactID id2 = mp2.id;
                for (int j = 0; j < this.oldManifold.pointCount; ++j) {
                    ManifoldPoint mp1 = this.oldManifold.points[j];
                    if (!mp1.id.isEqual(id2)) continue;
                    mp2.normalImpulse = mp1.normalImpulse;
                    mp2.tangentImpulse = mp1.tangentImpulse;
                    continue block0;
                }
            }
            if (touching != wasTouching) {
                bodyA.setAwake(true);
                bodyB.setAwake(true);
            }
        }
        this.flags = touching ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        if (listener == null) {
            return;
        }
        if (!wasTouching && touching) {
            listener.beginContact(this);
        }
        if (wasTouching && !touching) {
            listener.endContact(this);
        }
        if (!sensor && touching) {
            listener.preSolve(this, this.oldManifold);
        }
    }

    public static float mixFriction(float friction1, float friction2) {
        return MathUtils.sqrt(friction1 * friction2);
    }

    public static float mixRestitution(float restitution1, float restitution2) {
        return Math.max(restitution1, restitution2);
    }
}

