/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics.joints;

import de.pirckheimer_gymnasium.jbox2d.common.Mat22;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Transform;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.SolverData;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.Joint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.MouseJointDef;
import de.pirckheimer_gymnasium.jbox2d.pooling.IWorldPool;

public class MouseJoint
extends Joint {
    private final Vec2 localAnchorB = new Vec2();
    private final Vec2 targetA = new Vec2();
    private float frequencyHz;
    private float dampingRatio;
    private float beta;
    private final Vec2 impulse = new Vec2();
    private float maxForce;
    private float gamma;
    private int indexB;
    private final Vec2 rB = new Vec2();
    private final Vec2 localCenterB = new Vec2();
    private float invMassB;
    private float invIB;
    private final Mat22 mass = new Mat22();
    private final Vec2 C = new Vec2();

    protected MouseJoint(IWorldPool argWorld, MouseJointDef def) {
        super(argWorld, def);
        assert (def.target.isValid());
        assert (def.maxForce >= 0.0f);
        assert (def.frequencyHz >= 0.0f);
        assert (def.dampingRatio >= 0.0f);
        this.targetA.set(def.target);
        Transform.mulTransToOutUnsafe(this.bodyB.getTransform(), this.targetA, this.localAnchorB);
        this.maxForce = def.maxForce;
        this.impulse.setZero();
        this.frequencyHz = def.frequencyHz;
        this.dampingRatio = def.dampingRatio;
        this.beta = 0.0f;
        this.gamma = 0.0f;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        argOut.set(this.targetA);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.bodyB.getWorldPointToOut(this.localAnchorB, argOut);
    }

    @Override
    public void getReactionForce(float invDt, Vec2 argOut) {
        argOut.set(this.impulse).mulLocal(invDt);
    }

    @Override
    public float getReactionTorque(float invDt) {
        return invDt * 0.0f;
    }

    public void setTarget(Vec2 target) {
        if (!this.bodyB.isAwake()) {
            this.bodyB.setAwake(true);
        }
        this.targetA.set(target);
    }

    public Vec2 getTarget() {
        return this.targetA;
    }

    public void setMaxForce(float force) {
        this.maxForce = force;
    }

    public float getMaxForce() {
        return this.maxForce;
    }

    public void setFrequency(float hz) {
        this.frequencyHz = hz;
    }

    public float getFrequency() {
        return this.frequencyHz;
    }

    public void setDampingRatio(float ratio) {
        this.dampingRatio = ratio;
    }

    public float getDampingRatio() {
        return this.dampingRatio;
    }

    @Override
    public void initVelocityConstraints(SolverData data) {
        this.indexB = this.bodyB.islandIndex;
        this.localCenterB.set(this.bodyB.sweep.localCenter);
        this.invMassB = this.bodyB.invMass;
        this.invIB = this.bodyB.invI;
        Vec2 cB = data.positions[this.indexB].c;
        float aB = data.positions[this.indexB].a;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        Rot qB = this.pool.popRot();
        qB.set(aB);
        float mass = this.bodyB.getMass();
        float omega = (float)Math.PI * 2 * this.frequencyHz;
        float d = 2.0f * mass * this.dampingRatio * omega;
        float k = mass * (omega * omega);
        float h = data.step.dt;
        assert (d + h * k > 1.1920929E-7f);
        this.gamma = h * (d + h * k);
        if (this.gamma != 0.0f) {
            this.gamma = 1.0f / this.gamma;
        }
        this.beta = h * k * this.gamma;
        Vec2 temp = this.pool.popVec2();
        Rot.mulToOutUnsafe(qB, temp.set(this.localAnchorB).subLocal(this.localCenterB), this.rB);
        Mat22 K = this.pool.popMat22();
        K.ex.x = this.invMassB + this.invIB * this.rB.y * this.rB.y + this.gamma;
        K.ey.x = K.ex.y = -this.invIB * this.rB.x * this.rB.y;
        K.ey.y = this.invMassB + this.invIB * this.rB.x * this.rB.x + this.gamma;
        K.invertToOut(this.mass);
        this.C.set(cB).addLocal(this.rB).subLocal(this.targetA);
        this.C.mulLocal(this.beta);
        wB *= 0.98f;
        if (data.step.warmStarting) {
            this.impulse.mulLocal(data.step.dtRatio);
            vB.x += this.invMassB * this.impulse.x;
            vB.y += this.invMassB * this.impulse.y;
            wB += this.invIB * Vec2.cross(this.rB, this.impulse);
        } else {
            this.impulse.setZero();
        }
        data.velocities[this.indexB].w = wB;
        this.pool.pushVec2(1);
        this.pool.pushMat22(1);
        this.pool.pushRot(1);
    }

    @Override
    public boolean solvePositionConstraints(SolverData data) {
        return true;
    }

    @Override
    public void solveVelocityConstraints(SolverData data) {
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        Vec2 Cdot = this.pool.popVec2();
        Vec2.crossToOutUnsafe(wB, this.rB, Cdot);
        Cdot.addLocal(vB);
        Vec2 impulse = this.pool.popVec2();
        Vec2 temp = this.pool.popVec2();
        temp.set(this.impulse).mulLocal(this.gamma).addLocal(this.C).addLocal(Cdot).negateLocal();
        Mat22.mulToOutUnsafe(this.mass, temp, impulse);
        temp.set(this.impulse);
        this.impulse.addLocal(impulse);
        float maxImpulse = data.step.dt * this.maxForce;
        if (this.impulse.lengthSquared() > maxImpulse * maxImpulse) {
            this.impulse.mulLocal(maxImpulse / this.impulse.length());
        }
        impulse.set(this.impulse).subLocal(temp);
        vB.x += this.invMassB * impulse.x;
        vB.y += this.invMassB * impulse.y;
        data.velocities[this.indexB].w = wB += this.invIB * Vec2.cross(this.rB, impulse);
        this.pool.pushVec2(3);
    }
}

